/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Engine;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.WeaponType;

public class SmallCraft
extends Aero
implements Serializable {
    private static final long serialVersionUID = 6708788176436555036L;
    protected static String[] LOCATION_ABBRS = new String[]{"NOS", "LS", "RS", "AFT"};
    protected static String[] LOCATION_NAMES = new String[]{"Nose", "Left Side", "Right Side", "Aft"};
    private int nCrew = 0;
    private int nPassenger = 0;

    public void setNCrew(int n) {
        this.nCrew = n;
    }

    public void setNPassenger(int n) {
        this.nPassenger = n;
    }

    public int getNCrew() {
        return this.nCrew;
    }

    public int getNPassenger() {
        return this.nPassenger;
    }

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public int locations() {
        return 4;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public HitData rollHitLocation(int n, int n2) {
        int n3 = Compute.d6(2);
        if (n == 4 || n == 5) {
            int n4 = 2;
            int n5 = Compute.d6(1);
            if (n5 > 3) {
                n4 = 1;
            }
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(1);
                    return new HitData(0, false, 0);
                }
                case 4: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 5: {
                    this.setPotCrit(17);
                    if (n5 > 3) {
                        this.setPotCrit(16);
                    }
                    return new HitData(n4, false, 0);
                }
                case 6: {
                    this.setPotCrit(11);
                    return new HitData(n4, false, 0);
                }
                case 7: {
                    this.setPotCrit(2);
                    return new HitData(n4, false, 0);
                }
                case 8: {
                    this.setPotCrit(13);
                    return new HitData(n4, false, 0);
                }
                case 9: {
                    this.setPotCrit(17);
                    if (n5 > 3) {
                        this.setPotCrit(16);
                    }
                    return new HitData(n4, false, 0);
                }
                case 10: {
                    this.setPotCrit(8);
                    return new HitData(3, false, 0);
                }
                case 11: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
            }
        }
        if (n2 == 0) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(0);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(8);
                    return new HitData(0, false, 0);
                }
                case 4: {
                    this.setPotCrit(2);
                    return new HitData(2, false, 0);
                }
                case 5: {
                    this.setPotCrit(17);
                    return new HitData(2, false, 0);
                }
                case 6: {
                    this.setPotCrit(1);
                    return new HitData(0, false, 0);
                }
                case 7: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 8: {
                    this.setPotCrit(3);
                    return new HitData(0, false, 0);
                }
                case 9: {
                    this.setPotCrit(16);
                    return new HitData(1, false, 0);
                }
                case 10: {
                    this.setPotCrit(2);
                    return new HitData(1, false, 0);
                }
                case 11: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 12: {
                    this.setPotCrit(14);
                    return new HitData(0, false, 0);
                }
            }
        } else if (n2 == 2) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(1);
                    return new HitData(0, false, 0);
                }
                case 4: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 5: {
                    this.setPotCrit(16);
                    return new HitData(1, false, 0);
                }
                case 6: {
                    this.setPotCrit(11);
                    return new HitData(1, false, 0);
                }
                case 7: {
                    this.setPotCrit(2);
                    return new HitData(1, false, 0);
                }
                case 8: {
                    this.setPotCrit(13);
                    return new HitData(1, false, 0);
                }
                case 9: {
                    this.setPotCrit(16);
                    return new HitData(1, false, 0);
                }
                case 10: {
                    this.setPotCrit(8);
                    return new HitData(3, false, 0);
                }
                case 11: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
            }
        } else if (n2 == 3) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(1);
                    return new HitData(0, false, 0);
                }
                case 4: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 5: {
                    this.setPotCrit(17);
                    return new HitData(2, false, 0);
                }
                case 6: {
                    this.setPotCrit(11);
                    return new HitData(2, false, 0);
                }
                case 7: {
                    this.setPotCrit(2);
                    return new HitData(2, false, 0);
                }
                case 8: {
                    this.setPotCrit(13);
                    return new HitData(2, false, 0);
                }
                case 9: {
                    this.setPotCrit(17);
                    return new HitData(2, false, 0);
                }
                case 10: {
                    this.setPotCrit(8);
                    return new HitData(3, false, 0);
                }
                case 11: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
            }
        } else if (n2 == 1) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(15);
                    return new HitData(3, false, 0);
                }
                case 3: {
                    this.setPotCrit(3);
                    return new HitData(3, false, 0);
                }
                case 4: {
                    this.setPotCrit(2);
                    return new HitData(2, false, 0);
                }
                case 5: {
                    this.setPotCrit(13);
                    return new HitData(2, false, 0);
                }
                case 6: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 7: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
                case 8: {
                    this.setPotCrit(12);
                    return new HitData(3, false, 0);
                }
                case 9: {
                    this.setPotCrit(13);
                    return new HitData(1, false, 0);
                }
                case 10: {
                    this.setPotCrit(2);
                    return new HitData(1, false, 0);
                }
                case 11: {
                    this.setPotCrit(9);
                    return new HitData(3, false, 0);
                }
                case 12: {
                    this.setPotCrit(7);
                    return new HitData(3, false, 0);
                }
            }
        }
        return new HitData(0, false, 0);
    }

    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        int n2 = 11;
        if (!this.isSpheroid()) {
            switch (mounted.getLocation()) {
                case 0: {
                    n2 = 11;
                    break;
                }
                case 2: {
                    if (mounted.isRearMounted()) {
                        n2 = 15;
                        break;
                    }
                    n2 = 13;
                    break;
                }
                case 1: {
                    if (mounted.isRearMounted()) {
                        n2 = 14;
                        break;
                    }
                    n2 = 12;
                    break;
                }
                case 3: {
                    n2 = 22;
                    break;
                }
                default: {
                    n2 = 0;
                    break;
                }
            }
        } else {
            switch (mounted.getLocation()) {
                case 0: {
                    n2 = 11;
                    break;
                }
                case 2: {
                    if (mounted.isRearMounted()) {
                        n2 = 19;
                        break;
                    }
                    n2 = 17;
                    break;
                }
                case 1: {
                    if (mounted.isRearMounted()) {
                        n2 = 18;
                        break;
                    }
                    n2 = 16;
                    break;
                }
                case 3: {
                    n2 = 22;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
        }
        return this.rollArcs(n2);
    }

    public int getArcswGuns() {
        int n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            if (this.hasWeaponInArc(i, false)) {
                ++n;
            }
            if (!this.hasWeaponInArc(i, true)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasWeaponInArc(int n, boolean bl) {
        boolean bl2 = false;
        for (Mounted mounted : this.getWeaponList()) {
            if (mounted.getLocation() != n || mounted.isRearMounted() != bl) continue;
            bl2 = true;
        }
        return bl2;
    }

    public double getArmorWeight() {
        int n = this.getTotalOArmor();
        n -= this.getSI() * this.locations();
        double d = 16.0;
        if (this.isClan()) {
            d = 20.0;
        }
        if (this.isSpheroid()) {
            if (this.weight >= 12500.0f) {
                d = 14.0;
                if (this.isClan()) {
                    d = 17.0;
                }
            } else if (this.weight >= 20000.0f) {
                d = 12.0;
                if (this.isClan()) {
                    d = 14.0;
                }
            } else if (this.weight >= 35000.0f) {
                d = 10.0;
                if (this.isClan()) {
                    d = 12.0;
                }
            } else if (this.weight >= 50000.0f) {
                d = 8.0;
                if (this.isClan()) {
                    d = 10.0;
                }
            } else if (this.weight >= 65000.0f) {
                d = 6.0;
                if (this.isClan()) {
                    d = 7.0;
                }
            }
        } else if (this.weight >= 6000.0f) {
            d = 14.0;
            if (this.isClan()) {
                d = 17.0;
            }
        } else if (this.weight >= 9500.0f) {
            d = 12.0;
            if (this.isClan()) {
                d = 14.0;
            }
        } else if (this.weight >= 12500.0f) {
            d = 10.0;
            if (this.isClan()) {
                d = 12.0;
            }
        } else if (this.weight >= 17500.0f) {
            d = 8.0;
            if (this.isClan()) {
                d = 10.0;
            }
        } else if (this.weight >= 25000.0f) {
            d = 6.0;
            if (this.isClan()) {
                d = 7.0;
            }
        }
        double d2 = d * EquipmentType.getArmorPointMultiplier(this.armorType, this.techLevel);
        double d3 = 0.0;
        while ((int)Math.round(d3 * d2) < n) {
            d3 += 0.5;
        }
        return d3;
    }

    public double getCost() {
        double d = 0.0;
        d += (double)(200000.0f + 10.0f * this.weight);
        d += 200000.0;
        d += (double)(5000 * (this.getNCrew() + this.getNPassenger()));
        d += 80000.0;
        d += 100000.0;
        d += (double)(10000 * this.getArcswGuns());
        d += (double)(100000 * this.getSI());
        d += (double)(25000.0f + 10.0f * this.getWeight());
        double d2 = 0.065;
        if (this.isClan()) {
            d2 = 0.061;
        }
        double d3 = (double)((float)this.getOriginalWalkMP() * this.weight) * d2;
        d += d3 * 1000.0;
        d += (double)((float)(500 * this.getOriginalWalkMP()) * this.weight) / 100.0;
        d += (double)(200 * this.getFuel()) / 80.0;
        d += this.getArmorWeight() * EquipmentType.getArmorCost(this.armorType);
        int n = 2000 + 4000 * this.getHeatType();
        d += (double)(n * this.getHeatSinks());
        double d4 = 1.0f + this.weight / 50.0f;
        return Math.round((d += (double)this.getWeaponsAndEquipmentCost()) * d4);
    }

    public int getMaxEngineHits() {
        return 6;
    }

    public double getBVTypeModifier() {
        return 1.0;
    }

    public boolean loadWeapon(Mounted mounted, Mounted mounted2) {
        boolean bl = false;
        WeaponType weaponType = (WeaponType)mounted.getType();
        AmmoType ammoType = (AmmoType)mounted2.getType();
        if (mounted.getLocation() != mounted2.getLocation()) {
            return bl;
        }
        if (mounted2.isAmmoUsable() && !weaponType.hasFlag(16384L) && ammoType.getAmmoType() == weaponType.getAmmoType() && ammoType.getRackSize() == weaponType.getRackSize()) {
            mounted.setLinked(mounted2);
            bl = true;
        }
        return bl;
    }

    public int getTotalCommGearTons() {
        return 3 + this.getExtraCommGearTons();
    }

    public boolean hasActiveECM() {
        if (!this.game.getOptions().booleanOption("stratops_ecm") || !this.game.getBoard().inSpace()) {
            return super.hasActiveECM();
        }
        return this.getECMRange() >= 0;
    }

    public int getECMRange() {
        if (!this.game.getOptions().booleanOption("stratops_ecm") || !this.game.getBoard().inSpace()) {
            return super.getECMRange();
        }
        if (!this.isMilitary()) {
            return -1;
        }
        int n = -1;
        if (!this.isShutDown()) {
            for (Mounted mounted : this.getMisc()) {
                EquipmentType equipmentType = mounted.getType();
                if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x80000000000L) || mounted.isInoperable()) continue;
                if (equipmentType.hasFlag(0x40000000000000L)) {
                    ++n;
                    break;
                }
                n += 2;
                break;
            }
        }
        n = n - this.getFCSHits() - this.getSensorHits();
        return n;
    }

    public boolean isCrewProtected() {
        return this.isMilitary() && this.getOriginalWalkMP() > 4;
    }
}

