/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeArgumentsNotAllowedExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTypeArgumentsNotAllowedExpressionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeArgumentsNotAllowedExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeArgumentsNotAllowedExpressionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1761#2,3:44\n*S KotlinDebug\n*F\n+ 1 FirTypeArgumentsNotAllowedExpressionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeArgumentsNotAllowedExpressionChecker\n*L\n34#1:44,3\n*E\n"})
public final class FirTypeArgumentsNotAllowedExpressionChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirTypeArgumentsNotAllowedExpressionChecker INSTANCE = new FirTypeArgumentsNotAllowedExpressionChecker();

    private FirTypeArgumentsNotAllowedExpressionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        FirExpression explicitReceiver;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        FirExpression firExpression = expression2.getExplicitReceiver();
        FirExpression firExpression2 = explicitReceiver = firExpression != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression) : null;
        if (explicitReceiver instanceof FirResolvedQualifier && ((FirResolvedQualifier)explicitReceiver).getSymbol() == null && !((Collection)((FirResolvedQualifier)explicitReceiver).getTypeArguments()).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirResolvedQualifier)explicitReceiver).getSource(), FirErrors.INSTANCE.getTYPE_ARGUMENTS_NOT_ALLOWED(), (Object)"for packages", null, 16, null);
            return;
        }
        if (expression2 instanceof FirImplicitInvokeCall && explicitReceiver instanceof FirPropertyAccessExpression) {
            boolean bl;
            block8: {
                Iterable $this$any$iv = ((FirImplicitInvokeCall)expression2).getTypeArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeProjection it = (FirTypeProjection)element$iv;
                        boolean bl2 = false;
                        if (!FirHelpersKt.isExplicit(it)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(expression2);
                boolean bl3 = firCallableSymbol != null && (firCallableSymbol = firCallableSymbol.getTypeParameterSymbols()) != null ? !((Collection)((Object)firCallableSymbol)).isEmpty() : false;
                if (bl3) {
                    FirCallableSymbol<?> firCallableSymbol2 = ReferenceUtilsKt.toResolvedCallableSymbol((FirResolvable)((Object)explicitReceiver));
                    boolean bl4 = firCallableSymbol2 != null && (firCallableSymbol2 = firCallableSymbol2.getTypeParameterSymbols()) != null ? !((Collection)((Object)firCallableSymbol2)).isEmpty() : false;
                    if (bl4) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirImplicitInvokeCall)expression2).getCalleeReference().getSource(), FirErrors.INSTANCE.getTYPE_ARGUMENTS_NOT_ALLOWED(), (Object)"on implicit invoke call", null, 16, null);
                        return;
                    }
                }
            }
        }
    }
}

