/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.math.BigDecimal;
import java.net.URI;
import java.text.DecimalFormat;
import pcgen.cdom.base.Loadable;

public final class UnitSet
implements Loadable {
    private DecimalFormat distanceDisplayPattern;
    private String distanceUnit;
    private DecimalFormat heightDisplayPattern;
    private String heightUnit;
    private String name;
    private DecimalFormat weightDisplayPattern;
    private String weightUnit;
    private BigDecimal distanceFactor;
    private BigDecimal heightFactor;
    private BigDecimal weightFactor;
    private boolean isInternal = false;
    private URI sourceURI;

    public void setDistanceDisplayPattern(DecimalFormat dd) {
        this.distanceDisplayPattern = dd;
    }

    public void setDistanceFactor(BigDecimal df) {
        this.distanceFactor = df;
    }

    public void setDistanceUnit(String du) {
        this.distanceUnit = du;
    }

    public String getDistanceUnit() {
        return this.getUnit(this.distanceUnit);
    }

    public void setHeightDisplayPattern(DecimalFormat hd) {
        this.heightDisplayPattern = hd;
    }

    public void setHeightFactor(BigDecimal hf) {
        this.heightFactor = hf;
    }

    public void setHeightUnit(String hu) {
        this.heightUnit = hu;
    }

    public String getHeightUnit() {
        return this.getUnit(this.heightUnit);
    }

    @Override
    public void setName(String n) {
        this.name = n;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    public void setWeightDisplayPattern(DecimalFormat wd) {
        this.weightDisplayPattern = wd;
    }

    public void setWeightFactor(BigDecimal wf) {
        this.weightFactor = wf;
    }

    public void setWeightUnit(String wu) {
        this.weightUnit = wu;
    }

    public String getWeightUnit() {
        return this.getUnit(this.weightUnit);
    }

    private String getUnit(String unitString) {
        if ("ftin".equals(unitString)) {
            return unitString;
        }
        if (unitString.startsWith("~")) {
            return unitString.substring(1);
        }
        return " " + unitString;
    }

    public double convertDistanceToUnitSet(double distanceInFeet) {
        return distanceInFeet * this.distanceFactor.doubleValue();
    }

    public int convertHeightFromUnitSet(double height) {
        double heightInInches = height / this.heightFactor.doubleValue();
        return (int)heightInInches;
    }

    public double convertHeightToUnitSet(int heightInInches) {
        return (double)heightInInches * this.heightFactor.doubleValue();
    }

    public double convertWeightFromUnitSet(double weight) {
        double weightInPounds = weight / this.weightFactor.doubleValue();
        return weightInPounds;
    }

    public double convertWeightToUnitSet(double weightInPounds) {
        return weightInPounds * this.weightFactor.doubleValue();
    }

    public int convertWeightToUnitSet(int weightInPounds) {
        double weight = (double)weightInPounds * this.weightFactor.doubleValue();
        return (int)weight;
    }

    public String displayDistanceInUnitSet(double distanceInFeet) {
        return this.distanceDisplayPattern.format(this.convertDistanceToUnitSet(distanceInFeet));
    }

    public String displayHeightInUnitSet(int heightInInches) {
        return this.heightDisplayPattern.format(this.convertHeightToUnitSet(heightInInches));
    }

    public String displayWeightInUnitSet(double weightInPounds) {
        return this.weightDisplayPattern.format(this.convertWeightToUnitSet(weightInPounds));
    }

    @Override
    public URI getSourceURI() {
        return this.sourceURI;
    }

    @Override
    public void setSourceURI(URI source) {
        this.sourceURI = source;
    }

    @Override
    public String getKeyName() {
        return this.getDisplayName();
    }

    @Override
    public String getLSTformat() {
        return this.getDisplayName();
    }

    @Override
    public boolean isInternal() {
        return this.isInternal;
    }

    @Override
    public boolean isType(String type) {
        return false;
    }

    public void setInternal(boolean internal) {
        this.isInternal = internal;
    }

    public String getRawWeightUnit() {
        return this.weightUnit;
    }

    public String getRawHeightUnit() {
        return this.heightUnit;
    }

    public String getRawDistanceUnit() {
        return this.distanceUnit;
    }

    public DecimalFormat getWeightDisplayPattern() {
        return this.weightDisplayPattern;
    }

    public DecimalFormat getHeightDisplayPattern() {
        return this.heightDisplayPattern;
    }

    public DecimalFormat getDistanceDisplayPattern() {
        return this.distanceDisplayPattern;
    }

    public BigDecimal getDistanceFactor() {
        return this.distanceFactor;
    }

    public BigDecimal getHeightFactor() {
        return this.heightFactor;
    }

    public BigDecimal getWeightFactor() {
        return this.weightFactor;
    }
}

