/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.MasterListInterface;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.spell.Spell;

public class SpellLevel {
    public static boolean levelForKeyContains(Spell sp, List<? extends CDOMList<Spell>> lists, int levelMatch, PlayerCharacter aPC) {
        if (lists == null || aPC == null) {
            return false;
        }
        TreeSet resultList = new TreeSet();
        HashMapToList<CDOMList<Spell>, Integer> pcli = aPC.getSpellLevelInfo(sp);
        for (CDOMList<Spell> cDOMList : lists) {
            List levels = pcli.getListFor(cDOMList);
            if (levels == null) continue;
            resultList.addAll(levels);
        }
        return levelMatch == -1 && !resultList.isEmpty() || levelMatch >= 0 && resultList.contains(levelMatch);
    }

    public static Integer[] levelForKey(Spell sp, List<? extends CDOMList<Spell>> lists, PlayerCharacter aPC) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (lists != null) {
            for (CDOMList<Spell> cDOMList : lists) {
                list.add(SpellLevel.getFirstLvlForKey(sp, cDOMList, aPC));
            }
        }
        return list.toArray(new Integer[list.size()]);
    }

    public static int getFirstLvlForKey(Spell sp, CDOMList<Spell> list, PlayerCharacter aPC) {
        List levelList;
        HashMapToList<CDOMList<Spell>, Integer> wLevelInfo = aPC.getSpellLevelInfo(sp);
        if (wLevelInfo != null && wLevelInfo.size() != 0 && (levelList = wLevelInfo.getListFor(list)) != null) {
            return (Integer)levelList.get(0);
        }
        return -1;
    }

    public static boolean isLevel(Spell sp, int aLevel, PlayerCharacter aPC) {
        Collection<AssociatedPrereqObject> assoc;
        Integer levelKey = aLevel;
        MasterListInterface masterLists = Globals.getMasterLists();
        for (PCClass pcc : aPC.getClassSet()) {
            ClassSpellList csl = pcc.get(ObjectKey.CLASS_SPELLLIST);
            assoc = masterLists.getAssociations(csl, sp);
            if (assoc == null) continue;
            for (AssociatedPrereqObject apo : assoc) {
                if (!PrereqHandler.passesAll(apo.getPrerequisiteList(), aPC, sp) || !levelKey.equals(apo.getAssociation(AssociationKey.SPELL_LEVEL))) continue;
                return true;
            }
        }
        for (Domain domain : aPC.getDomainSet()) {
            DomainSpellList dsl = domain.get(ObjectKey.DOMAIN_SPELLLIST);
            assoc = masterLists.getAssociations(dsl, sp);
            if (assoc == null) continue;
            for (AssociatedPrereqObject apo : assoc) {
                if (!PrereqHandler.passesAll(apo.getPrerequisiteList(), aPC, sp) || !levelKey.equals(apo.getAssociation(AssociationKey.SPELL_LEVEL))) continue;
                return true;
            }
        }
        return false;
    }

    public static int getFirstLevelForKey(Spell sp, List<? extends CDOMList<Spell>> lists, PlayerCharacter aPC) {
        Integer[] levelInt = SpellLevel.levelForKey(sp, lists, aPC);
        int result = -1;
        if (levelInt.length > 0) {
            for (int i = 0; i < levelInt.length; ++i) {
                if (levelInt[i] <= -1) continue;
                return levelInt[i];
            }
        }
        return result;
    }
}

