/*
 * Decompiled with CFR 0.152.
 */
package pcgen.facade.util;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang.ArrayUtils;
import pcgen.facade.util.AbstractListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.util.Logging;

public class SortedListFacade<E>
extends AbstractListFacade<E>
implements ListListener<E> {
    private ListFacade<E> delegate = null;
    private Comparator<? super E> comparator;
    private Comparator<Integer> indexComparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            Object e1 = SortedListFacade.this.delegate.getElementAt(o1);
            Object e2 = SortedListFacade.this.delegate.getElementAt(o2);
            return SortedListFacade.this.comparator.compare(e1, e2);
        }
    };
    private Integer[] transform = null;

    public SortedListFacade(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    public SortedListFacade(Comparator<? super E> comparator, ListFacade<E> list) {
        this.comparator = comparator;
        this.setDelegate(list);
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    @Override
    public E getElementAt(int index) {
        return this.delegate.getElementAt(this.transform[index]);
    }

    public void setDelegate(ListFacade<E> list) {
        ListFacade<E> oldList = this.delegate;
        if (oldList != null) {
            oldList.removeListListener(this);
        }
        this.delegate = list;
        if (list != null) {
            list.addListListener(this);
        }
        this.elementsChanged(null);
    }

    public void setComparator(Comparator<? super E> comparator) {
        this.comparator = comparator;
        this.elementsChanged(null);
    }

    @Override
    public void elementAdded(ListEvent<E> e) {
        this.transform = (Integer[])ArrayUtils.add((Object[])this.transform, (Object)this.transform.length);
        this.sanityCheck();
        Arrays.sort(this.transform, this.indexComparator);
        int index = Arrays.binarySearch(this.transform, e.getIndex(), this.indexComparator);
        this.fireElementAdded(this, e.getElement(), index);
    }

    @Override
    public void elementRemoved(ListEvent<E> e) {
        int index = ArrayUtils.indexOf((Object[])this.transform, (Object)e.getIndex());
        this.transform = (Integer[])ArrayUtils.removeElement((Object[])this.transform, (Object)(this.transform.length - 1));
        this.sanityCheck();
        Arrays.sort(this.transform, this.indexComparator);
        this.fireElementRemoved(this, e.getElement(), index);
    }

    @Override
    public void elementsChanged(ListEvent<E> e) {
        this.transform = new Integer[this.delegate.getSize()];
        for (int i = 0; i < this.transform.length; ++i) {
            this.transform[i] = i;
        }
        this.sanityCheck();
        Arrays.sort(this.transform, this.indexComparator);
        this.fireElementsChanged(this);
    }

    @Override
    public void elementModified(ListEvent<E> e) {
        this.sanityCheck();
        int index = Arrays.binarySearch(this.transform, e.getIndex(), this.indexComparator);
        this.fireElementModified(this, e.getElement(), index);
    }

    private boolean sanityCheck() {
        if (this.delegate.getSize() != this.transform.length) {
            String msg = String.format("Mismatched sizes between sorted facade %d and base list %d. Delegate is %s. Transform is %s.", this.transform.length, this.delegate.getSize(), this.delegate, this.transform);
            Logging.errorPrint(msg, new Throwable());
            return false;
        }
        return true;
    }
}

