/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListDataEvent;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.EquipmentSetFacade;
import pcgen.facade.core.GameModeFacade;
import pcgen.facade.core.TempBonusFacade;
import pcgen.facade.util.ListFacades;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.csheet.CharacterSheetPanel;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilteredListFacadeTableModel;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.util.DisplayAwareTab;
import pcgen.gui2.util.event.ListDataAdapter;
import pcgen.gui2.util.table.TableUtils;
import pcgen.system.ConfigurationSettings;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;
import pcgen.util.enumeration.Tab;

public class CharacterSheetInfoTab
extends FlippingSplitPane
implements CharacterInfoTab,
DisplayAwareTab {
    private static final long serialVersionUID = -4957524684640929994L;
    private final TabTitle tabTitle = new TabTitle(Tab.CHARACTERSHEET);
    private final CharacterSheetPanel csheet = new CharacterSheetPanel();
    private final JComboBox sheetBox = new JComboBox();
    private final JTable equipSetTable = TableUtils.createDefaultTable();
    private final JTable tempBonusTable;
    private final JTable tempBonusRowTable;
    private final JTable equipSetRowTable = TableUtils.createDefaultTable();

    public CharacterSheetInfoTab() {
        super("CharSheet");
        this.tempBonusTable = TableUtils.createDefaultTable();
        this.tempBonusRowTable = TableUtils.createDefaultTable();
        this.setOneTouchExpandable(true);
        JPanel panel = new JPanel(new BorderLayout());
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(LanguageBundle.getString("in_character_sheet_label")));
        this.sheetBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof File) {
                    value = ((File)value).getName();
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        box.add(this.sheetBox);
        panel.add((Component)box, "North");
        FlippingSplitPane subPane = new FlippingSplitPane("CharSheetLeft");
        subPane.setOrientation(0);
        this.equipSetTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane pane = TableUtils.createRadioBoxSelectionPane(this.equipSetTable, this.equipSetRowTable);
        pane.setPreferredSize(new Dimension(200, 100));
        subPane.setTopComponent(pane);
        this.tempBonusTable.getTableHeader().setReorderingAllowed(false);
        pane = TableUtils.createCheckBoxSelectionPane(this.tempBonusTable, this.tempBonusRowTable);
        pane.setPreferredSize(new Dimension(200, 100));
        subPane.setBottomComponent(pane);
        panel.add((Component)subPane, "Center");
        panel.setPreferredSize(panel.getMinimumSize());
        this.setLeftComponent(panel);
        this.csheet.setPreferredSize(new Dimension(600, 300));
        this.setRightComponent(this.csheet);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(BoxHandler.class, new BoxHandler(character));
        models.put(CSheetHandler.class, new CSheetHandler(character));
        models.put(TempBonusTableModel.class, new TempBonusTableModel(character));
        models.put(EquipSetTableModel.class, new EquipSetTableModel(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(BoxHandler.class).install();
        models.get(CSheetHandler.class).install();
        EquipSetTableModel equipSetModel = models.get(EquipSetTableModel.class);
        this.equipSetTable.setModel(equipSetModel);
        this.equipSetRowTable.setModel(equipSetModel);
        TempBonusTableModel tempBonusModel = models.get(TempBonusTableModel.class);
        this.tempBonusTable.setModel(tempBonusModel);
        this.tempBonusRowTable.setModel(tempBonusModel);
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(CSheetHandler.class).uninstall();
    }

    @Override
    public TabTitle getTabTitle() {
        return this.tabTitle;
    }

    @Override
    public void tabSelected() {
        this.csheet.refresh();
    }

    private class EquipSetTableModel
    extends FilteredListFacadeTableModel<EquipmentSetFacade>
    implements ReferenceListener<EquipmentSetFacade>,
    Filter<CharacterFacade, EquipmentSetFacade> {
        private static final long serialVersionUID = 5028006226606996671L;

        public EquipSetTableModel(CharacterFacade character) {
            super(character);
            character.getEquipmentSetRef().addReferenceListener(this);
            this.setDelegate(character.getEquipmentSets());
            this.setFilter(this);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == -1) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        protected Object getValueAt(EquipmentSetFacade element, int column) {
            switch (column) {
                case -1: {
                    return this.character.getEquipmentSetRef().getReference() == element;
                }
                case 0: {
                    return element;
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return LanguageBundle.getString("in_csEquipSets");
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex < 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            EquipmentSetFacade eqset = (EquipmentSetFacade)this.sortedList.getElementAt(rowIndex);
            this.character.setEquipmentSet(eqset);
            CharacterSheetInfoTab.this.csheet.refresh();
        }

        @Override
        public void referenceChanged(ReferenceEvent<EquipmentSetFacade> e) {
            this.fireTableRowsUpdated(0, this.character.getEquipmentSets().getSize() - 1);
        }

        @Override
        public boolean accept(CharacterFacade context, EquipmentSetFacade element) {
            return true;
        }
    }

    private class TempBonusTableModel
    extends FilteredListFacadeTableModel<TempBonusFacade>
    implements Filter<CharacterFacade, TempBonusFacade> {
        private static final long serialVersionUID = -2157540968522498242L;
        private ListListener<TempBonusFacade> listener;

        public TempBonusTableModel(CharacterFacade character) {
            super(character);
            this.listener = new ListListener<TempBonusFacade>(){

                @Override
                public void elementAdded(ListEvent<TempBonusFacade> e) {
                    int index = ListFacades.wrap(TempBonusTableModel.this.sortedList).indexOf(e.getElement());
                    TempBonusTableModel.this.fireTableCellUpdated(index, -1);
                }

                @Override
                public void elementRemoved(ListEvent<TempBonusFacade> e) {
                    int index = ListFacades.wrap(TempBonusTableModel.this.sortedList).indexOf(e.getElement());
                    TempBonusTableModel.this.fireTableCellUpdated(index, -1);
                }

                @Override
                public void elementsChanged(ListEvent<TempBonusFacade> e) {
                    TempBonusTableModel.this.fireTableRowsUpdated(0, TempBonusTableModel.this.sortedList.getSize() - 1);
                }

                @Override
                public void elementModified(ListEvent<TempBonusFacade> e) {
                }
            };
            this.setDelegate(character.getTempBonuses());
            this.setFilter(this);
            character.getTempBonuses().addListListener(this.listener);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == -1) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        protected Object getValueAt(TempBonusFacade element, int column) {
            switch (column) {
                case -1: {
                    return element.isActive();
                }
                case 0: {
                    return element;
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return LanguageBundle.getString("in_InfoTempMod");
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            TempBonusFacade bonus = (TempBonusFacade)this.sortedList.getElementAt(rowIndex);
            this.character.setTempBonusActive(bonus, aValue == Boolean.TRUE);
            CharacterSheetInfoTab.this.csheet.refresh();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex < 0;
        }

        @Override
        public boolean accept(CharacterFacade context, TempBonusFacade element) {
            return true;
        }
    }

    private class CSheetHandler
    implements ListListener<Object>,
    ReferenceListener<Object> {
        private CharacterFacade character;
        private String sheetDir;

        public CSheetHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            CharacterSheetInfoTab.this.csheet.setCharacter(this.character);
        }

        public void uninstall() {
        }

        @Override
        public void elementAdded(ListEvent<Object> e) {
            CharacterSheetInfoTab.this.csheet.refresh();
        }

        @Override
        public void elementRemoved(ListEvent<Object> e) {
            CharacterSheetInfoTab.this.csheet.refresh();
        }

        @Override
        public void elementsChanged(ListEvent<Object> e) {
            CharacterSheetInfoTab.this.csheet.refresh();
        }

        @Override
        public void referenceChanged(ReferenceEvent<Object> e) {
            CharacterSheetInfoTab.this.csheet.refresh();
        }

        @Override
        public void elementModified(ListEvent<Object> e) {
            CharacterSheetInfoTab.this.csheet.refresh();
        }
    }

    private class BoxHandler
    extends ListDataAdapter {
        private CharacterFacade character;
        private ComboBoxModel model;

        public BoxHandler(CharacterFacade character) {
            this.character = character;
            GameModeFacade game = character.getDataSet().getGameMode();
            String previewDir = ConfigurationSettings.getPreviewDir();
            File sheetDir = new File(previewDir, game.getCharSheetDir());
            if (sheetDir.exists() && sheetDir.isDirectory()) {
                File[] files = sheetDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && !pathname.isHidden();
                    }
                });
                Arrays.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return f1.toString().compareToIgnoreCase(f2.toString());
                    }
                });
                this.model = new DefaultComboBoxModel<File>(files);
                File file = null;
                String previewSheet = character.getPreviewSheetRef().toString();
                if (previewSheet == null) {
                    previewSheet = game.getDefaultCharSheet();
                }
                if (previewSheet != null && !(file = new File(sheetDir, previewSheet)).isFile()) {
                    Logging.errorPrint("Invalid Character Sheet: " + file.getAbsolutePath());
                }
                if (!(file != null && file.isFile() || game.getDefaultCharSheet() == null)) {
                    file = new File(sheetDir, game.getDefaultCharSheet());
                }
                this.model.setSelectedItem(file);
            } else {
                this.model = new DefaultComboBoxModel();
            }
            this.model.addListDataListener(this);
        }

        public void install() {
            CharacterSheetInfoTab.this.sheetBox.setModel(this.model);
            CharacterSheetInfoTab.this.csheet.setCharacterSheet((File)this.model.getSelectedItem());
        }

        @Override
        public void listDataChanged(ListDataEvent e) {
            if (e.getIndex0() == -1 && e.getIndex1() == -1) {
                File outputSheet = (File)CharacterSheetInfoTab.this.sheetBox.getSelectedItem();
                CharacterSheetInfoTab.this.csheet.setCharacterSheet(outputSheet);
                CharacterSheetInfoTab.this.csheet.refresh();
                this.character.setPreviewSheet(outputSheet.getName());
            }
        }
    }
}

