/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.output.prereq;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.PrereqObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterFactory;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterInterface;
import pcgen.util.Logging;

public class PrerequisiteWriter {
    public void write(Writer stringWriter, Prerequisite prereq) throws PersistenceLayerException {
        PrerequisiteWriterFactory factory = PrerequisiteWriterFactory.getInstance();
        PrerequisiteWriterInterface writer = factory.getWriter(prereq.getKind());
        if (writer == null) {
            throw new PersistenceLayerException("Can not find a Writer for prerequisites fo kind: " + prereq.getKind());
        }
        writer.write(stringWriter, prereq);
    }

    public static String prereqsToString(PrereqObject pObj) {
        if (pObj.hasPrerequisites()) {
            PrerequisiteWriter prereqWriter = new PrerequisiteWriter();
            return prereqWriter.getPrerequisiteString(pObj.getPrerequisiteList(), "\t");
        }
        return "";
    }

    public String getPrerequisiteString(Collection<Prerequisite> prereqs) throws PersistenceLayerException {
        return this.getPrereqString(prereqs, "|");
    }

    private String getPrereqString(Collection<Prerequisite> prereqs, String separator) throws PersistenceLayerException {
        String prereqString = null;
        if (prereqs != null && !prereqs.isEmpty()) {
            TreeSet<String> list = new TreeSet<String>();
            for (Prerequisite p : prereqs) {
                StringWriter swriter = new StringWriter();
                this.write(swriter, p);
                list.add(swriter.toString());
            }
            prereqString = StringUtil.join(list, (String)separator);
        }
        return prereqString;
    }

    public String getPrerequisiteString(Collection<Prerequisite> prereqs, String separator) {
        try {
            return this.getPrereqString(prereqs, separator);
        }
        catch (PersistenceLayerException e) {
            Logging.errorPrint("Error writing Prerequisites: " + prereqs);
            return "";
        }
    }
}

