/*
 * Decompiled with CFR 0.152.
 */
package pcgen.system;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import pcgen.util.Logging;

public final class LanguageBundle {
    private static final String BUNDLE_NAME = "pcgen.resources.lang";
    public static final String UNDEFINED = " not defined.";
    private static ResourceBundle bundle;
    public static final String KEY_PREFIX = "in_";

    public static int getMnemonic(String property) {
        return LanguageBundle.getMnemonic(property, '\u0000');
    }

    public static String getString(String key) {
        return LanguageBundle.getProperty(key);
    }

    public static String getFormattedString(String aKey, Object ... varargs) {
        String string = LanguageBundle.getString(aKey);
        if (varargs != null && varargs.length > 0) {
            return MessageFormat.format(string, varargs);
        }
        return string;
    }

    private static char getMnemonic(String property, char def) {
        String mnemonic = LanguageBundle.getProperty(property);
        if (mnemonic.length() != 0) {
            return mnemonic.charAt(0);
        }
        return def;
    }

    private static String getProperty(String key) {
        if (bundle == null) {
            LanguageBundle.init();
        }
        String value = null;
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            value = key + UNDEFINED;
        }
        return value;
    }

    static synchronized void init() {
        if (bundle != null) {
            Logging.log(Logging.WARNING, "Reinitialising the language bundle.");
        }
        Logging.log(Logging.INFO, MessageFormat.format("Initialising language bundle with locale {0}.", Locale.getDefault()));
        try {
            bundle = ResourceBundle.getBundle("pcgen.resources.lang.LanguageBundle");
        }
        catch (MissingResourceException mrex) {
            bundle = null;
            Logging.errorPrint("Can't find language bundle", mrex);
        }
    }

    public static final void reload() {
        Locale l = Locale.getDefault();
        if (bundle != null && (l == null && bundle.getLocale() == null || !l.equals(bundle.getLocale()))) {
            bundle = null;
        }
    }

    public static String getPrettyMultiplier(double d) {
        if (0.25 == d) {
            return LanguageBundle.getString("in_multQuarter");
        }
        if (0.5 == d) {
            return LanguageBundle.getString("in_multHalf");
        }
        if (0.75 == d) {
            return LanguageBundle.getString("in_multThreeQuarter");
        }
        return MessageFormat.format(LanguageBundle.getString("in_multiply"), d);
    }
}

