/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ConcretePersistentTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;

public class WeaponbonusToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass>,
DeferredToken<PCClass>,
PersistentChoiceActor<WeaponProf> {
    private static final Class<WeaponProf> WEAPONPROF_CLASS = WeaponProf.class;

    @Override
    public String getTokenName() {
        return "WEAPONBONUS";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass pcc, String value) {
        StringTokenizer tok = new StringTokenizer(value, "|");
        boolean foundAny = false;
        boolean foundOther = false;
        while (tok.hasMoreTokens()) {
            CDOMReference ref;
            String tokText = tok.nextToken();
            if ("ALL".equals(tokText)) {
                foundAny = true;
                ref = context.getReferenceContext().getCDOMAllReference(WEAPONPROF_CLASS);
                context.getObjectContext().addToList(pcc, ListKey.WEAPONBONUS, ref);
                continue;
            }
            foundOther = true;
            ref = TokenUtilities.getTypeOrPrimitive(context, WEAPONPROF_CLASS, tokText);
            if (ref == null) {
                return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
            }
            context.getObjectContext().addToList(pcc, ListKey.WEAPONBONUS, ref);
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, PCClass pcc) {
        Changes<CDOMReference<WeaponProf>> changes = context.getObjectContext().getListChanges(pcc, ListKey.WEAPONBONUS);
        Collection<CDOMReference<WeaponProf>> added = changes.getAdded();
        if (added == null || added.isEmpty()) {
            return null;
        }
        return new String[]{ReferenceUtilities.joinLstFormat(added, "|")};
    }

    @Override
    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }

    @Override
    public boolean process(LoadContext context, PCClass obj) {
        List<CDOMReference<WeaponProf>> weaponbonus = obj.getListFor(ListKey.WEAPONBONUS);
        if (weaponbonus != null) {
            ReferenceChoiceSet<WeaponProf> rcs = new ReferenceChoiceSet<WeaponProf>(weaponbonus);
            ChoiceSet<WeaponProf> cs = new ChoiceSet<WeaponProf>(this.getTokenName(), rcs);
            cs.setTitle("Bonus WeaponProf Choice");
            ConcretePersistentTransitionChoice<WeaponProf> tc = new ConcretePersistentTransitionChoice<WeaponProf>(cs, FormulaFactory.ONE);
            context.getObjectContext().addToList(obj, ListKey.ADD, tc);
            tc.setChoiceActor(this);
        }
        return true;
    }

    @Override
    public Class<PCClass> getDeferredTokenClass() {
        return PCClass.class;
    }

    @Override
    public void applyChoice(CDOMObject owner, WeaponProf choice, PlayerCharacter pc) {
        pc.addWeaponBonus(owner, choice);
    }

    @Override
    public boolean allow(WeaponProf item, PlayerCharacter pc, boolean allowStack) {
        return true;
    }

    @Override
    public String encodeChoice(WeaponProf choice) {
        return choice.getKeyName();
    }

    @Override
    public WeaponProf decodeChoice(LoadContext context, String s) {
        return context.getReferenceContext().silentlyGetConstructedCDOMObject(WeaponProf.class, s);
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, CDOMObject owner, WeaponProf choice) {
        pc.addWeaponBonus(owner, choice);
    }

    @Override
    public void removeChoice(PlayerCharacter pc, CDOMObject owner, WeaponProf choice) {
        pc.removeWeaponBonus(owner, choice);
    }
}

