/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8.utils;

import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8ArrayBuffer;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8TypedArray;
import com.eclipsesource.v8.V8Value;
import com.eclipsesource.v8.utils.V8Map;
import com.eclipsesource.v8.utils.V8PropertyMap;
import com.eclipsesource.v8.utils.typedarrays.ArrayBuffer;
import com.eclipsesource.v8.utils.typedarrays.Float32Array;
import com.eclipsesource.v8.utils.typedarrays.Float64Array;
import com.eclipsesource.v8.utils.typedarrays.Int16Array;
import com.eclipsesource.v8.utils.typedarrays.Int32Array;
import com.eclipsesource.v8.utils.typedarrays.Int8Array;
import com.eclipsesource.v8.utils.typedarrays.TypedArray;
import com.eclipsesource.v8.utils.typedarrays.UInt16Array;
import com.eclipsesource.v8.utils.typedarrays.UInt32Array;
import com.eclipsesource.v8.utils.typedarrays.UInt8Array;
import com.eclipsesource.v8.utils.typedarrays.UInt8ClampedArray;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class V8ObjectUtils {
    private static final Object IGNORE = new Object();

    public static Map<String, ? super Object> toMap(V8Object object) {
        V8Map<Object> cache = new V8Map<Object>();
        try {
            Map<String, ? super Object> map = V8ObjectUtils.toMap(object, cache);
            return map;
        }
        finally {
            cache.release();
        }
    }

    public static List<? super Object> toList(V8Array array) {
        V8Map<Object> cache = new V8Map<Object>();
        try {
            List<? super Object> list2 = V8ObjectUtils.toList(array, cache);
            return list2;
        }
        finally {
            cache.release();
        }
    }

    public static Object getTypedArray(V8Array array, int arrayType, Object result2) {
        int length = array.length();
        if (arrayType == 1) {
            int[] intArray = (int[])result2;
            if (intArray == null || intArray.length < length) {
                intArray = new int[length];
            }
            array.getIntegers(0, length, intArray);
            return intArray;
        }
        if (arrayType == 2) {
            double[] doubleArray = (double[])result2;
            if (doubleArray == null || doubleArray.length < length) {
                doubleArray = new double[length];
            }
            array.getDoubles(0, length, doubleArray);
            return doubleArray;
        }
        if (arrayType == 3) {
            boolean[] booleanArray = (boolean[])result2;
            if (booleanArray == null || booleanArray.length < length) {
                booleanArray = new boolean[length];
            }
            array.getBooleans(0, length, booleanArray);
            return booleanArray;
        }
        if (arrayType == 4) {
            String[] stringArray = (String[])result2;
            if (stringArray == null || stringArray.length < length) {
                stringArray = new String[length];
            }
            array.getStrings(0, length, stringArray);
            return stringArray;
        }
        if (arrayType == 9) {
            byte[] byteArray = (byte[])result2;
            if (byteArray == null || byteArray.length < length) {
                byteArray = new byte[length];
            }
            array.getBytes(0, length, byteArray);
            return byteArray;
        }
        throw new RuntimeException("Unsupported bulk load type: " + arrayType);
    }

    public static Object getTypedArray(V8Array array, int arrayType) {
        int length = array.length();
        if (arrayType == 1) {
            return array.getIntegers(0, length);
        }
        if (arrayType == 2) {
            return array.getDoubles(0, length);
        }
        if (arrayType == 3) {
            return array.getBooleans(0, length);
        }
        if (arrayType == 4) {
            return array.getStrings(0, length);
        }
        throw new RuntimeException("Unsupported bulk load type: " + arrayType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static V8Object toV8Object(V8 v8, Map<String, ? extends Object> map) {
        Hashtable<Object, V8Value> cache = new Hashtable<Object, V8Value>();
        try {
            V8Object v8Object = V8ObjectUtils.toV8Object(v8, map, cache).twin();
            return v8Object;
        }
        finally {
            for (V8Value v8Object : cache.values()) {
                v8Object.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static V8Array toV8Array(V8 v8, List<? extends Object> list2) {
        Hashtable<Object, V8Value> cache = new Hashtable<Object, V8Value>();
        try {
            V8Array v8Array = V8ObjectUtils.toV8Array(v8, list2, cache).twin();
            return v8Array;
        }
        finally {
            for (V8Value v8Object : cache.values()) {
                v8Object.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getV8Result(V8 v8, Object value) {
        if (value == null) {
            return null;
        }
        Hashtable<Object, V8Value> cache = new Hashtable<Object, V8Value>();
        try {
            Object result2 = V8ObjectUtils.getV8Result(v8, value, cache);
            if (result2 instanceof V8Object) {
                V8Object v8Object = ((V8Object)result2).twin();
                return v8Object;
            }
            Object object = result2;
            return object;
        }
        finally {
            for (V8Value v8Object : cache.values()) {
                v8Object.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushValue(V8 v8, V8Array array, Object value) {
        Hashtable<Object, V8Value> cache = new Hashtable<Object, V8Value>();
        try {
            V8ObjectUtils.pushValue(v8, array, value, cache);
        }
        finally {
            for (V8Value v8Object : cache.values()) {
                v8Object.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(V8Array array, int index) {
        V8Map<Object> cache = new V8Map<Object>();
        try {
            Object object = V8ObjectUtils.getValue(array, index, cache);
            return object;
        }
        finally {
            cache.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(V8Object object, String key2) {
        V8Map<Object> cache = new V8Map<Object>();
        try {
            Object object2 = V8ObjectUtils.getValue(object, key2, cache);
            return object2;
        }
        finally {
            cache.release();
        }
    }

    private static Map<String, ? super Object> toMap(V8Object object, V8Map<Object> cache) {
        String[] keys;
        if (object == null) {
            return Collections.emptyMap();
        }
        if (cache.containsKey(object)) {
            return (Map)cache.get(object);
        }
        V8PropertyMap<Object> result2 = new V8PropertyMap<Object>();
        cache.put(object, (Object)result2);
        for (String key2 : keys = object.getKeys()) {
            Object value = V8ObjectUtils.getValue(object, key2, cache);
            if (value == IGNORE) continue;
            result2.put(key2, value);
        }
        return result2;
    }

    private static List<? super Object> toList(V8Array array, V8Map<Object> cache) {
        if (array == null) {
            return Collections.emptyList();
        }
        if (cache.containsKey(array)) {
            return (List)cache.get(array);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        cache.put(array, (Object)result2);
        for (int i = 0; i < array.length(); ++i) {
            Object value = V8ObjectUtils.getValue(array, i, cache);
            if (value == IGNORE) continue;
            result2.add(V8ObjectUtils.getValue(array, i, cache));
        }
        return result2;
    }

    private static V8Object toV8Object(V8 v8, Map<String, ? extends Object> map, Map<Object, V8Value> cache) {
        if (cache.containsKey(map)) {
            return (V8Object)cache.get(map);
        }
        V8Object result2 = new V8Object(v8);
        cache.put(map, result2);
        try {
            for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
                V8ObjectUtils.setValue(v8, result2, entry.getKey(), entry.getValue(), cache);
            }
        }
        catch (IllegalStateException e) {
            result2.release();
            throw e;
        }
        return result2;
    }

    private static V8Array toV8Array(V8 v8, List<? extends Object> list2, Map<Object, V8Value> cache) {
        if (cache.containsKey(new ListWrapper(list2))) {
            return (V8Array)cache.get(new ListWrapper(list2));
        }
        V8Array result2 = new V8Array(v8);
        cache.put(new ListWrapper(list2), result2);
        try {
            for (int i = 0; i < list2.size(); ++i) {
                Object value = list2.get(i);
                V8ObjectUtils.pushValue(v8, result2, value, cache);
            }
        }
        catch (IllegalStateException e) {
            result2.release();
            throw e;
        }
        return result2;
    }

    private static V8ArrayBuffer toV8ArrayBuffer(V8 v8, ArrayBuffer arrayBuffer, Map<Object, V8Value> cache) {
        if (cache.containsKey(arrayBuffer)) {
            return (V8ArrayBuffer)cache.get(arrayBuffer);
        }
        V8ArrayBuffer result2 = new V8ArrayBuffer(v8, arrayBuffer.getByteBuffer());
        cache.put(arrayBuffer, result2);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static V8TypedArray toV8TypedArray(V8 v8, TypedArray typedArray, Map<Object, V8Value> cache) {
        if (cache.containsKey(typedArray)) {
            return (V8TypedArray)cache.get(typedArray);
        }
        V8ArrayBuffer arrayBuffer = new V8ArrayBuffer(v8, typedArray.getByteBuffer());
        try {
            V8TypedArray result2 = new V8TypedArray(v8, arrayBuffer, typedArray.getType(), 0, typedArray.length());
            cache.put(typedArray, result2);
            V8TypedArray v8TypedArray = result2;
            return v8TypedArray;
        }
        finally {
            arrayBuffer.release();
        }
    }

    private static Object getV8Result(V8 v8, Object value, Map<Object, V8Value> cache) {
        if (cache.containsKey(value)) {
            return cache.get(value);
        }
        if (value instanceof Map) {
            return V8ObjectUtils.toV8Object(v8, (Map)value, cache);
        }
        if (value instanceof List) {
            return V8ObjectUtils.toV8Array(v8, (List)value, cache);
        }
        if (value instanceof TypedArray) {
            return V8ObjectUtils.toV8TypedArray(v8, (TypedArray)value, cache);
        }
        if (value instanceof ArrayBuffer) {
            return V8ObjectUtils.toV8ArrayBuffer(v8, (ArrayBuffer)value, cache);
        }
        return value;
    }

    private static void pushValue(V8 v8, V8Array result2, Object value, Map<Object, V8Value> cache) {
        if (value == null) {
            result2.pushUndefined();
        } else if (value instanceof Integer) {
            result2.push((Integer)value);
        } else if (value instanceof Long) {
            result2.push(new Double(((Long)value).longValue()));
        } else if (value instanceof Double) {
            result2.push((Double)value);
        } else if (value instanceof Float) {
            result2.push(((Float)value).floatValue());
        } else if (value instanceof String) {
            result2.push((String)value);
        } else if (value instanceof Boolean) {
            result2.push((Boolean)value);
        } else if (value instanceof V8Object) {
            result2.push((V8Object)value);
        } else if (value instanceof TypedArray) {
            V8TypedArray v8TypedArray = V8ObjectUtils.toV8TypedArray(v8, (TypedArray)value, cache);
            result2.push(v8TypedArray);
        } else if (value instanceof ArrayBuffer) {
            V8ArrayBuffer v8ArrayBuffer = V8ObjectUtils.toV8ArrayBuffer(v8, (ArrayBuffer)value, cache);
            result2.push(v8ArrayBuffer);
        } else if (value instanceof Map) {
            V8Object object = V8ObjectUtils.toV8Object(v8, (Map)value, cache);
            result2.push(object);
        } else if (value instanceof List) {
            V8Array array = V8ObjectUtils.toV8Array(v8, (List)value, cache);
            result2.push(array);
        } else {
            throw new IllegalStateException("Unsupported Object of type: " + value.getClass());
        }
    }

    private static void setValue(V8 v8, V8Object result2, String key2, Object value, Map<Object, V8Value> cache) {
        if (value == null) {
            result2.addUndefined(key2);
        } else if (value instanceof Integer) {
            result2.add(key2, (Integer)value);
        } else if (value instanceof Long) {
            result2.add(key2, (int)((Long)value).longValue());
        } else if (value instanceof Double) {
            result2.add(key2, (Double)value);
        } else if (value instanceof Float) {
            result2.add(key2, ((Float)value).floatValue());
        } else if (value instanceof String) {
            result2.add(key2, (String)value);
        } else if (value instanceof Boolean) {
            result2.add(key2, (Boolean)value);
        } else if (value instanceof V8Object) {
            result2.add(key2, (V8Object)value);
        } else if (value instanceof TypedArray) {
            V8TypedArray typedArray = V8ObjectUtils.toV8TypedArray(v8, (TypedArray)value, cache);
            result2.add(key2, typedArray);
        } else if (value instanceof ArrayBuffer) {
            V8ArrayBuffer v8ArrayBuffer = V8ObjectUtils.toV8ArrayBuffer(v8, (ArrayBuffer)value, cache);
            result2.add(key2, v8ArrayBuffer);
        } else if (value instanceof Map) {
            V8Object object = V8ObjectUtils.toV8Object(v8, (Map)value, cache);
            result2.add(key2, object);
        } else if (value instanceof List) {
            V8Array array = V8ObjectUtils.toV8Array(v8, (List)value, cache);
            result2.add(key2, array);
        } else {
            throw new IllegalStateException("Unsupported Object of type: " + value.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getValue(V8Array array, int index, V8Map<Object> cache) {
        int valueType = array.getType(index);
        switch (valueType) {
            case 1: {
                return array.getInteger(index);
            }
            case 2: {
                return array.getDouble(index);
            }
            case 3: {
                return array.getBoolean(index);
            }
            case 4: {
                return array.getString(index);
            }
            case 7: {
                return IGNORE;
            }
            case 10: {
                V8ArrayBuffer buffer = (V8ArrayBuffer)array.get(index);
                try {
                    ArrayBuffer arrayBuffer = new ArrayBuffer(buffer.getBackingStore());
                    return arrayBuffer;
                }
                finally {
                    buffer.release();
                }
            }
            case 8: {
                V8Array typedArray = array.getArray(index);
                try {
                    Object object = V8ObjectUtils.toTypedArray(typedArray);
                    return object;
                }
                finally {
                    if (typedArray instanceof V8Array) {
                        typedArray.release();
                    }
                }
            }
            case 5: {
                V8Array arrayValue = array.getArray(index);
                try {
                    List<? super Object> list2 = V8ObjectUtils.toList(arrayValue, cache);
                    return list2;
                }
                finally {
                    if (arrayValue instanceof V8Array) {
                        arrayValue.release();
                    }
                }
            }
            case 6: {
                V8Object objectValue = array.getObject(index);
                try {
                    Map<String, ? super Object> map = V8ObjectUtils.toMap(objectValue, cache);
                    return map;
                }
                finally {
                    if (objectValue instanceof V8Object) {
                        objectValue.release();
                    }
                }
            }
            case 0: {
                return null;
            }
            case 99: {
                return V8.getUndefined();
            }
        }
        throw new IllegalStateException("Cannot find type for index: " + index);
    }

    private static Object toTypedArray(V8Array typedArray) {
        int arrayType = typedArray.getType();
        ByteBuffer buffer = ((V8TypedArray)typedArray).getByteBuffer();
        switch (arrayType) {
            case 9: {
                return new Int8Array(buffer);
            }
            case 11: {
                return new UInt8Array(buffer);
            }
            case 12: {
                return new UInt8ClampedArray(buffer);
            }
            case 13: {
                return new Int16Array(buffer);
            }
            case 14: {
                return new UInt16Array(buffer);
            }
            case 1: {
                return new Int32Array(buffer);
            }
            case 15: {
                return new UInt32Array(buffer);
            }
            case 16: {
                return new Float32Array(buffer);
            }
            case 2: {
                return new Float64Array(buffer);
            }
        }
        throw new IllegalStateException("Known Typed Array type: " + V8Value.getStringRepresentaion(arrayType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getValue(V8Object object, String key2, V8Map<Object> cache) {
        int valueType = object.getType(key2);
        switch (valueType) {
            case 1: {
                return object.getInteger(key2);
            }
            case 2: {
                return object.getDouble(key2);
            }
            case 3: {
                return object.getBoolean(key2);
            }
            case 4: {
                return object.getString(key2);
            }
            case 7: {
                return IGNORE;
            }
            case 10: {
                V8ArrayBuffer buffer = (V8ArrayBuffer)object.get(key2);
                try {
                    ArrayBuffer arrayBuffer = new ArrayBuffer(buffer.getBackingStore());
                    return arrayBuffer;
                }
                finally {
                    buffer.release();
                }
            }
            case 8: {
                V8Array typedArray = object.getArray(key2);
                try {
                    Object object2 = V8ObjectUtils.toTypedArray(typedArray);
                    return object2;
                }
                finally {
                    if (typedArray instanceof V8Array) {
                        typedArray.release();
                    }
                }
            }
            case 5: {
                V8Array array = object.getArray(key2);
                try {
                    List<? super Object> list2 = V8ObjectUtils.toList(array, cache);
                    return list2;
                }
                finally {
                    if (array instanceof V8Array) {
                        array.release();
                    }
                }
            }
            case 6: {
                V8Object child = object.getObject(key2);
                try {
                    Map<String, ? super Object> map = V8ObjectUtils.toMap(child, cache);
                    return map;
                }
                finally {
                    if (child instanceof V8Object) {
                        child.release();
                    }
                }
            }
            case 0: {
                return null;
            }
            case 99: {
                return V8.getUndefined();
            }
        }
        throw new IllegalStateException("Cannot find type for key: " + key2);
    }

    private V8ObjectUtils() {
    }

    static class ListWrapper {
        private List<? extends Object> list;

        public ListWrapper(List<? extends Object> list2) {
            this.list = list2;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListWrapper) {
                return ((ListWrapper)obj).list == this.list;
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.list);
        }
    }
}

