/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.commons.java.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.onemind.commons.java.util.StringUtils;

public final class ReflectUtils {
    private static final Logger _logger = Logger.getLogger((class$org$onemind$commons$java$lang$reflect$ReflectUtils == null ? (class$org$onemind$commons$java$lang$reflect$ReflectUtils = ReflectUtils.class$("org.onemind.commons.java.lang.reflect.ReflectUtils")) : class$org$onemind$commons$java$lang$reflect$ReflectUtils).getName());
    private static final Map _classCache = new HashMap();
    private static final Map _methodCache = new HashMap();
    private static boolean _classCaching = true;
    private static boolean _methodCaching = true;
    static /* synthetic */ Class class$org$onemind$commons$java$lang$reflect$ReflectUtils;
    static /* synthetic */ Class class$java$lang$Boolean;

    private ReflectUtils() {
    }

    public static final Class[] toArgTypes(Object[] args) {
        if (args == null) {
            args = new Object[]{};
        }
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            argTypes[i] = args[i].getClass();
        }
        return argTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Class getClass(String name) throws ClassNotFoundException {
        if (_classCaching && _classCache.containsKey(name)) {
            Class c = (Class)_classCache.get(name);
            if (c == null) {
                throw new ClassNotFoundException("Class " + name + " not found");
            }
            return c;
        }
        Class<?> c = null;
        try {
            Class<?> clazz = c = Class.forName(name);
            return clazz;
        }
        finally {
            if (_classCaching) {
                _classCache.put(name, c);
            }
        }
    }

    public static final Constructor getConstructor(Class type, Object[] args) throws NoSuchMethodException {
        if (args == null) {
            args = new Object[]{};
        }
        Object[] argTypes = ReflectUtils.toArgTypes(args);
        Constructor c = null;
        if (_methodCaching && (c = (Constructor)_methodCache.get(new MethodKey(type, "$Constructor", (Class[])argTypes))) != null) {
            return c;
        }
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Looking for constructor for " + type.getName() + "(" + StringUtils.concat(argTypes, ",") + ")");
            }
            c = type.getConstructor((Class<?>[])argTypes);
        }
        catch (NoSuchMethodException e) {
            c = ReflectUtils.searchConstructor(type, (Class[])argTypes);
        }
        if (c == null) {
            throw new NoSuchMethodException("Constructor not found for class " + ReflectUtils.toMethodString(type.getName(), args));
        }
        if (_methodCaching) {
            _methodCache.put(new MethodKey(type, "$Constructor", (Class[])argTypes), c);
        }
        return c;
    }

    public static final String toMethodString(String methodName, Object[] args) {
        StringBuffer sb = new StringBuffer(methodName);
        sb.append("(");
        if (args != null) {
            sb.append(StringUtils.concat(args, ","));
        }
        sb.append(")");
        return sb.toString();
    }

    public static final Constructor searchConstructor(Class type, Class[] argTypes) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Searching for constructor for " + type.getName());
        }
        Constructor<?>[] constructors = type.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Object[] types = constructors[i].getParameterTypes();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("trying arg types " + StringUtils.concat(types, ","));
            }
            if (!ReflectUtils.isCompatible((Class[])types, argTypes)) continue;
            return constructors[i];
        }
        return null;
    }

    public static final boolean isCompatible(Class[] types, Object[] args) {
        if (types == null || types.length == 0) {
            return args == null || args.length == 0;
        }
        if (args == null) {
            return false;
        }
        if (types.length != args.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (types[i].isPrimitive()) {
                if (args[i] != null) continue;
                return false;
            }
            if (args[i] == null) {
                return true;
            }
            if (types[i].isInstance(args[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean isCompatible(Class[] methodTypes, Class[] argTypes) {
        if (methodTypes == null || methodTypes.length == 0) {
            return argTypes == null || argTypes.length == 0;
        }
        if (methodTypes == null) {
            return false;
        }
        if (methodTypes.length != argTypes.length) {
            return false;
        }
        for (int i = 0; i < methodTypes.length; ++i) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Comparing " + methodTypes[i] + " to " + argTypes[i]);
            }
            if (methodTypes[i] == argTypes[i] || !(methodTypes[i].isPrimitive() ? (methodTypes[i] == Boolean.TYPE ? argTypes[i] != (class$java$lang$Boolean == null ? ReflectUtils.class$("java.lang.Boolean") : class$java$lang$Boolean) : argTypes[i] == Boolean.TYPE) : argTypes[i] != null && !methodTypes[i].isAssignableFrom(argTypes[i]))) continue;
            return false;
        }
        return true;
    }

    public static final Object newInstance(Class type, Object[] args) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Constructor c;
        if (args == null) {
            args = new Object[]{};
        }
        if ((c = ReflectUtils.getConstructor(type, args)) != null) {
            return c.newInstance(args);
        }
        throw new NoSuchMethodException("Constructor not found for " + type);
    }

    public static final Object invoke(Object o, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = new Object[]{};
        }
        Method m = null;
        if (o instanceof Class) {
            try {
                m = ReflectUtils.getMethod((Class)o, methodName, args);
            }
            catch (NoSuchMethodException e) {
                m = ReflectUtils.getMethod(o.getClass(), methodName, args);
            }
        } else {
            m = ReflectUtils.getMethod(o.getClass(), methodName, args);
        }
        if (m != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Invoking " + m + " on " + o);
            }
            return m.invoke(o, args);
        }
        throw new NoSuchMethodException("There's no method " + ReflectUtils.toMethodString(methodName, args) + " for " + m);
    }

    public static final Method getInterfaceMethod(Class[] c, String methodName, Class[] argTypes) {
        return null;
    }

    public static final Method getMethod(Class type, String methodName, Object[] args) throws NoSuchMethodException {
        Object m = null;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Finding method " + ReflectUtils.toMethodString(methodName, args) + " of " + type);
        }
        if (args == null) {
            args = new Object[]{};
        }
        Class[] argTypes = ReflectUtils.toArgTypes(args);
        return ReflectUtils.getMethod(type, methodName, argTypes);
    }

    public static final Method getMethod(Class type, String methodName, Class[] argTypes) throws NoSuchMethodException {
        Method m;
        if (_methodCaching && (m = (Method)_methodCache.get(new MethodKey(type, methodName, argTypes))) != null) {
            return m;
        }
        try {
            m = type.getMethod(methodName, argTypes);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Found using reflection");
            }
        }
        catch (NoSuchMethodException nme) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Failed using reflection: " + nme.getMessage() + ". Search for method.");
            }
            m = ReflectUtils.searchMethod(type, methodName, argTypes);
        }
        if (m != null) {
            if (_methodCaching) {
                _methodCache.put(new MethodKey(type, methodName, argTypes), m);
            }
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
        } else {
            throw new NoSuchMethodException("Method " + type.getName() + "." + ReflectUtils.toMethodString(methodName, argTypes) + " not found.");
        }
        return m;
    }

    private static final Method searchMethod(Class type, String methodName, Class[] argTypes) {
        Method[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Checking compatibility with " + m);
            }
            if (!m.getName().equals(methodName) || !ReflectUtils.isCompatible((Class[])m.getParameterTypes(), argTypes)) continue;
            return m;
        }
        return null;
    }

    protected static final void setClassCaching(boolean caching) {
        _classCaching = caching;
    }

    protected static final void setMethodCaching(boolean caching) {
        _methodCaching = caching;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MethodKey {
        private String _name;
        private Class _clazz;
        private Class[] _args;
        private int _hashCode;

        public MethodKey(Class clazz, String name, Class[] args) {
            this._clazz = clazz;
            this._name = name;
            this._args = args;
            this._hashCode = this._clazz.hashCode() + this._name.hashCode();
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodKey) {
                MethodKey key = (MethodKey)obj;
                return this._clazz.equals(key._clazz) && this._name.equals(key._name) && Arrays.equals(this._args, key._args);
            }
            throw new IllegalArgumentException("Cannot compare " + this + " to " + obj);
        }
    }
}

