/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@planetelibre.org)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef GLOBAL_H
#define GLOBAL_H

#include <stdio.h>   // Standard includes MUST come first
#include <stdlib.h>  //
#include <iostream>  //



#include <string>

#include <list>

#include <map>

#include <cmath>
#include <cstdio>
#include <ctime>
#include <cstdlib>

using std::string;
using std::map;
using std::make_pair;

#include "debug.h"

#ifdef DEBUG_ON 
#include "mmgr.h"    
#endif // DEBUG_ON

#ifndef NONET
#define NONET 1
#endif

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif	

//#define MIN(x,y)    (((x)>(y))?(y):(x))
//#define MAX(x,y)    (((x)>(y))?(x):(y))

__inline int MIN(int x,int y) { return (x>y)?(y):(x); } 
__inline int MAX(int x,int y) { return (x>y)?(x):(y); } 

///
#define OK 0 
/// a terre sur le dos
#define GROUND 1 
/// a terre sur le ventre
#define DOWN 2 
/// ko
#define KO 3 
/// blesse
#define TOUCHED 4 
/// grievement blesse
#define INJURED 5 
/// mort
#define DEAD 6 
/// expluse
#define EJECTED 7 
/// en reserve
#define RESERVE 8 

/// score seuil a atteindre pour foutre un joueur out
#define OUT_LIMIT 10 
/// score seuil a atteindre pour foutre un joueur ko
#define KO_LIMIT 8 

/// ok
#define SUCCESS 0 
/// rate mais possibilite de relance
#define FAIL 1 
/// rate et plus possible de relancer
#define TOOBAD 2 
/// resultat de 1 sur tentative de passe
#define FUMBLE 3 
/// passe ratee 
#define MISSED 4  
/// agression rate et l'arbitre a vu le geste 
#define FAIL_AND_DOUBLE 5  
/// agression reussit mais l'arbitre m'a pecho
#define SUCCESS_BUT_DOUBLE 6  
/// impossible de faire une action
#define IMPOSSIBLE -1  

/// temps clement
#define GOOD 0 
/// canicule 
#define DOGDAYS 1 
/// ensoleille
#define SUNNY 2 
/// averse
#define SHOWER 3 
/// blissard
#define BLIZZARD 4  

/// nord
#define N 2 
/// sud
#define S 6 
/// est
#define E 4 
/// ouest
#define W 8 
/// nord-est
#define NE 3 
/// nord-ouest
#define NW 1 
/// sud-est
#define SE 5 
/// sud-ouest
#define SW 7 

/// direction lors de la touche
#define LEFT 0 
/// direction lors de la touche
#define SIDE 1 
/// direction lors de la touche
#define RIGHT 2 

/// de a 2 faces
#define D2 2 
/// de a 3 faces
#define D3 3 
/// de a 4 faces
#define D4 4 
/// de de blocage
#define DBLOCK 5 
/// de a 6 faces
#define D6 6 
/// de a 8 faces
#define D8 8 
/// de a 10 faces
#define D10 10 
/// de a 12 faces
#define D12 12 
/// de a 16 faces ?
#define D16 16 
/// de 66 (d6*10+d6)
#define D66 66 

/// crane  = moi plaque
#define SKULL 0 
/// crane et etoile == les deux sauf si blocage
#define SKULL_AND_STAR 1 
/// repousse
#define ARROW_1 2 
/// repousse
#define ARROW_2 3 
/// plaque sauf si esquive
#define STAR_IF 4 
/// plaque 
#define STAR 5 

/// passe eclair
#define FLASH_PASS -1 
/// passe eclair
#define NORMAL_PASS 0 
/// passe eclair
#define LONG_PASS 1 
/// passe eclair
#define BOMB_PASS 2 

#define KICKOFF_RIOT 2  // emeute
#define KICKOFF_REFEREE 3  // a mort l'arbitre
#define KICKOFF_DEFENSE 4  // defense parfaite
#define KICKOFF_SUPPORTERS 5  // supporters
#define KICKOFF_CANNONBALL 6  // boulet de canon
#define KICKOFF_WEATHER 7  // meteo
#define KICKOFF_SURPRISE 8  // surprise
#define KICKOFF_TRAINING 9  // entrainement
#define KICKOFF_BLITZ 10  // blitz
#define KICKOFF_ROCK 11  // rocher
#define KICKOFF_INVASION 12  // invasion du terrain

/// largeur du terrain
#define PLAYGROUND_WIDTH 15 
/// hauteur du terrain
#define PLAYGROUND_HEIGHT 26  

#define CORRIDOR_WIDTH 4 
#define MAX_PLAYER_ON_PLAYGROUND 11 
#define MAX_PLAYER_IN_CORRIDOR 2 
#define MIN_PLAYER_ON_CENTER_LINE 3 

/// identifiant de l'equipe neutre !?
#define NONE -1 
/// identifiant de l'equipe a domicile
#define HOME 0 
/// identifiant de l'equipe a l'exterieur
#define VISITOR 1 

#define BOTH 2 

/// nombre de mettre le paquet max
#define MAX_OVERMOVE 2 

#define SQUARE_SIZE 40 
#define FLASH_PASS_SIZE 160 
#define NORMAL_PASS_SIZE 300 
#define LONG_PASS_SIZE 440 
#define BOMB_PASS_SIZE 560 

/////////////////////////////
// Ragnar Modif3 : side step
#define MAX_PUSH_SQUARE 8 
/////////////////////////////
//#define MAX_PUSH_SQUARE 3 

#define MAX_NEIGHBOUR 8 
#define PASS_ARROW_PRECISION 10 
#define PASS_ARROW_MATRIX_MAX_SIZE (BOMB_PASS_SIZE/(SQUARE_SIZE/PASS_ARROW_PRECISION)) 

#define ACTIONS_NB 6 

#define MODE_NONE -1 
#define ACTIONS_NONE -1 

#define FIRST_HALF 0 
#define SECOND_HALF 1 
#define EXTRA_TIME 2 

#define DOCK_X 618 
#define DOCK_Y 365 
#define DOCK_W 104 
#define DOCK_H 324 

#define TRACE(x) x

#define GET_UP_COST 3 
#define KO_RECOVERY 4 

#define RESERVE_PAGE_COUNT 3  
#define RESERVE_PAGE_H 3 
#define RESERVE_PAGE_W 2 
 
#ifndef TBTHOME
#define TBTHOME "."
#endif

#define TEAM_PATH TBTHOME "/data/teams/"
#define IMG_PATH TBTHOME "/data/images/"
#define SAVES_PATH TBTHOME "/saves/"
#define VIDEOS_PATH TBTHOME "/data/videos/"
#define SOUNDS_PATH TBTHOME "/data/sounds/"
#define I18N_PATH TBTHOME "/data/i18n/"
#define FORMATIONS_PATH TBTHOME "/data/formations/"

#define CONFIG_FILE TBTHOME "/config.xml"

#define ADD_IMG_PATH(x) IMG_PATH x
#define ADD_TEAM_PATH(x) TEAM_PATH x
#define ADD_SAVES_PATH(x) SAVES_PATH x
#define ADD_VIDEOS_PATH(x) VIDEOS_PATH x
#define ADD_SOUNDS_PATH(x) SOUNDS_PATH x
#define ADD_I18N_PATH(x) I18N_PATH x
#define ADD_FORMATIONS_PATH(x) FORMATIONS_PATH x


#define NO_TRANSPARENT 0 
#define TRANSPARENT 1 

#define ATTACKER 0 
#define DEFENDER 1 



typedef struct {
char* filename;
char* name;
char* emblem;
}team_summary_t;

typedef struct {
team_summary_t* home;
team_summary_t* visitor;
} opponent_t;

typedef struct {
team_summary_t* teams[100]; 
int nb;
}team_list_t;

typedef struct {
bool visible;
char* msg;
int x;
int y;
int font;
}contextual_info_t;

#define CHAR_2 (sizeof(char*)*2)
#define CHAR_16 (sizeof(char*)*16)
#define CHAR_32 (sizeof(char*)*32)
#define CHAR_64 (sizeof(char*)*64)
#define CHAR_128 (sizeof(char*)*128)
#define CHAR_256 (sizeof(char*)*256)

// Tao's display cant seem to cope with alpha channels...
// this lets us turn alpha blending off globaly...
// set it to SDL_SRCALPHA if alpha blending is ok, 0 otherwise..
#define ALPHA_FLAGS SDL_SRCALPHA //0
#define MASK_ALPHA_FLAGS SDL_SRCALPHA

#endif
