/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.PGSQLIntegrityConstraintViolationException;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.utils.guava.Strings;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Iterator;
import java.util.List;

public class ErrorUtils {
    public static SQLWarning makeSQLWarningChain(List<Notice> notices) {
        Iterator<Notice> noticeIter = notices.iterator();
        SQLWarning root = null;
        if (noticeIter.hasNext()) {
            SQLWarning current = root = ErrorUtils.makeSQLWarning(noticeIter.next());
            while (noticeIter.hasNext()) {
                Notice notice = noticeIter.next();
                if (!notice.isWarning()) continue;
                SQLWarning nextWarning = ErrorUtils.makeSQLWarning(notice);
                current.setNextWarning(nextWarning);
                current = nextWarning;
            }
        }
        return root;
    }

    public static SQLException makeSQLExceptionChain(List<Notice> notices) {
        Iterator<Notice> noticeIter = notices.iterator();
        SQLException root = null;
        if (noticeIter.hasNext()) {
            SQLException current = root = ErrorUtils.makeSQLException("", noticeIter.next());
            while (noticeIter.hasNext()) {
                SQLException nextException = ErrorUtils.makeSQLException("", noticeIter.next());
                current.setNextException(nextException);
                current = nextException;
            }
        }
        return root;
    }

    public static SQLWarning makeSQLWarning(Notice notice) {
        if (!notice.isWarning()) {
            throw new IllegalArgumentException("notice not an error");
        }
        return new SQLWarning(notice.getMessage(), notice.getCode());
    }

    public static SQLException makeSQLException(Notice notice) {
        return ErrorUtils.makeSQLException("", notice);
    }

    public static SQLException makeSQLException(String message, Notice notice) {
        String code = notice.getCode();
        SQLException e = code.startsWith("23") ? new PGSQLIntegrityConstraintViolationException(message + Strings.nullToEmpty(notice.getMessage()), notice.getCode()) : new PGSQLSimpleException(message + Strings.nullToEmpty(notice.getMessage()), notice.getCode());
        e.setSchema(notice.getSchema());
        e.setTable(notice.getTable());
        e.setColumn(notice.getColumn());
        e.setDatatype(notice.getDatatype());
        e.setConstraint(notice.getConstraint());
        return e;
    }

    public static SQLWarning chainWarnings(SQLWarning base, SQLWarning add) {
        if (base == null) {
            return add;
        }
        SQLWarning current = base;
        while (current.getNextWarning() != null) {
            current = current.getNextWarning();
        }
        current.setNextWarning(add);
        return base;
    }
}

