/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.ris;

import de.undercouch.citeproc.bibtex.DateParser;
import de.undercouch.citeproc.bibtex.NameParser;
import de.undercouch.citeproc.csl.CSLDate;
import de.undercouch.citeproc.csl.CSLItemData;
import de.undercouch.citeproc.csl.CSLItemDataBuilder;
import de.undercouch.citeproc.csl.CSLName;
import de.undercouch.citeproc.csl.CSLType;
import de.undercouch.citeproc.ris.RISLibrary;
import de.undercouch.citeproc.ris.RISParser;
import de.undercouch.citeproc.ris.RISReference;
import de.undercouch.citeproc.ris.RISType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jbibtex.ParseException;

public class RISConverter {
    public RISLibrary loadLibrary(InputStream is) throws IOException, ParseException {
        InputStreamReader reader = new InputStreamReader(is, "UTF-8");
        RISParser parser = new RISParser();
        return parser.parse(reader);
    }

    public Map<String, CSLItemData> toItemData(RISLibrary lib) {
        HashMap<String, CSLItemData> result = new HashMap<String, CSLItemData>();
        for (RISReference ref : lib.getReferences()) {
            CSLItemData item = this.toItemData(ref);
            result.put(item.getId(), this.toItemData(ref));
        }
        return result;
    }

    public CSLItemData toItemData(RISReference ref) {
        CSLType type = this.toType(ref.getType());
        CSLItemDataBuilder builder = new CSLItemDataBuilder().type(type);
        if (ref.getId() != null) {
            builder.id(ref.getId());
        } else if (ref.getLabel() != null) {
            builder.id(ref.getLabel());
        }
        if (ref.getAccessDate() != null) {
            builder.accessed(DateParser.toDate(ref.getAccessDate()));
        }
        if (ref.getAuthors() != null) {
            builder.author(RISConverter.toAuthors(ref.getAuthors()));
        }
        if (ref.getEditors() != null) {
            builder.editor(RISConverter.toAuthors(ref.getEditors()));
        }
        if (ref.getJournal() != null) {
            builder.containerTitle(ref.getJournal());
            builder.collectionTitle(ref.getJournal());
        } else if (ref.getNameOfDatabase() != null) {
            builder.containerTitle(ref.getNameOfDatabase());
        } else {
            builder.containerTitle(ref.getBookOrConference());
            builder.collectionTitle(ref.getBookOrConference());
        }
        if (ref.getDate() != null) {
            CSLDate date = DateParser.toDate(ref.getDate());
            builder.issued(date);
            builder.eventDate(date);
        } else {
            CSLDate date = DateParser.toDate(ref.getYear());
            builder.issued(date);
            builder.eventDate(date);
        }
        builder.URL(ref.getURL());
        if (ref.getResearchNotes() != null) {
            builder.note(ref.getResearchNotes());
        } else {
            builder.note(StringUtils.join((Object[])ref.getNotes(), '\n'));
        }
        builder.issue(ref.getIssue());
        builder.number(ref.getNumber());
        builder.eventPlace(ref.getPlace());
        builder.publisherPlace(ref.getPlace());
        builder.abstrct(ref.getAbstrct());
        builder.callNumber(ref.getCallNumber());
        builder.DOI(ref.getDOI());
        builder.edition(ref.getEdition());
        builder.ISBN(ref.getIsbnOrIssn());
        builder.ISSN(ref.getIsbnOrIssn());
        builder.keyword(StringUtils.join((Object[])ref.getKeywords(), ','));
        builder.language(ref.getLanguage());
        builder.numberOfVolumes(ref.getNumberOfVolumes());
        builder.originalTitle(ref.getOriginalPublication());
        if (ref.getStartPage() != null && ref.getEndPage() != null) {
            builder.page(ref.getStartPage() + "-" + ref.getEndPage());
        } else if (ref.getStartPage() != null) {
            builder.page(ref.getStartPage());
        } else if (ref.getEndPage() != null) {
            builder.page(ref.getEndPage());
        }
        builder.publisher(ref.getPublisher());
        builder.reviewedTitle(ref.getReviewedItem());
        builder.section(ref.getSection());
        builder.shortTitle(ref.getShortTitle());
        builder.title(ref.getTitle());
        builder.volume(ref.getVolume());
        return builder.build();
    }

    public CSLType toType(RISType type) {
        switch (type) {
            case ABST: {
                return CSLType.ARTICLE;
            }
            case ADVS: {
                return CSLType.ARTICLE;
            }
            case AGGR: {
                return CSLType.DATASET;
            }
            case ANCIENT: {
                return CSLType.ARTICLE;
            }
            case ART: {
                return CSLType.ARTICLE;
            }
            case BILL: {
                return CSLType.BILL;
            }
            case BLOG: {
                return CSLType.WEBPAGE;
            }
            case BOOK: {
                return CSLType.BOOK;
            }
            case CASE: {
                return CSLType.LEGAL_CASE;
            }
            case CHAP: {
                return CSLType.CHAPTER;
            }
            case CHART: {
                return CSLType.ARTICLE;
            }
            case CLSWK: {
                return CSLType.ARTICLE;
            }
            case COMP: {
                return CSLType.ARTICLE;
            }
            case CONF: {
                return CSLType.PAPER_CONFERENCE;
            }
            case CPAPER: {
                return CSLType.PAPER_CONFERENCE;
            }
            case CTLG: {
                return CSLType.BOOK;
            }
            case DATA: {
                return CSLType.DATASET;
            }
            case DBASE: {
                return CSLType.DATASET;
            }
            case DICT: {
                return CSLType.ENTRY_DICTIONARY;
            }
            case EBOOK: {
                return CSLType.BOOK;
            }
            case ECHAP: {
                return CSLType.CHAPTER;
            }
            case EDBOOK: {
                return CSLType.BOOK;
            }
            case EJOUR: {
                return CSLType.ARTICLE_JOURNAL;
            }
            case ELEC: {
                return CSLType.ARTICLE;
            }
            case ENCYC: {
                return CSLType.ENTRY_ENCYCLOPEDIA;
            }
            case EQUA: {
                return CSLType.ARTICLE;
            }
            case FIGURE: {
                return CSLType.FIGURE;
            }
            case GOVDOC: {
                return CSLType.LEGISLATION;
            }
            case GRANT: {
                return CSLType.LEGISLATION;
            }
            case HEAR: {
                return CSLType.ARTICLE;
            }
            case ICOMM: {
                return CSLType.PERSONAL_COMMUNICATION;
            }
            case INPR: {
                return CSLType.PAPER_CONFERENCE;
            }
            case JFULL: {
                return CSLType.ARTICLE_JOURNAL;
            }
            case JOUR: {
                return CSLType.ARTICLE_JOURNAL;
            }
            case LEGAL: {
                return CSLType.LEGISLATION;
            }
            case MANSCPT: {
                return CSLType.MANUSCRIPT;
            }
            case MAP: {
                return CSLType.MAP;
            }
            case MGZN: {
                return CSLType.ARTICLE_MAGAZINE;
            }
            case MPCT: {
                return CSLType.MOTION_PICTURE;
            }
            case MULTI: {
                return CSLType.WEBPAGE;
            }
            case MUSIC: {
                return CSLType.SONG;
            }
            case NEWS: {
                return CSLType.ARTICLE_NEWSPAPER;
            }
            case PAMP: {
                return CSLType.PAMPHLET;
            }
            case PAT: {
                return CSLType.PATENT;
            }
            case PCOMM: {
                return CSLType.PERSONAL_COMMUNICATION;
            }
            case RPRT: {
                return CSLType.REPORT;
            }
            case SER: {
                return CSLType.ARTICLE;
            }
            case SLIDE: {
                return CSLType.ARTICLE;
            }
            case SOUND: {
                return CSLType.SONG;
            }
            case STAND: {
                return CSLType.ARTICLE;
            }
            case STAT: {
                return CSLType.LEGISLATION;
            }
            case THES: {
                return CSLType.THESIS;
            }
            case UNPB: {
                return CSLType.ARTICLE;
            }
            case VIDEO: {
                return CSLType.MOTION_PICTURE;
            }
        }
        return CSLType.ARTICLE;
    }

    private static CSLName[] toAuthors(String[] authors) {
        ArrayList<CSLName> result = new ArrayList<CSLName>();
        for (String a : authors) {
            CSLName[] names;
            for (CSLName n : names = NameParser.parse(a)) {
                result.add(n);
            }
        }
        return result.toArray(new CSLName[result.size()]);
    }
}

