/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.io.FileUtil;

public class OpenOfficeFileSearch {
    public static List<Path> detectInstallations() {
        if (OS.WINDOWS) {
            List<Path> programDirs = OpenOfficeFileSearch.findWindowsOpenOfficeDirs();
            return programDirs.stream().filter(dir -> FileUtil.find("soffice.exe", dir).isPresent()).collect(Collectors.toList());
        }
        if (OS.OS_X) {
            List<Path> programDirs = OpenOfficeFileSearch.findOSXOpenOfficeDirs();
            return programDirs.stream().filter(dir -> FileUtil.find("soffice", dir).isPresent()).collect(Collectors.toList());
        }
        if (OS.LINUX) {
            List<Path> programDirs = OpenOfficeFileSearch.findLinuxOpenOfficeDirs();
            return programDirs.stream().filter(dir -> FileUtil.find("soffice", dir).isPresent()).collect(Collectors.toList());
        }
        return new ArrayList<Path>(0);
    }

    private static List<Path> findOpenOfficeDirectories(List<Path> programDirectories) {
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path programDir : programDirectories) {
            File[] subDirs = programDir.toFile().listFiles(File::isDirectory);
            if (subDirs == null) continue;
            for (File dir : subDirs) {
                if (!dir.getPath().toLowerCase(Locale.ROOT).contains("openoffice") && !dir.getPath().toLowerCase(Locale.ROOT).contains("libreoffice")) continue;
                result.add(dir.toPath());
            }
        }
        return result;
    }

    private static List<Path> findWindowsOpenOfficeDirs() {
        ArrayList<Path> sourceList = new ArrayList<Path>();
        String progFiles = System.getenv("ProgramFiles");
        if (progFiles != null) {
            sourceList.add(Paths.get(progFiles, new String[0]));
        }
        if ((progFiles = System.getenv("ProgramFiles(x86)")) != null) {
            sourceList.add(Paths.get(progFiles, new String[0]));
        }
        return OpenOfficeFileSearch.findOpenOfficeDirectories(sourceList);
    }

    private static List<Path> findOSXOpenOfficeDirs() {
        List<Path> sourceList = Arrays.asList(Paths.get("/Applications", new String[0]));
        return OpenOfficeFileSearch.findOpenOfficeDirectories(sourceList);
    }

    private static List<Path> findLinuxOpenOfficeDirs() {
        List<Path> sourceList = Arrays.asList(Paths.get("/usr/lib", new String[0]), Paths.get("/usr/lib64", new String[0]), Paths.get("/opt", new String[0]));
        return OpenOfficeFileSearch.findOpenOfficeDirectories(sourceList);
    }
}

