/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.strings;

import java.util.HashMap;
import java.util.Map;

public class HTMLUnicodeConversionMaps {
    public static final Map<String, String> HTML_LATEX_CONVERSION_MAP = new HashMap<String, String>();
    public static final Map<Integer, String> ESCAPED_ACCENTS = new HashMap<Integer, String>();
    public static final Map<String, String> UNICODE_ESCAPED_ACCENTS = new HashMap<String, String>();
    public static final Map<Integer, String> NUMERICAL_LATEX_CONVERSION_MAP = new HashMap<Integer, String>();
    public static final Map<String, String> UNICODE_LATEX_CONVERSION_MAP = new HashMap<String, String>();
    public static final Map<String, String> LATEX_HTML_CONVERSION_MAP = new HashMap<String, String>();
    public static final Map<String, String> LATEX_UNICODE_CONVERSION_MAP = new HashMap<String, String>();
    private static final String[][] CONVERSION_LIST = new String[][]{{"160", "nbsp", "{~}"}, {"161", "iexcl", "{\\textexclamdown}"}, {"162", "cent", "{\\textcent}"}, {"163", "pound", "{\\pounds}"}, {"164", "curren", "{\\textcurrency}"}, {"165", "yen", "{\\textyen}"}, {"166", "brvbar", "{\\textbrokenbar}"}, {"167", "sect", "{{\\S}}"}, {"168", "uml", "{\\\"{}}"}, {"169", "copy", "{\\copyright}"}, {"170", "ordf", "{\\textordfeminine}"}, {"171", "laquo", "{\\guillemotleft}"}, {"172", "not", "$\\neg$"}, {"173", "shy", "\\-"}, {"174", "reg", "{\\textregistered}"}, {"175", "macr", "{\\={}}"}, {"176", "deg", "{$^{\\circ}$}"}, {"177", "plusmn", "$\\pm$"}, {"178", "sup2", "\\textsuperscript{2}"}, {"179", "sup3", "\\textsuperscript{3}"}, {"180", "acute", "{\\'{}}"}, {"181", "micro", "$\\mu$"}, {"", "mu", "$\\mu$"}, {"182", "para", "{{\\P}}"}, {"183", "middot", "$\\cdot$"}, {"184", "cedil", "{\\c{}}"}, {"185", "sup1", "\\textsuperscript{1}"}, {"186", "ordm", "{\\textordmasculine}"}, {"187", "raquo", "{\\guillemotright}"}, {"188", "frac14", "$\\sfrac{1}{4}$"}, {"189", "frac12", "$\\sfrac{1}{2}$"}, {"190", "frac34", "$\\sfrac{3}{4}$"}, {"191", "iquest", "{\\textquestiondown}"}, {"192", "Agrave", "{{\\`{A}}}"}, {"193", "Aacute", "{{\\'{A}}}"}, {"194", "Acirc", "{{\\^{A}}}"}, {"195", "Atilde", "{{\\~{A}}}"}, {"196", "Auml", "{{\\\"{A}}}"}, {"197", "Aring", "{{\\AA}}"}, {"198", "AElig", "{{\\AE}}"}, {"199", "Ccedil", "{{\\c{C}}}"}, {"200", "Egrave", "{{\\`{E}}}"}, {"201", "Eacute", "{{\\'{E}}}"}, {"202", "Ecirc", "{{\\^{E}}}"}, {"203", "Euml", "{{\\\"{E}}}"}, {"204", "Igrave", "{{\\`{I}}}"}, {"205", "Iacute", "{{\\'{I}}}"}, {"206", "Icirc", "{{\\^{I}}}"}, {"207", "Iuml", "{{\\\"{I}}}"}, {"208", "ETH", "{{\\DH}}"}, {"209", "Ntilde", "{{\\~{N}}}"}, {"210", "Ograve", "{{\\`{O}}}"}, {"211", "Oacute", "{{\\'{O}}}"}, {"212", "Ocirc", "{{\\^{O}}}"}, {"213", "Otilde", "{{\\~{O}}}"}, {"214", "Ouml", "{{\\\"{O}}}"}, {"215", "times", "$\\times$"}, {"216", "Oslash", "{{\\O}}"}, {"217", "Ugrave", "{{\\`{U}}}"}, {"218", "Uacute", "{{\\'{U}}}"}, {"219", "Ucirc", "{{\\^{U}}}"}, {"220", "Uuml", "{{\\\"{U}}}"}, {"221", "Yacute", "{{\\'{Y}}}"}, {"222", "THORN", "{{\\TH}}"}, {"223", "szlig", "{\\ss}"}, {"224", "agrave", "{\\`{a}}"}, {"225", "aacute", "{\\'{a}}"}, {"226", "acirc", "{\\^{a}}"}, {"227", "atilde", "{\\~{a}}"}, {"228", "auml", "{\\\"{a}}"}, {"229", "aring", "{{\\aa}}"}, {"230", "aelig", "{\\ae}"}, {"231", "ccedil", "{\\c{c}}"}, {"232", "egrave", "{\\`{e}}"}, {"233", "eacute", "{\\'{e}}"}, {"234", "ecirc", "{\\^{e}}"}, {"235", "euml", "{\\\"{e}}"}, {"236", "igrave", "{\\`{i}}"}, {"237", "iacute", "{\\'{i}}"}, {"238", "icirc", "{\\^{i}}"}, {"239", "iuml", "{\\\"{i}}"}, {"240", "eth", "{\\dh}"}, {"241", "ntilde", "{\\~{n}}"}, {"242", "ograve", "{\\`{o}}"}, {"243", "oacute", "{\\'{o}}"}, {"244", "ocirc", "{\\^{o}}"}, {"245", "otilde", "{\\~{o}}"}, {"246", "ouml", "{\\\"{o}}"}, {"247", "divide", "$\\div$"}, {"248", "oslash", "{\\o}"}, {"249", "ugrave", "{\\`{u}}"}, {"250", "uacute", "{\\'{u}}"}, {"251", "ucirc", "{\\^{u}}"}, {"252", "uuml", "{\\\"{u}}"}, {"253", "yacute", "{\\'{y}}"}, {"254", "thorn", "{\\th}"}, {"255", "yuml", "{\\\"{y}}"}, {"913", "Alpha", "{{$\\Alpha$}}"}, {"914", "Beta", "{{$\\Beta$}}"}, {"915", "Gamma", "{{$\\Gamma$}}"}, {"916", "Delta", "{{$\\Delta$}}"}, {"917", "Epsilon", "{{$\\Epsilon$}}"}, {"918", "Zeta", "{{$\\Zeta$}}"}, {"919", "Eta", "{{$\\Eta$}}"}, {"920", "Theta", "{{$\\Theta$}}"}, {"921", "Iota", "{{$\\Iota$}}"}, {"922", "Kappa", "{{$\\Kappa$}}"}, {"923", "Lambda", "{{$\\Lambda$}}"}, {"924", "Mu", "{{$\\Mu$}}"}, {"925", "Nu", "{{$\\Nu$}}"}, {"926", "Xi", "{{$\\Xi$}}"}, {"927", "Omicron", "{{$\\Omicron$}}"}, {"928", "Pi", "{{$\\Pi$}}"}, {"929", "Rho", "{{$\\Rho$}}"}, {"931", "Sigma", "{{$\\Sigma$}}"}, {"932", "Tau", "{{$\\Tau$}}"}, {"933", "Upsilon", "{{$\\Upsilon$}}"}, {"934", "Phi", "{{$\\Phi$}}"}, {"935", "Chi", "{{$\\Chi$}}"}, {"936", "Psi", "{{$\\Psi$}}"}, {"937", "Omega", "{{$\\Omega$}}"}, {"945", "alpha", "$\\alpha$"}, {"946", "beta", "$\\beta$"}, {"947", "gamma", "$\\gamma$"}, {"948", "delta", "$\\delta$"}, {"949", "epsilon", "$\\epsilon$"}, {"950", "zeta", "$\\zeta$"}, {"951", "eta", "$\\eta$"}, {"952", "theta", "$\\theta$"}, {"953", "iota", "$\\iota$"}, {"954", "kappa", "$\\kappa$"}, {"955", "lambda", "$\\lambda$"}, {"956", "mu", "$\\mu$"}, {"957", "nu", "$\\nu$"}, {"958", "xi", "$\\xi$"}, {"959", "omicron", "$\\omicron$"}, {"960", "pi", "$\\phi$"}, {"961", "rho", "$\\rho$"}, {"962", "sigmaf", "$\\varsigma$"}, {"963", "sigma", "$\\sigma$"}, {"964", "tau", "$\\tau$"}, {"965", "upsilon", "$\\upsilon$"}, {"", "upsi", "$\\upsilon$"}, {"966", "phi", "$\\phi$"}, {"967", "chi", "$\\chi$"}, {"968", "psi", "$\\psi$"}, {"969", "omega", "$\\omega$"}, {"977", "thetasym", "$\\vartheta$"}, {"", "thetav", "$\\vartheta$"}, {"", "vartheta", "$\\vartheta$"}, {"978", "upsih", "{{$\\Upsilon$}}"}, {"982", "piv", "$\\varphi$"}, {"8211", "ndash", "$\\textendash$"}, {"8212", "mdash", "$\\textemdash$"}, {"8226", "bull", "$\\bullet$"}, {"8230", "hellip", "{\\ldots}"}, {"8242", "prime", "$\\prime$"}, {"8243", "Prime", "$\\prime\\prime$"}, {"8254", "oline", "{\\={}}"}, {"8260", "frasl", "/"}, {"8472", "weierp", "$\\wp$"}, {"8465", "image", "{{$\\Im$}}"}, {"8476", "real", "{{$\\Re$}}"}, {"8482", "trade", "{\\texttrademark}"}, {"8501", "alefsym", "$\\aleph$"}, {"8592", "larr", "$\\leftarrow$"}, {"8593", "uarr", "$\\uparrow$"}, {"8594", "rarr", "$\\rightarrow$"}, {"8595", "darr", "$\\downarrow$"}, {"8596", "harr", "$\\leftrightarrow$"}, {"8629", "crarr", "$\\dlsh$"}, {"8656", "lArr", "{{$\\Leftarrow$}}"}, {"8657", "uArr", "{{$\\Uparrow$}}"}, {"8658", "rArr", "{{$\\Rightarrow$}}"}, {"8659", "dArr", "{{$\\Downarrow$}}"}, {"8660", "hArr", "{{$\\Leftrightarrow$}}"}, {"8704", "forall", "$\\forall$"}, {"8706", "part", "$\\partial$"}, {"8707", "exist", "$\\exists$"}, {"8709", "empty", "$\\emptyset$"}, {"8711", "nabla", "$\\nabla$"}, {"8712", "isin", "$\\in$"}, {"8713", "notin", "$\\notin$"}, {"8715", "ni", "$\\ni$"}, {"8719", "prod", "$\\prod$"}, {"8721", "sum", "$\\sum$"}, {"8722", "minus", "$-$"}, {"8727", "lowast", "$\\ast$"}, {"8730", "radic", "$\\sqrt{}$"}, {"8733", "prop", "$\\propto$"}, {"8734", "infin", "$\\infty$"}, {"8736", "ang", "$\\angle$"}, {"8743", "and", "$\\land$"}, {"8744", "or", "$\\lor$"}, {"8745", "cap", "$\\cap$"}, {"8746", "cup", "$\\cup$"}, {"8747", "int", "$\\int$"}, {"8756", "there4", "$\\therefore$"}, {"8764", "sim", "$\\sim$"}, {"8773", "cong", "$\\cong$"}, {"8776", "asymp", "$\\approx$"}, {"8800", "ne", "$\\neq$"}, {"8801", "equiv", "$\\equiv$"}, {"8804", "le", "$\\leq$"}, {"8805", "ge", "$\\geq$"}, {"8834", "sub", "$\\subset$"}, {"8835", "sup", "$\\supset$"}, {"8836", "nsub", "$\\not\\subset$"}, {"8838", "sube", "$\\subseteq$"}, {"8839", "supe", "$\\supseteq$"}, {"8853", "oplus", "$\\oplus$"}, {"8855", "otimes", "$\\otimes$"}, {"8869", "perp", "$\\perp$"}, {"8901", "sdot", "$\\cdot$"}, {"8968", "lceil", "$\\lceil$"}, {"8969", "rceil", "$\\rceil$"}, {"8970", "lfloor", "$\\lfloor$"}, {"8971", "rfloor", "$\\rfloor$"}, {"9001", "lang", "$\\langle$"}, {"9002", "rang", "$\\rangle$"}, {"9674", "loz", "$\\lozenge$"}, {"9824", "spades", "$\\spadesuit$"}, {"9827", "clubs", "$\\clubsuit$"}, {"9829", "hearts", "$\\heartsuit$"}, {"9830", "diams", "$\\diamondsuit$"}, {"34", "quot", "\""}, {"38", "amp", "\\&"}, {"60", "lt", "$<$"}, {"62", "gt", "$>$"}, {"8194", "ensp", "\\hspace{0.5em}"}, {"8195", "emsp", "\\hspace{1em}"}, {"8201", "thinsp", "\\hspace{0.167em}"}, {"8202", "", "\\hspace{0.1em}"}, {"8204", "zwnj", "\\/{}"}, {"8205", "zwj", ""}, {"8206", "lrm", ""}, {"8207", "rlm", ""}, {"8211", "ndash", "--"}, {"8212", "mdash", "---"}, {"8216", "lsquo", "{\\textquoteleft}"}, {"8217", "rsquo", "{\\textquoteright}"}, {"8218", "sbquo", "{\\quotesinglbase}"}, {"8220", "ldquo", "{\\textquotedblleft}"}, {"8221", "rdquo", "{\\textquotedblright}"}, {"8222", "bdquo", "{\\quotedblbase}"}, {"8224", "dagger", "{\\dag}"}, {"8225", "Dagger", "{\\ddag}"}, {"8240", "permil", "{\\textperthousand}"}, {"8249", "lsaquo", "{\\guilsinglleft}"}, {"8250", "rsaquo", "{\\guilsinglright}"}, {"8364", "euro", "{\\texteuro}"}, {"35", "", "\\#"}, {"36", "dollar", "\\$"}, {"37", "#37", "\\%"}, {"39", "apos", "'"}, {"40", "lpar", "("}, {"41", "rpar", ")"}, {"42", "", "*"}, {"43", "plus", "+"}, {"44", "comma", ","}, {"45", "hyphen", "-"}, {"46", "period", "."}, {"47", "slash", "/"}, {"58", "colon", ":"}, {"59", "semi", ";"}, {"61", "equals", "="}, {"91", "lsqb", "["}, {"92", "bsol", "{\\textbackslash}"}, {"93", "rsqb", "]"}, {"94", "Hat", "{\\^{}}"}, {"95", "lowbar", "\\_"}, {"96", "grave", "{\\`{}}"}, {"123", "lbrace", "\\{"}, {"", "lcub", "\\{"}, {"124", "vert", "|"}, {"", "verbar", "|"}, {"", "VerticalLine", "|"}, {"125", "rbrace", "\\}"}, {"", "rcub", "\\}"}, {"145", "", "`"}, {"146", "", "'"}, {"147", "", "``"}, {"148", "", "''"}, {"150", "", "--"}, {"256", "", "{{\\={A}}}"}, {"257", "", "{\\={a}}"}, {"258", "", "{{\\u{A}}}"}, {"259", "", "{\\u{a}}"}, {"260", "Aogon", "{{\\k{A}}}"}, {"261", "aogon", "{\\k{a}}"}, {"262", "Cacute", "{{\\'{C}}}"}, {"263", "cacute", "{\\'{c}}"}, {"264", "Ccirc", "{{\\^{C}}}"}, {"265", "ccirc", "{\\^{c}}"}, {"266", "Cdot", "{{\\.{C}}}"}, {"267", "cdot", "{\\.{c}}"}, {"268", "Ccaron", "{{\\v{C}}}"}, {"269", "ccaron", "{\\v{c}}"}, {"270", "", "{{\\v{D}}}"}, {"271", "", "{\\v{d}}"}, {"272", "Dstrok", "{{\\DJ}}"}, {"273", "dstrok", "{{\\dj}}"}, {"274", "", "{{\\={E}}}"}, {"275", "", "{\\={e}}"}, {"276", "", "{{\\u{E}}}"}, {"277", "", "{\\u{e}}"}, {"278", "", "{{\\.{E}}}"}, {"279", "", "{\\.{e}}"}, {"280", "Eogon", "{{\\k{E}}}"}, {"281", "eogon", "{\\k{e}}"}, {"282", "", "{{\\v{E}}}"}, {"283", "", "{\\v{e}}"}, {"284", "", "{{\\^{G}}}"}, {"285", "", "{\\^{g}}"}, {"286", "", "{{\\u{G}}}"}, {"287", "", "{\\u{g}}"}, {"288", "", "{{\\.{G}}}"}, {"289", "", "{\\.{g}}"}, {"290", "", "{{\\c{G}}}"}, {"291", "", "{\\c{g}}"}, {"292", "", "{{\\^{H}}}"}, {"293", "", "{\\^{h}}"}, {"294", "", "{{\\B{H}}}"}, {"295", "", "{\\B{h}}"}, {"296", "", "{{\\~{I}}}"}, {"297", "", "{\\~{\\i}}"}, {"298", "Imacr", "{{\\={I}}}"}, {"299", "imacr", "{\\={\\i}}"}, {"300", "", "{{\\u{I}}}"}, {"301", "", "{\\u{\\i}}"}, {"302", "Iogon", "{{\\k{I}}}"}, {"303", "iogon", "{\\k{i}}"}, {"304", "Idot", "{{\\.{I}}}"}, {"305", "inodot", "{\\i}"}, {"", "imath", "{\\i}"}, {"306", "", "{{\\IJ}}"}, {"307", "", "{{\\ij}}"}, {"308", "", "{{\\^{J}}}"}, {"309", "", "{\\^{\\j}}"}, {"310", "", "{{\\c{K}}}"}, {"311", "", "{\\c{k}}"}, {"312", "", "{\\textkra}"}, {"313", "", "{{\\'{L}}}"}, {"314", "", "{\\'{l}}"}, {"315", "", "{{\\c{L}}}"}, {"316", "", "{\\c{l}}"}, {"317", "", "{{\\v{L}}}"}, {"318", "", "{\\v{l}}"}, {"321", "Lstrok", "{{\\L}}"}, {"322", "lstrok", "{{\\l}}"}, {"323", "Nacute", "{{\\'{N}}}"}, {"324", "nacute", "{{\\'{n}}}"}, {"325", "", "{{\\c{N}}}"}, {"326", "", "{\\c{n}}"}, {"327", "", "{{\\v{N}}}"}, {"328", "", "{\\v{n}}"}, {"329", "", "{'n}"}, {"330", "", "{{\\NG}}"}, {"331", "", "{{\\ng}}"}, {"332", "Omacro", "{{\\={O}}}"}, {"333", "omacro", "{\\={o}}"}, {"334", "", "{{\\u{O}}}"}, {"335", "", "{\\u{o}}"}, {"336", "", "{{\\H{O}}}"}, {"337", "", "{\\H{o}}"}, {"338", "OElig", "{{\\OE}}"}, {"339", "oelig", "{{\\oe}}"}, {"340", "", "{{\\'{R}}}"}, {"341", "", "{{\\'{r}}}"}, {"342", "", "{{\\c{R}}}"}, {"343", "", "{{\\c{r}}}"}, {"344", "", "{{\\v{R}}}"}, {"345", "", "{{\\v{r}}}"}, {"346", "", "{{\\'{S}}}"}, {"347", "", "{{\\'{s}}}"}, {"348", "Scirc", "{{\\^{S}}}"}, {"349", "scirc", "{\\^{s}}"}, {"350", "Scedil", "{{\\c{S}}}"}, {"351", "scedil", "{\\c{s}}"}, {"352", "Scaron", "{{\\v{S}}}"}, {"353", "scaron", "{\\v{s}}"}, {"354", "", "{{\\c{T}}}"}, {"355", "", "{{\\c{T}}}"}, {"356", "", "{{\\v{T}}}"}, {"357", "", "{\\v{t}}"}, {"358", "", "{{\\B{T}}}"}, {"359", "", "{\\B{t}}"}, {"360", "", "{{\\~{U}}}"}, {"361", "", "{\\~{u}}"}, {"362", "", "{{\\={U}}}"}, {"363", "", "{\\={u}}"}, {"364", "", "{{\\u{U}}}"}, {"365", "", "{\\u{u}}"}, {"366", "", "{{\\r{U}}}"}, {"367", "", "{\\r{u}}"}, {"368", "", "{{\\={U}}}"}, {"369", "", "{\\={u}}"}, {"370", "Uogon", "{{\\k{U}}}"}, {"371", "uogon", "{\\k{u}}"}, {"372", "", "{{\\^{W}}}"}, {"373", "", "{\\^{w}}"}, {"374", "", "{{\\^{Y}}}"}, {"375", "", "{\\^{y}}"}, {"376", "Yuml", "{{\\\"{Y}}}"}, {"377", "", "{{\\'{Z}}}"}, {"378", "", "{\\'{z}}"}, {"379", "", "{{\\.{Z}}}"}, {"380", "", "{\\.{z}}"}, {"381", "Zcaron", "{{\\v{Z}}}"}, {"382", "zcaron", "{\\v{z}}"}, {"384", "", "{\\B{b}}"}, {"402", "fnof", "\\textit{f}"}, {"405", "", "{{\\hv}}"}, {"416", "", "{{\\OHORN}}"}, {"417", "", "{{\\ohorn}}"}, {"431", "", "{{\\UHORN}}"}, {"432", "", "{{\\uhorn}}"}, {"490", "Oogon", "{{\\k{O}}}"}, {"491", "oogon", "{\\k{o}}"}, {"492", "", "{{\\k{\\={O}}}}"}, {"493", "", "{\\k{\\={o}}}"}, {"536", "", "{{\\cb{S}}}"}, {"537", "", "{\\cb{s}}"}, {"538", "", "{{\\cb{T}}}"}, {"539", "", "{\\cb{t}}"}, {"710", "circ", "{\\^{}}"}, {"726", "", "+"}, {"727", "", "-"}, {"728", "breve", "{\\u{}}"}, {"", "Breve", "{\\u{}}"}, {"729", "dot", "{\\.{}}"}, {"730", "ring", "{\\r{}}"}, {"731", "ogon", "{\\k{}}"}, {"732", "tilde", "\\~{}"}, {"733", "dblac", "{{\\H{}}}"}, {"949", "epsi", "$\\epsilon$"}, {"1013", "epsiv", "$\\varepsilonup$"}, {"8192", "", "\\hspace{0.5em}"}, {"8193", "", "\\hspace{1em}"}, {"8196", "", "\\hspace{0.333em}"}, {"8197", "", "\\hspace{0.25em}"}, {"8198", "", "\\hspace{0.167em}"}, {"8208", "hyphen", "-"}, {"8229", "nldr", "\\.{}\\.{}"}, {"8241", "", "{\\textpertenthousand}"}, {"8244", "", "{$\\prime\\prime\\prime$}"}, {"8251", "", "{\\textreferencemark}"}, {"8253", "", "{\\textinterrobang}"}, {"8320", "", "$_{0}$"}, {"8321", "", "$_{1}$"}, {"8322", "", "$_{2}$"}, {"8323", "", "$_{3}$"}, {"8324", "", "$_{4}$"}, {"8325", "", "$_{5}$"}, {"8326", "", "$_{6}$"}, {"8327", "", "$_{7}$"}, {"8328", "", "$_{8}$"}, {"8329", "", "$_{9}$"}, {"8330", "", "$_{+}$"}, {"8331", "", "$_{-}$"}, {"8332", "", "$_{-}$"}, {"8333", "", "$_{(}$"}, {"8334", "", "$_{)}$"}, {"8450", "complexes", "$\\mathbb{C}$"}, {"8451", "", "{\\textcelsius}"}, {"8459", "Hscr", "{{$\\mathcal{H}$}}"}, {"8460", "Hfr", "{{$\\mathbb{H}$}}"}, {"8466", "Lscr", "{{$\\mathcal{L}$}}"}, {"8467", "ell", "{$\\ell$}"}, {"8469", "naturals", "{{$\\mathbb{N}$}}"}, {"8474", "Qopf", "{{$\\mathbb{Q}$}}"}, {"8477", "reals", "{{$\\mathbb{R}$}}"}, {"8486", "", "${{\\Omega}}$"}, {"8491", "angst", "{{\\AA}}"}, {"8496", "Escr", "{{$\\mathcal{E}$}}"}, {"8531", "frac13", "$\\sfrac{1}{3}$"}, {"8532", "frac23", "$\\sfrac{2}{3}$"}, {"8533", "frac15", "$\\sfrac{1}{5}$"}, {"8534", "frac25", "$\\sfrac{2}{5}$"}, {"8535", "frac35", "$\\sfrac{3}{5}$"}, {"8536", "frac45", "$\\sfrac{4}{5}$"}, {"8537", "frac16", "$\\sfrac{1}{6}$"}, {"8538", "frac56", "$\\sfrac{5}{6}$"}, {"8539", "frac18", "$\\sfrac{1}{8}$"}, {"8540", "frac38", "$\\sfrac{3}{8}$"}, {"8541", "frac58", "$\\sfrac{5}{8}$"}, {"8542", "frac78", "$\\sfrac{7}{8}$"}, {"8710", "", "$\\triangle$"}, {"8714", "", "$\\in$"}, {"8723", "mp", "$\\mp$"}, {"8729", "bullet", "$\\bullet$"}, {"8741", "", "$\\parallel$"}, {"8758", "ratio", ":"}, {"8771", "sime", "$\\simeq$"}, {"8776", "ap", "$\\approx$"}, {"8810", "ll", "$\\ll$"}, {"", "Lt", "$\\ll$"}, {"8811", "gg", "$\\gg$"}, {"", "Gt", "$\\gg$"}, {"8818", "lsim", "$\\lesssim$"}, {"8819", "gsim", "$\\gtrsim$"}, {"8862", "boxplus", "$\\boxplus$"}, {"8863", "boxminus", "$\\boxminus$"}, {"8864", "boxtimes", "$\\boxtimes$"}, {"8882", "vltri", "$\\triangleleft$"}, {"8883", "vrtri", "$\\triangleright$"}, {"8896", "xwedge", "$\\bigwedge$"}, {"8897", "xvee", "$\\bigvee$"}, {"8942", "vdots", "$\\vdots$"}, {"8943", "cdots", "$\\cdots$"}, {"8945", "ddots", "$\\ddots$"}, {"9426", "circledc", "{\\copyright}"}, {"9633", "square", "$\\square$"}, {"9651", "xutri", "$\\bigtriangleup$"}, {"9653", "utri", "$\\triangle$"}, {"10877", "les", "$\\leqslant$"}, {"10878", "ges", "$\\geqslant$"}, {"64256", "", "ff"}, {"64257", "", "fi"}, {"64258", "", "fl"}, {"64259", "", "ffi"}, {"64260", "", "ffl"}, {"119978", "Oscr", "$\\mathcal{O}$"}, {"119984", "Uscr", "$\\mathcal{U}$"}};
    private static final String[][] ACCENT_LIST = new String[][]{{"768", "`"}, {"769", "'"}, {"770", "^"}, {"771", "~"}, {"772", "="}, {"773", "="}, {"774", "u"}, {"775", "."}, {"776", "\""}, {"777", "h"}, {"778", "r"}, {"779", "H"}, {"780", "v"}, {"781", "|"}, {"782", "U"}, {"783", "G"}, {"784", "textdotbreve"}, {"785", "t"}, {"788", "textrevcommaabove"}, {"789", "textcommaabover"}, {"790", "textsubgrave"}, {"791", "textsubacute"}, {"792", "textadvancing"}, {"793", "textretracting"}, {"794", "textlangleabove"}, {"795", "textrighthorn"}, {"796", "textsublhalfring"}, {"797", "textraising"}, {"798", "textlowering"}, {"799", "textsubplus"}, {"800", "textsubbar"}, {"801", "textpalhookbelow"}, {"802", "M"}, {"803", "d"}, {"804", "textsubumlaut"}, {"805", "textsubring"}, {"806", "cb"}, {"807", "c"}, {"808", "k"}, {"809", "textsyllabic"}, {"810", "textsubbridge"}, {"811", "textsubw"}, {"812", "textsubwedge"}, {"813", "textsubcircum"}, {"814", "textsubbreve"}, {"815", "textsubarch"}, {"816", "textsubtilde"}, {"817", "b"}, {"818", "b"}, {"819", "subdoublebar"}, {"820", "textsuperimposetilde"}, {"821", "B"}, {"822", "textlstrokethru"}, {"823", "textsstrikethru"}, {"824", "textlstrikethru"}, {"825", "textsubrhalfring"}, {"826", "textinvsubbridge"}, {"827", "textsubsquare"}, {"828", "textseagull"}, {"829", "textovercross"}, {"838", "overbridge"}, {"839", "subdoublebar"}, {"840", "subdoublevert"}, {"841", "subcorner"}, {"842", "crtilde"}, {"843", "dottedtilde"}, {"844", "doubletilde"}, {"845", "spreadlips"}, {"846", "whistle"}, {"861", "textdoublebreve"}, {"862", "textdoublemacron"}, {"863", "textdoublemacronbelow"}, {"864", "textdoubletilde"}, {"865", "texttoptiebar"}, {"866", "sliding"}};

    private HTMLUnicodeConversionMaps() {
    }

    private static String cleanLaTeX(String escapedString) {
        return escapedString.replaceAll("[\\\\\\{\\}\\$]", "");
    }

    static {
        for (String[] aConversionList : CONVERSION_LIST) {
            if (aConversionList[2].isEmpty()) continue;
            String strippedLaTeX = HTMLUnicodeConversionMaps.cleanLaTeX(aConversionList[2]);
            if (!aConversionList[1].isEmpty()) {
                HTML_LATEX_CONVERSION_MAP.put("&" + aConversionList[1] + ";", aConversionList[2]);
                if (!strippedLaTeX.isEmpty()) {
                    LATEX_HTML_CONVERSION_MAP.put(strippedLaTeX, "&" + aConversionList[1] + ";");
                }
            } else if (!aConversionList[0].isEmpty() && !strippedLaTeX.isEmpty()) {
                LATEX_HTML_CONVERSION_MAP.put(strippedLaTeX, "&#" + aConversionList[0] + ";");
            }
            if (aConversionList[0].isEmpty()) continue;
            NUMERICAL_LATEX_CONVERSION_MAP.put(Integer.decode(aConversionList[0]), aConversionList[2]);
            if (Integer.decode(aConversionList[0]) <= 128) continue;
            String unicodeSymbol = String.valueOf(Character.toChars(Integer.decode(aConversionList[0])));
            UNICODE_LATEX_CONVERSION_MAP.put(unicodeSymbol, aConversionList[2]);
            if (strippedLaTeX.isEmpty()) continue;
            LATEX_UNICODE_CONVERSION_MAP.put(strippedLaTeX, unicodeSymbol);
        }
        for (String[] anAccentList : ACCENT_LIST) {
            ESCAPED_ACCENTS.put(Integer.decode(anAccentList[0]), anAccentList[1]);
            UNICODE_ESCAPED_ACCENTS.put(anAccentList[1], String.valueOf(Character.toChars(Integer.decode(anAccentList[0]))));
        }
        LATEX_HTML_CONVERSION_MAP.put("$", "&dollar;");
        LATEX_UNICODE_CONVERSION_MAP.put("$", "$");
        LATEX_HTML_CONVERSION_MAP.put("AA", "&Aring;");
        LATEX_UNICODE_CONVERSION_MAP.put("AA", "\u00c5");
        LATEX_UNICODE_CONVERSION_MAP.put("'n", "\u0144");
        LATEX_HTML_CONVERSION_MAP.put("relax", "");
        LATEX_UNICODE_CONVERSION_MAP.put("relax", "");
        LATEX_HTML_CONVERSION_MAP.put("textquotesingle", "&#39;");
        LATEX_UNICODE_CONVERSION_MAP.put("textquotesingle", "'");
    }
}

