/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;

class ConcatView<E>
extends AbstractList<E> {
    private final List<? extends E> first;
    private final List<? extends E> second;

    static <E> List<E> create(List<List<? extends E>> lists) {
        return ConcatView.concatView(lists, true);
    }

    private static <E> List<E> concatView(List<List<? extends E>> lists, boolean makeUnmodifiable) {
        int len = lists.size();
        if (len < 1) {
            throw new AssertionError((Object)"Supposedly unreachable code");
        }
        if (len == 1) {
            List<? extends E> list = lists.get(0);
            if (makeUnmodifiable) {
                return Collections.unmodifiableList(list);
            }
            List<? extends E> lst = list;
            return lst;
        }
        int mid = len / 2;
        return new ConcatView<E>(ConcatView.concatView(lists.subList(0, mid), false), ConcatView.concatView(lists.subList(mid, len), false));
    }

    ConcatView(List<? extends E> first, List<? extends E> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public E get(int index) {
        if (index < this.first.size()) {
            return this.first.get(index);
        }
        return this.second.get(index - this.first.size());
    }

    @Override
    public int size() {
        return this.first.size() + this.second.size();
    }
}

