/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeartBeat
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(HeartBeat.class);
    private final String url;

    public HeartBeat(String url) {
        this.url = url;
    }

    private String toString(InputStream inputStream) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = inputStream.read()) != -1) {
            sb.append((char)ch);
        }
        inputStream.close();
        return sb.toString();
    }

    public void run() {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(this.url).openConnection();
            connection.connect();
            String result = this.toString(connection.getInputStream());
            if (result.length() > 0) {
                logger.debug("Client Heatbeat: {}", (Object)result);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

