/* splice.h was originally generated by the autoSql program, which also 
 * generated splice.c and splice.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef SPLICE_H
#define SPLICE_H

#ifndef BED_H
#include "bed.h"
#endif

#ifndef GENEGRAPH_H
#include "geneGraph.h"
#endif

#define PATH_NUM_COLS 10

struct path
/* List of vertices through a graph that forms a path of interest. */
    {
    struct path *next;  /* Next in singly linked list. */
    char *tName;	/* Target name (usually chromosome). */
    int tStart;	/* Target start (usually chromStart). */
    int tEnd;	/* Target end (usually chromEnd). */
    int type;	/* Used to classify path as major, minor or in between. */
    int maxVCount;	/* Size of vertices array. Used for memory management. */
    int vCount;	/* Number of vertices that make up path. */
    int *vertices;	/* Array of vertices that make up path. */
    int upV;	/* Closest upstream vertex connected to vertices[0]. */
    int downV;	/* Closest downstream vertex connected vertices[vCount-1]. */
    int bpCount;	/* Number of exonic base pairs in path. */
    };

struct path *pathCommaIn(char **pS, struct path *ret);
/* Create a path out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new path */

void pathFree(struct path **pEl);
/* Free a single dynamically allocated path such as created
 * with pathLoad(). */

void pathFreeList(struct path **pList);
/* Free a list of dynamically allocated path's */

void pathOutput(struct path *el, FILE *f, char sep, char lastSep);
/* Print out path.  Separate fields with sep. Follow last field with lastSep. */

#define pathTabOut(el,f) pathOutput(el,f,'\t','\n');
/* Print out path as a line in a tab-separated file. */

#define pathCommaOut(el,f) pathOutput(el,f,',',',');
/* Print out path as a comma separated list including final comma. */

#define SPLICE_NUM_COLS 12

struct splice
/* One alternative splicing event and the associated paths and sub-splicing events. */
    {
    struct splice *next;  /* Next in singly linked list. */
    char *tName;	/* Target name (usually chromosome). */
    int tStart;	/* Target start (usually chromStart). */
    int tEnd;	/* Target end (usually chromEnd). */
    char *name;	/* Unique name of splicing event. */
    int type;	/* Type of alternative splicing event. */
    char strand[3];	/* + or -. */
    int agxId;	/* Unique id of altGraphX graph associated to this splice. */
    int vCount;	/* Number of vertices in associated altGraphX graph. */
    int *vPositions;	/* Local copy of positions of vertices. */
    unsigned char *vTypes;	/* Type for each vertex. */
    int pathCount;	/* Number of paths. */
    struct path *paths;	/* All paths resulting from this splice. */
    };

struct splice *spliceLoad(char **row);
/* Load a splice from row fetched with select * from splice
 * from database.  Dispose of this with spliceFree(). */

struct splice *spliceLoadAll(char *fileName);
/* Load all splice from whitespace-separated file.
 * Dispose of this with spliceFreeList(). */

struct splice *spliceLoadAllByChar(char *fileName, char chopper);
/* Load all splice from chopper separated file.
 * Dispose of this with spliceFreeList(). */

#define spliceLoadAllByTab(a) spliceLoadAllByChar(a, '\t');
/* Load all splice from tab separated file.
 * Dispose of this with spliceFreeList(). */

struct splice *spliceCommaIn(char **pS, struct splice *ret);
/* Create a splice out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new splice */

void spliceFree(struct splice **pEl);
/* Free a single dynamically allocated splice such as created
 * with spliceLoad(). */

void spliceFreeList(struct splice **pList);
/* Free a list of dynamically allocated splice's */

void spliceOutput(struct splice *el, FILE *f, char sep, char lastSep);
/* Print out splice.  Separate fields with sep. Follow last field with lastSep. */

#define spliceTabOut(el,f) spliceOutput(el,f,'\t','\n');
/* Print out splice as a line in a tab-separated file. */

#define spliceCommaOut(el,f) spliceOutput(el,f,',',',');
/* Print out splice as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

enum ggEdgeType pathEdgeType(unsigned char *vTypes, int v1, int v2);
/* Return edge type. */

struct bed *pathToBed(struct path *path, struct splice *splice,
		      int source, int sink, boolean spoofEnds);
/* Construct a bed for the path. If spoofEnds is TRUE, ensure that
   there is at least a 1bp exon at splice sites. */

#endif /* SPLICE_H */

