/* kgXref.h was originally generated by the autoSql program, which also 
 * generated kgXref.c and kgXref.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef KGXREF_H
#define KGXREF_H

#define KGXREF_NUM_COLS 10

struct kgXref
/* Link together a Known Gene ID and a gene alias */
    {
    struct kgXref *next;  /* Next in singly linked list. */
    char *kgID;	/* Known Gene ID */
    char *mRNA;	/* mRNA ID */
    char *spID;	/* SWISS-PROT protein Accession number */
    char *spDisplayID;	/* SWISS-PROT display ID */
    char *geneSymbol;	/* Gene Symbol */
    char *refseq;	/* RefSeq ID */
    char *protAcc;	/* NCBI protein Accession number */
    char *description;	/* Description */
    char *rfamAcc;	/* Rfam accession number */
    char *tRnaName;	/* Name from the tRNA track */
    };

void kgXrefStaticLoad(char **row, struct kgXref *ret);
/* Load a row from kgXref table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct kgXref *kgXrefLoad(char **row);
/* Load a kgXref from row fetched with select * from kgXref
 * from database.  Dispose of this with kgXrefFree(). */

struct kgXref *kgXrefLoadAll(char *fileName);
/* Load all kgXref from whitespace-separated file.
 * Dispose of this with kgXrefFreeList(). */

struct kgXref *kgXrefLoadAllByChar(char *fileName, char chopper);
/* Load all kgXref from chopper separated file.
 * Dispose of this with kgXrefFreeList(). */

#define kgXrefLoadAllByTab(a) kgXrefLoadAllByChar(a, '\t');
/* Load all kgXref from tab separated file.
 * Dispose of this with kgXrefFreeList(). */

struct kgXref *kgXrefCommaIn(char **pS, struct kgXref *ret);
/* Create a kgXref out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new kgXref */

void kgXrefFree(struct kgXref **pEl);
/* Free a single dynamically allocated kgXref such as created
 * with kgXrefLoad(). */

void kgXrefFreeList(struct kgXref **pList);
/* Free a list of dynamically allocated kgXref's */

void kgXrefOutput(struct kgXref *el, FILE *f, char sep, char lastSep);
/* Print out kgXref.  Separate fields with sep. Follow last field with lastSep. */

#define kgXrefTabOut(el,f) kgXrefOutput(el,f,'\t','\n');
/* Print out kgXref as a line in a tab-separated file. */

#define kgXrefCommaOut(el,f) kgXrefOutput(el,f,',',',');
/* Print out kgXref as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* KGXREF_H */

