/* pslWQueryID.h was originally generated by the autoSql program, which also 
 * generated pslWQueryID.c and pslWQueryID.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef PSLWQUERYID_H
#define PSLWQUERYID_H

#define PSLWQUERYID_NUM_COLS 22

struct pslWQueryID
/* Summary info about a patSpace alignment with a query ID addition */
    {
    struct pslWQueryID *next;  /* Next in singly linked list. */
    unsigned matches;	/* Number of bases that match that aren't repeats */
    unsigned misMatches;	/* Number of bases that don't match */
    unsigned repMatches;	/* Number of bases that match but are part of repeats */
    unsigned nCount;	/* Number of 'N' bases */
    unsigned qNumInsert;	/* Number of inserts in query */
    unsigned qBaseInsert;	/* Number of bases inserted in query */
    unsigned tNumInsert;	/* Number of inserts in target */
    unsigned tBaseInsert;	/* Number of bases inserted in target */
    char strand[3];	/* + or - for query strand. For mouse second +/- for genomic strand */
    char *qName;	/* Query sequence name */
    unsigned qSize;	/* Query sequence size */
    unsigned qStart;	/* Alignment start position in query */
    unsigned qEnd;	/* Alignment end position in query */
    char *tName;	/* Target sequence name */
    unsigned tSize;	/* Target sequence size */
    unsigned tStart;	/* Alignment start position in target */
    unsigned tEnd;	/* Alignment end position in target */
    unsigned blockCount;	/* Number of blocks in alignment */
    unsigned *blockSizes;	/* Size of each block */
    unsigned *qStarts;	/* Start of each block in query. */
    unsigned *tStarts;	/* Start of each block in target. */
    char *queryID;	/* query ID field */
    };

struct pslWQueryID *pslWQueryIDLoad(char **row);
/* Load a pslWQueryID from row fetched with select * from pslWQueryID
 * from database.  Dispose of this with pslWQueryIDFree(). */

struct pslWQueryID *pslWQueryIDLoadAll(char *fileName);
/* Load all pslWQueryID from whitespace-separated file.
 * Dispose of this with pslWQueryIDFreeList(). */

struct pslWQueryID *pslWQueryIDLoadAllByChar(char *fileName, char chopper);
/* Load all pslWQueryID from chopper separated file.
 * Dispose of this with pslWQueryIDFreeList(). */

#define pslWQueryIDLoadAllByTab(a) pslWQueryIDLoadAllByChar(a, '\t');
/* Load all pslWQueryID from tab separated file.
 * Dispose of this with pslWQueryIDFreeList(). */

struct pslWQueryID *pslWQueryIDCommaIn(char **pS, struct pslWQueryID *ret);
/* Create a pslWQueryID out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new pslWQueryID */

void pslWQueryIDFree(struct pslWQueryID **pEl);
/* Free a single dynamically allocated pslWQueryID such as created
 * with pslWQueryIDLoad(). */

void pslWQueryIDFreeList(struct pslWQueryID **pList);
/* Free a list of dynamically allocated pslWQueryID's */

void pslWQueryIDOutput(struct pslWQueryID *el, FILE *f, char sep, char lastSep);
/* Print out pslWQueryID.  Separate fields with sep. Follow last field with lastSep. */

#define pslWQueryIDTabOut(el,f) pslWQueryIDOutput(el,f,'\t','\n');
/* Print out pslWQueryID as a line in a tab-separated file. */

#define pslWQueryIDCommaOut(el,f) pslWQueryIDOutput(el,f,',',',');
/* Print out pslWQueryID as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* PSLWQUERYID_H */

