/* putaInfo.h was originally generated by the autoSql program, which also 
 * generated putaInfo.c and putaInfo.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef PUTAINFO_H
#define PUTAINFO_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define PUTAINFO_NUM_COLS 17

struct putaInfo
/* store the general info for a putative real or pseudo gene */
    {
    struct putaInfo *next;  /* Next in singly linked list. */
    char *chrom;	/* stamp's chrom */
    unsigned chromStart;	/* stamp's chrom start */
    unsigned chromEnd;	/* stamp's chromEnd */
    char *name;	/* stamp's name */
    unsigned score;	/* aligned score */
    char *strand;	/* stamp's strand */
    char *oChrom;	/* stamper chrom */
    unsigned oChromStart;	/* stamper chrom start */
    unsigned oChromEnd;	/* stamper chrom end */
    unsigned blockCount;	/* total stamper blocks */
    unsigned stop;	/* 1 .. with stop; 0 .. without stop */
    unsigned tExons[2];	/* stamper (cds) exons */
    unsigned qExons[4];	/* stamp (mapped) (cds) exons */
    unsigned qBases[4];	/* stamp (aligend) (cds) bases */
    unsigned repeats[2];	/* (cds) has repeat inserted */
    unsigned *stops;	/* stops for each exon */
    double id[2];	/* (cds) aligned Identity */
    };

struct putaInfo *putaInfoLoad(char **row);
/* Load a putaInfo from row fetched with select * from putaInfo
 * from database.  Dispose of this with putaInfoFree(). */

struct putaInfo *putaInfoLoadAll(char *fileName);
/* Load all putaInfo from whitespace-separated file.
 * Dispose of this with putaInfoFreeList(). */

struct putaInfo *putaInfoLoadAllByChar(char *fileName, char chopper);
/* Load all putaInfo from chopper separated file.
 * Dispose of this with putaInfoFreeList(). */

#define putaInfoLoadAllByTab(a) putaInfoLoadAllByChar(a, '\t');
/* Load all putaInfo from tab separated file.
 * Dispose of this with putaInfoFreeList(). */

struct putaInfo *putaInfoLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all putaInfo from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with putaInfoFreeList(). */

void putaInfoSaveToDb(struct sqlConnection *conn, struct putaInfo *el, char *tableName, int updateSize);
/* Save putaInfo as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use putaInfoSaveToDbEscaped() */

void putaInfoSaveToDbEscaped(struct sqlConnection *conn, struct putaInfo *el, char *tableName, int updateSize);
/* Save putaInfo as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than putaInfoSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct putaInfo *putaInfoCommaIn(char **pS, struct putaInfo *ret);
/* Create a putaInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new putaInfo */

void putaInfoFree(struct putaInfo **pEl);
/* Free a single dynamically allocated putaInfo such as created
 * with putaInfoLoad(). */

void putaInfoFreeList(struct putaInfo **pList);
/* Free a list of dynamically allocated putaInfo's */

void putaInfoOutput(struct putaInfo *el, FILE *f, char sep, char lastSep);
/* Print out putaInfo.  Separate fields with sep. Follow last field with lastSep. */

#define putaInfoTabOut(el,f) putaInfoOutput(el,f,'\t','\n');
/* Print out putaInfo as a line in a tab-separated file. */

#define putaInfoCommaOut(el,f) putaInfoOutput(el,f,',',',');
/* Print out putaInfo as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* PUTAINFO_H */

