table txInfo
"Various bits of information about a transcript from the txGraph/txCds system (aka KG3)"
    (
    string name;	"Name of transcript"
    string category;	"coding/nearCoding/noncoding for now"
    string sourceAcc;	"Accession of genbank transcript patterned on (may be refSeq)"
    ubyte isRefSeq;	"Is a refSeq"
    int sourceSize;	"Number of bases in source, excluding poly-A tail."
    double aliCoverage;	"Fraction of bases in source aligning."
    double aliIdRatio;    "matching/total bases in alignment"
    int genoMapCount;	"Number of times source aligns in genome."
    int exonCount;	"Number of exons (excludes gaps from frame shift/stops)"
    int orfSize;	"Size of ORF"
    double cdsScore; "Score of best CDS according to txCdsPredict"
    ubyte startComplete;  "Starts with ATG"
    ubyte endComplete; "Ends with stop codon"
    ubyte nonsenseMediatedDecay; "If true, is a nonsense mediated decay candidate."
    ubyte retainedIntron;     "True if has a retained intron compared to overlapping transcripts"
    int bleedIntoIntron;     "If nonzero number of bases start or end of tx bleeds into intron"
    int strangeSplice;     "Count of splice sites not gt/ag, gc/ag, or at/ac"
    int atacIntrons;	   "Count of number of at/ac introns"
    ubyte cdsSingleInIntron;   "True if CDS is single exon and in intron of other transcript."
    ubyte cdsSingleInUtr3;     "True if CDS is single exon and in 3' UTR of other transcript."
    ubyte selenocysteine; "If true TGA codes for selenocysteine"
    ubyte genomicFrameShift; "True if genomic version has frame shift we cut out"
    ubyte genomicStop;    "True if genomic version has stop codon we cut out"
    )
