/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.Map;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.dataformat.ASN1DataFormat;
import org.apache.camel.model.dataformat.AvroDataFormat;
import org.apache.camel.model.dataformat.AvroLibrary;
import org.apache.camel.model.dataformat.Base64DataFormat;
import org.apache.camel.model.dataformat.BeanioDataFormat;
import org.apache.camel.model.dataformat.BindyDataFormat;
import org.apache.camel.model.dataformat.BindyType;
import org.apache.camel.model.dataformat.CBORDataFormat;
import org.apache.camel.model.dataformat.CsvDataFormat;
import org.apache.camel.model.dataformat.CustomDataFormat;
import org.apache.camel.model.dataformat.FhirJsonDataFormat;
import org.apache.camel.model.dataformat.FhirXmlDataFormat;
import org.apache.camel.model.dataformat.FuryDataFormat;
import org.apache.camel.model.dataformat.GrokDataFormat;
import org.apache.camel.model.dataformat.GzipDeflaterDataFormat;
import org.apache.camel.model.dataformat.HL7DataFormat;
import org.apache.camel.model.dataformat.IcalDataFormat;
import org.apache.camel.model.dataformat.JacksonXMLDataFormat;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.model.dataformat.JsonApiDataFormat;
import org.apache.camel.model.dataformat.JsonDataFormat;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.model.dataformat.LZFDataFormat;
import org.apache.camel.model.dataformat.MimeMultipartDataFormat;
import org.apache.camel.model.dataformat.PGPDataFormat;
import org.apache.camel.model.dataformat.ParquetAvroDataFormat;
import org.apache.camel.model.dataformat.ProtobufDataFormat;
import org.apache.camel.model.dataformat.ProtobufLibrary;
import org.apache.camel.model.dataformat.RssDataFormat;
import org.apache.camel.model.dataformat.SmooksDataFormat;
import org.apache.camel.model.dataformat.SoapDataFormat;
import org.apache.camel.model.dataformat.SwiftMtDataFormat;
import org.apache.camel.model.dataformat.SwiftMxDataFormat;
import org.apache.camel.model.dataformat.SyslogDataFormat;
import org.apache.camel.model.dataformat.TarFileDataFormat;
import org.apache.camel.model.dataformat.ThriftDataFormat;
import org.apache.camel.model.dataformat.TidyMarkupDataFormat;
import org.apache.camel.model.dataformat.XMLSecurityDataFormat;
import org.apache.camel.model.dataformat.YAMLDataFormat;
import org.apache.camel.model.dataformat.YAMLLibrary;
import org.apache.camel.model.dataformat.ZipDeflaterDataFormat;
import org.apache.camel.model.dataformat.ZipFileDataFormat;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.w3c.dom.Node;

public class DataFormatClause<T extends ProcessorDefinition<?>> {
    private final T processorType;
    private final Operation operation;
    private String variableSend;
    private String variableReceive;
    private boolean allowNullBody;

    public DataFormatClause(T processorType, Operation operation) {
        this.processorType = processorType;
        this.operation = operation;
    }

    public T avro() {
        return this.dataFormat(new AvroDataFormat());
    }

    public T avro(AvroLibrary library, Object schema) {
        AvroDataFormat dataFormat = new AvroDataFormat();
        dataFormat.setLibrary(library);
        dataFormat.setSchema(schema);
        return this.dataFormat(dataFormat);
    }

    public T avro(String unmarshalTypeName) {
        return this.dataFormat(new AvroDataFormat(unmarshalTypeName));
    }

    public T avro(AvroLibrary library, String unmarshalTypeName) {
        AvroDataFormat df = new AvroDataFormat(unmarshalTypeName);
        df.setLibrary(library);
        return this.dataFormat(df);
    }

    public T avro(AvroLibrary library) {
        return this.dataFormat(new AvroDataFormat(library));
    }

    public T avro(Class<?> unmarshalType) {
        AvroDataFormat avroDataFormat = new AvroDataFormat();
        avroDataFormat.setUnmarshalType(unmarshalType);
        return this.dataFormat(avroDataFormat);
    }

    public T avro(AvroLibrary library, Class<?> unmarshalType) {
        AvroDataFormat avroDataFormat = new AvroDataFormat();
        avroDataFormat.setLibrary(library);
        avroDataFormat.setUnmarshalType(unmarshalType);
        return this.dataFormat(avroDataFormat);
    }

    public T avro(Class<?> unmarshalType, String schemaResolver) {
        AvroDataFormat avroDataFormat = new AvroDataFormat();
        avroDataFormat.setUnmarshalType(unmarshalType);
        avroDataFormat.setSchemaResolver(schemaResolver);
        return this.dataFormat(avroDataFormat);
    }

    public T avro(AvroLibrary library, Class<?> unmarshalType, String schemaResolver) {
        AvroDataFormat avroDataFormat = new AvroDataFormat();
        avroDataFormat.setLibrary(library);
        avroDataFormat.setUnmarshalType(unmarshalType);
        avroDataFormat.setSchemaResolver(schemaResolver);
        return this.dataFormat(avroDataFormat);
    }

    public T base64() {
        Base64DataFormat dataFormat = new Base64DataFormat();
        return this.dataFormat(dataFormat);
    }

    public T base64(int lineLength, String lineSeparator, boolean urlSafe) {
        Base64DataFormat dataFormat = new Base64DataFormat();
        dataFormat.setLineLength(Integer.toString(lineLength));
        dataFormat.setLineSeparator(lineSeparator);
        dataFormat.setUrlSafe(Boolean.toString(urlSafe));
        return this.dataFormat(dataFormat);
    }

    public T beanio(String mapping, String streamName) {
        BeanioDataFormat dataFormat = new BeanioDataFormat();
        dataFormat.setMapping(mapping);
        dataFormat.setStreamName(streamName);
        return this.dataFormat(dataFormat);
    }

    public T beanio(String mapping, String streamName, String encoding) {
        BeanioDataFormat dataFormat = new BeanioDataFormat();
        dataFormat.setMapping(mapping);
        dataFormat.setStreamName(streamName);
        dataFormat.setEncoding(encoding);
        return this.dataFormat(dataFormat);
    }

    public T beanio(String mapping, String streamName, String encoding, boolean ignoreUnidentifiedRecords, boolean ignoreUnexpectedRecords, boolean ignoreInvalidRecords) {
        BeanioDataFormat dataFormat = new BeanioDataFormat();
        dataFormat.setMapping(mapping);
        dataFormat.setStreamName(streamName);
        dataFormat.setEncoding(encoding);
        dataFormat.setIgnoreUnidentifiedRecords(Boolean.toString(ignoreUnidentifiedRecords));
        dataFormat.setIgnoreUnexpectedRecords(Boolean.toString(ignoreUnexpectedRecords));
        dataFormat.setIgnoreInvalidRecords(Boolean.toString(ignoreInvalidRecords));
        return this.dataFormat(dataFormat);
    }

    public T beanio(String mapping, String streamName, String encoding, String beanReaderErrorHandlerType) {
        BeanioDataFormat dataFormat = new BeanioDataFormat();
        dataFormat.setMapping(mapping);
        dataFormat.setStreamName(streamName);
        dataFormat.setEncoding(encoding);
        dataFormat.setBeanReaderErrorHandlerType(beanReaderErrorHandlerType);
        return this.dataFormat(dataFormat);
    }

    public T bindy(BindyType type, Class<?> classType) {
        BindyDataFormat bindy = new BindyDataFormat();
        bindy.setType(type.name());
        bindy.setClassType(classType);
        return this.dataFormat(bindy);
    }

    public T bindy(BindyType type, Class<?> classType, boolean unwrapSingleInstance) {
        BindyDataFormat bindy = new BindyDataFormat();
        bindy.setType(type.name());
        bindy.setClassType(classType);
        bindy.setUnwrapSingleInstance(Boolean.toString(unwrapSingleInstance));
        return this.dataFormat(bindy);
    }

    public T cbor() {
        return this.dataFormat(new CBORDataFormat());
    }

    public T cbor(Class<?> unmarshalType) {
        CBORDataFormat cborDataFormat = new CBORDataFormat();
        cborDataFormat.setUnmarshalType(unmarshalType);
        return this.dataFormat(cborDataFormat);
    }

    public T csv() {
        return this.dataFormat(new CsvDataFormat());
    }

    public T csvLazyLoad() {
        return this.dataFormat(new CsvDataFormat(true));
    }

    public T custom(String ref) {
        return this.dataFormat(new CustomDataFormat(ref));
    }

    public T fury() {
        return this.dataFormat(new FuryDataFormat());
    }

    public T fury(Class type) {
        FuryDataFormat format = new FuryDataFormat();
        format.setUnmarshalType(type);
        return this.dataFormat(format);
    }

    public T grok(String pattern) {
        GrokDataFormat grokDataFormat = new GrokDataFormat();
        grokDataFormat.setPattern(pattern);
        return this.dataFormat(grokDataFormat);
    }

    public T gzipDeflater() {
        GzipDeflaterDataFormat gzdf = new GzipDeflaterDataFormat();
        return this.dataFormat(gzdf);
    }

    public T hl7() {
        return this.dataFormat(new HL7DataFormat());
    }

    public T hl7(boolean validate) {
        HL7DataFormat hl7 = new HL7DataFormat();
        hl7.setValidate(Boolean.toString(validate));
        return this.dataFormat(hl7);
    }

    public T hl7(Object parser) {
        HL7DataFormat hl7 = new HL7DataFormat();
        hl7.setParser(parser);
        return this.dataFormat(hl7);
    }

    public T ical(boolean validating) {
        IcalDataFormat ical = new IcalDataFormat();
        ical.setValidating(Boolean.toString(validating));
        return this.dataFormat(ical);
    }

    public T lzf() {
        LZFDataFormat lzfdf = new LZFDataFormat();
        return this.dataFormat(lzfdf);
    }

    public T mimeMultipart() {
        MimeMultipartDataFormat mm = new MimeMultipartDataFormat();
        return this.dataFormat(mm);
    }

    public T mimeMultipart(String multipartSubType) {
        MimeMultipartDataFormat mm = new MimeMultipartDataFormat();
        mm.setMultipartSubType(multipartSubType);
        return this.dataFormat(mm);
    }

    public T mimeMultipart(String multipartSubType, boolean multipartWithoutAttachment, boolean headersInline, boolean binaryContent) {
        MimeMultipartDataFormat mm = new MimeMultipartDataFormat();
        mm.setMultipartSubType(multipartSubType);
        mm.setMultipartWithoutAttachment(Boolean.toString(multipartWithoutAttachment));
        mm.setHeadersInline(Boolean.toString(headersInline));
        mm.setBinaryContent(Boolean.toString(binaryContent));
        return this.dataFormat(mm);
    }

    public T mimeMultipart(String multipartSubType, boolean multipartWithoutAttachment, boolean headersInline, String includeHeaders, boolean binaryContent) {
        MimeMultipartDataFormat mm = new MimeMultipartDataFormat();
        mm.setMultipartSubType(multipartSubType);
        mm.setMultipartWithoutAttachment(Boolean.toString(multipartWithoutAttachment));
        mm.setHeadersInline(Boolean.toString(headersInline));
        mm.setIncludeHeaders(includeHeaders);
        mm.setBinaryContent(Boolean.toString(binaryContent));
        return this.dataFormat(mm);
    }

    public T mimeMultipart(boolean multipartWithoutAttachment, boolean headersInline, boolean binaryContent) {
        MimeMultipartDataFormat mm = new MimeMultipartDataFormat();
        mm.setMultipartWithoutAttachment(Boolean.toString(multipartWithoutAttachment));
        mm.setHeadersInline(Boolean.toString(headersInline));
        mm.setBinaryContent(Boolean.toString(binaryContent));
        return this.dataFormat(mm);
    }

    public T pgp(String keyFileName, String keyUserid) {
        PGPDataFormat pgp = new PGPDataFormat();
        pgp.setKeyFileName(keyFileName);
        pgp.setKeyUserid(keyUserid);
        return this.dataFormat(pgp);
    }

    public T pgp(String keyFileName, String keyUserid, String password) {
        PGPDataFormat pgp = new PGPDataFormat();
        pgp.setKeyFileName(keyFileName);
        pgp.setKeyUserid(keyUserid);
        pgp.setPassword(password);
        return this.dataFormat(pgp);
    }

    public T pgp(String keyFileName, String keyUserid, String password, boolean armored, boolean integrity) {
        PGPDataFormat pgp = new PGPDataFormat();
        pgp.setKeyFileName(keyFileName);
        pgp.setKeyUserid(keyUserid);
        pgp.setPassword(password);
        pgp.setArmored(Boolean.toString(armored));
        pgp.setIntegrity(Boolean.toString(integrity));
        return this.dataFormat(pgp);
    }

    public T jacksonXml() {
        return this.dataFormat(new JacksonXMLDataFormat());
    }

    public T jacksonXml(Class<?> unmarshalType) {
        JacksonXMLDataFormat jacksonXMLDataFormat = new JacksonXMLDataFormat();
        jacksonXMLDataFormat.setUnmarshalType(unmarshalType);
        return this.dataFormat(jacksonXMLDataFormat);
    }

    public T jacksonXml(Class<?> unmarshalType, Class<?> jsonView) {
        JacksonXMLDataFormat jacksonXMLDataFormat = new JacksonXMLDataFormat();
        jacksonXMLDataFormat.setUnmarshalType(unmarshalType);
        jacksonXMLDataFormat.setJsonView(jsonView);
        return this.dataFormat(jacksonXMLDataFormat);
    }

    public T jacksonXml(boolean prettyPrint) {
        JacksonXMLDataFormat jacksonXMLDataFormat = new JacksonXMLDataFormat();
        jacksonXMLDataFormat.setPrettyPrint(Boolean.toString(prettyPrint));
        return this.dataFormat(jacksonXMLDataFormat);
    }

    public T jacksonXml(Class<?> unmarshalType, boolean prettyPrint) {
        JacksonXMLDataFormat jacksonXMLDataFormat = new JacksonXMLDataFormat();
        jacksonXMLDataFormat.setUnmarshalType(unmarshalType);
        jacksonXMLDataFormat.setPrettyPrint(Boolean.toString(prettyPrint));
        return this.dataFormat(jacksonXMLDataFormat);
    }

    public T jacksonXml(Class<?> unmarshalType, Class<?> jsonView, boolean prettyPrint) {
        JacksonXMLDataFormat jacksonXMLDataFormat = new JacksonXMLDataFormat();
        jacksonXMLDataFormat.setUnmarshalType(unmarshalType);
        jacksonXMLDataFormat.setJsonView(jsonView);
        jacksonXMLDataFormat.setPrettyPrint(Boolean.toString(prettyPrint));
        return this.dataFormat(jacksonXMLDataFormat);
    }

    public T jacksonXml(Class<?> unmarshalType, Class<?> jsonView, String include) {
        JacksonXMLDataFormat jacksonXMLDataFormat = new JacksonXMLDataFormat();
        jacksonXMLDataFormat.setUnmarshalType(unmarshalType);
        jacksonXMLDataFormat.setJsonView(jsonView);
        jacksonXMLDataFormat.setInclude(include);
        return this.dataFormat(jacksonXMLDataFormat);
    }

    public T jacksonXml(Class<?> unmarshalType, Class<?> jsonView, String include, boolean prettyPrint) {
        JacksonXMLDataFormat jacksonXMLDataFormat = new JacksonXMLDataFormat();
        jacksonXMLDataFormat.setUnmarshalType(unmarshalType);
        jacksonXMLDataFormat.setJsonView(jsonView);
        jacksonXMLDataFormat.setInclude(include);
        jacksonXMLDataFormat.setPrettyPrint(Boolean.toString(prettyPrint));
        return this.dataFormat(jacksonXMLDataFormat);
    }

    public T jaxb() {
        return this.dataFormat(new JaxbDataFormat());
    }

    public T jaxb(String contextPath) {
        JaxbDataFormat dataFormat = new JaxbDataFormat();
        dataFormat.setContextPath(contextPath);
        return this.dataFormat(dataFormat);
    }

    public T jaxb(boolean prettyPrint) {
        return this.dataFormat(new JaxbDataFormat(prettyPrint));
    }

    public T json() {
        return this.dataFormat(new JsonDataFormat());
    }

    public T json(boolean prettyPrint) {
        JsonDataFormat json = new JsonDataFormat();
        json.setPrettyPrint(Boolean.toString(prettyPrint));
        return this.dataFormat(json);
    }

    public T json(JsonLibrary library) {
        return this.dataFormat(new JsonDataFormat(library));
    }

    public T json(JsonLibrary library, boolean prettyPrint) {
        JsonDataFormat json = new JsonDataFormat(library);
        json.setPrettyPrint(Boolean.toString(prettyPrint));
        return this.dataFormat(json);
    }

    public T json(JsonLibrary type, Class<?> unmarshalType) {
        JsonDataFormat json = new JsonDataFormat(type);
        json.setUnmarshalType(unmarshalType);
        return this.dataFormat(json);
    }

    public T json(JsonLibrary type, Class<?> unmarshalType, boolean prettyPrint) {
        JsonDataFormat json = new JsonDataFormat(type);
        json.setUnmarshalType(unmarshalType);
        json.setPrettyPrint(Boolean.toString(prettyPrint));
        return this.dataFormat(json);
    }

    public T json(Class<?> unmarshalType) {
        JsonDataFormat json = new JsonDataFormat(JsonLibrary.Jackson);
        json.setUnmarshalType(unmarshalType);
        return this.dataFormat(json);
    }

    public T json(Class<?> unmarshalType, Class<?> jsonView) {
        JsonDataFormat json = new JsonDataFormat(JsonLibrary.Jackson);
        json.setUnmarshalType(unmarshalType);
        json.setJsonView(jsonView);
        return this.dataFormat(json);
    }

    public T json(Class<?> unmarshalType, Class<?> jsonView, boolean prettyPrint) {
        JsonDataFormat json = new JsonDataFormat(JsonLibrary.Jackson);
        json.setUnmarshalType(unmarshalType);
        json.setJsonView(jsonView);
        json.setPrettyPrint(Boolean.toString(prettyPrint));
        return this.dataFormat(json);
    }

    public T json(Class<?> unmarshalType, Class<?> jsonView, String include) {
        JsonDataFormat json = new JsonDataFormat(JsonLibrary.Jackson);
        json.setUnmarshalType(unmarshalType);
        json.setJsonView(jsonView);
        json.setInclude(include);
        return this.dataFormat(json);
    }

    public T json(Class<?> unmarshalType, Class<?> jsonView, String include, boolean prettyPrint) {
        JsonDataFormat json = new JsonDataFormat(JsonLibrary.Jackson);
        json.setUnmarshalType(unmarshalType);
        json.setJsonView(jsonView);
        json.setInclude(include);
        json.setPrettyPrint(Boolean.toString(prettyPrint));
        return this.dataFormat(json);
    }

    public T jsonApi() {
        return this.dataFormat(new JsonApiDataFormat());
    }

    public T protobuf() {
        return this.dataFormat(new ProtobufDataFormat());
    }

    public T protobuf(Object defaultInstance) {
        ProtobufDataFormat dataFormat = new ProtobufDataFormat();
        dataFormat.setDefaultInstance(defaultInstance);
        return this.dataFormat(dataFormat);
    }

    public T protobuf(Object defaultInstance, String contentTypeFormat) {
        ProtobufDataFormat dataFormat = new ProtobufDataFormat();
        dataFormat.setDefaultInstance(defaultInstance);
        dataFormat.setContentTypeFormat(contentTypeFormat);
        return this.dataFormat(dataFormat);
    }

    public T protobuf(String instanceClassName) {
        return this.dataFormat(new ProtobufDataFormat(instanceClassName));
    }

    public T protobuf(String instanceClassName, String contentTypeFormat) {
        return this.dataFormat(new ProtobufDataFormat(instanceClassName, contentTypeFormat));
    }

    public T protobuf(ProtobufLibrary library) {
        return this.dataFormat(new ProtobufDataFormat(library));
    }

    public T protobuf(ProtobufLibrary library, Class<?> unmarshalType) {
        ProtobufDataFormat protobufDataFormat = new ProtobufDataFormat();
        protobufDataFormat.setLibrary(library);
        protobufDataFormat.setUnmarshalType(unmarshalType);
        return this.dataFormat(protobufDataFormat);
    }

    public T protobuf(ProtobufLibrary library, Class<?> unmarshalType, String schemaResolver) {
        ProtobufDataFormat protobufDataFormat = new ProtobufDataFormat();
        protobufDataFormat.setLibrary(library);
        protobufDataFormat.setUnmarshalType(unmarshalType);
        protobufDataFormat.setSchemaResolver(schemaResolver);
        return this.dataFormat(protobufDataFormat);
    }

    public T rss() {
        return this.dataFormat(new RssDataFormat());
    }

    public T smooks(String smooksConfig) {
        SmooksDataFormat smooksDataFormat = new SmooksDataFormat();
        smooksDataFormat.setSmooksConfig(smooksConfig);
        return this.dataFormat(smooksDataFormat);
    }

    public T soap() {
        return this.dataFormat(new SoapDataFormat());
    }

    public T soap(String contextPath) {
        return this.dataFormat(new SoapDataFormat(contextPath));
    }

    public T soap(String contextPath, String elementNameStrategyRef) {
        return this.dataFormat(new SoapDataFormat(contextPath, elementNameStrategyRef));
    }

    public T soap(String contextPath, Object elementNameStrategy) {
        return this.dataFormat(new SoapDataFormat(contextPath, elementNameStrategy));
    }

    public T soap12() {
        SoapDataFormat soap = new SoapDataFormat();
        soap.setVersion("1.2");
        return this.dataFormat(soap);
    }

    public T soap12(String contextPath) {
        SoapDataFormat soap = new SoapDataFormat(contextPath);
        soap.setVersion("1.2");
        return this.dataFormat(soap);
    }

    public T soap12(String contextPath, String elementNameStrategyRef) {
        SoapDataFormat soap = new SoapDataFormat(contextPath, elementNameStrategyRef);
        soap.setVersion("1.2");
        return this.dataFormat(soap);
    }

    public T soap12(String contextPath, Object elementNameStrategy) {
        SoapDataFormat soap = new SoapDataFormat(contextPath, elementNameStrategy);
        soap.setVersion("1.2");
        return this.dataFormat(soap);
    }

    public T swiftMx() {
        return this.dataFormat(new SwiftMxDataFormat());
    }

    public T swiftMx(boolean writeInJson) {
        return this.dataFormat(new SwiftMxDataFormat(writeInJson));
    }

    public T swiftMx(boolean writeInJson, String readMessageId, Object readConfig) {
        return this.dataFormat(new SwiftMxDataFormat(writeInJson, readMessageId, readConfig));
    }

    public T swiftMx(boolean writeInJson, String readMessageId, String readConfigRef) {
        return this.dataFormat(new SwiftMxDataFormat(writeInJson, readMessageId, readConfigRef));
    }

    public T swiftMx(Object writeConfig, String readMessageId, Object readConfig) {
        return this.dataFormat(new SwiftMxDataFormat(writeConfig, readMessageId, readConfig));
    }

    public T swiftMx(String writeConfigRef, String readMessageId, String readConfigRef) {
        return this.dataFormat(new SwiftMxDataFormat(writeConfigRef, readMessageId, readConfigRef));
    }

    public T swiftMt() {
        return this.dataFormat(new SwiftMtDataFormat());
    }

    public T swiftMt(boolean writeInJson) {
        return this.dataFormat(new SwiftMtDataFormat(Boolean.toString(writeInJson)));
    }

    public T syslog() {
        return this.dataFormat(new SyslogDataFormat());
    }

    public T thrift() {
        return this.dataFormat(new ThriftDataFormat());
    }

    public T thrift(Object defaultInstance) {
        ThriftDataFormat dataFormat = new ThriftDataFormat();
        dataFormat.setDefaultInstance(defaultInstance);
        return this.dataFormat(dataFormat);
    }

    public T thrift(Object defaultInstance, String contentTypeFormat) {
        ThriftDataFormat dataFormat = new ThriftDataFormat();
        dataFormat.setDefaultInstance(defaultInstance);
        dataFormat.setContentTypeFormat(contentTypeFormat);
        return this.dataFormat(dataFormat);
    }

    public T thrift(String instanceClassName) {
        return this.dataFormat(new ThriftDataFormat(instanceClassName));
    }

    public T thrift(String instanceClassName, String contentTypeFormat) {
        return this.dataFormat(new ThriftDataFormat(instanceClassName, contentTypeFormat));
    }

    public T tidyMarkup(Class<?> dataObjectType) {
        return this.dataFormat(new TidyMarkupDataFormat(dataObjectType));
    }

    public T tidyMarkup() {
        return this.dataFormat(new TidyMarkupDataFormat(Node.class));
    }

    public T yaml(YAMLLibrary library) {
        return this.dataFormat(new YAMLDataFormat(library));
    }

    public T yaml(YAMLLibrary library, Class<?> type) {
        return this.dataFormat(new YAMLDataFormat(library, type));
    }

    public T xmlSecurity(byte[] passPhraseByte) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setPassPhraseByte(passPhraseByte);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, boolean secureTagContents, String passPhrase) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setPassPhrase(passPhrase);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String passPhrase) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setNamespaces(namespaces);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setPassPhrase(passPhrase);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, boolean secureTagContents, String passPhrase, String xmlCipherAlgorithm) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setPassPhrase(passPhrase);
        xsdf.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String passPhrase, String xmlCipherAlgorithm) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setNamespaces(namespaces);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setPassPhrase(passPhrase);
        xsdf.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, boolean secureTagContents, byte[] passPhraseByte) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setPassPhraseByte(passPhraseByte);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, Map<String, String> namespaces, boolean secureTagContents, byte[] passPhraseByte) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setNamespaces(namespaces);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setPassPhraseByte(passPhraseByte);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, boolean secureTagContents, byte[] passPhraseByte, String xmlCipherAlgorithm) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setPassPhraseByte(passPhraseByte);
        xsdf.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, Map<String, String> namespaces, boolean secureTagContents, byte[] passPhraseByte, String xmlCipherAlgorithm) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setNamespaces(namespaces);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setPassPhraseByte(passPhraseByte);
        xsdf.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setRecipientKeyAlias(recipientKeyAlias);
        xsdf.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        xsdf.setKeyCipherAlgorithm(keyCipherAlgorithm);
        xsdf.setKeyOrTrustStoreParametersRef(keyOrTrustStoreParametersId);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId, String keyPassword) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setRecipientKeyAlias(recipientKeyAlias);
        xsdf.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        xsdf.setKeyCipherAlgorithm(keyCipherAlgorithm);
        xsdf.setKeyOrTrustStoreParametersRef(keyOrTrustStoreParametersId);
        xsdf.setKeyPassword(keyPassword);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setRecipientKeyAlias(recipientKeyAlias);
        xsdf.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        xsdf.setKeyCipherAlgorithm(keyCipherAlgorithm);
        xsdf.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters, String keyPassword) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setRecipientKeyAlias(recipientKeyAlias);
        xsdf.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        xsdf.setKeyCipherAlgorithm(keyCipherAlgorithm);
        xsdf.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
        xsdf.setKeyPassword(keyPassword);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setRecipientKeyAlias(recipientKeyAlias);
        xsdf.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        xsdf.setKeyCipherAlgorithm(keyCipherAlgorithm);
        xsdf.setKeyOrTrustStoreParametersRef(keyOrTrustStoreParametersId);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, String keyOrTrustStoreParametersId, String keyPassword) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setRecipientKeyAlias(recipientKeyAlias);
        xsdf.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        xsdf.setKeyCipherAlgorithm(keyCipherAlgorithm);
        xsdf.setKeyOrTrustStoreParametersRef(keyOrTrustStoreParametersId);
        xsdf.setKeyPassword(keyPassword);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setNamespaces(namespaces);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setRecipientKeyAlias(recipientKeyAlias);
        xsdf.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        xsdf.setKeyCipherAlgorithm(keyCipherAlgorithm);
        xsdf.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters, String keyPassword) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setNamespaces(namespaces);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setRecipientKeyAlias(recipientKeyAlias);
        xsdf.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        xsdf.setKeyCipherAlgorithm(keyCipherAlgorithm);
        xsdf.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
        xsdf.setKeyPassword(keyPassword);
        return this.dataFormat(xsdf);
    }

    public T xmlSecurity(String secureTag, Map<String, String> namespaces, boolean secureTagContents, String recipientKeyAlias, String xmlCipherAlgorithm, String keyCipherAlgorithm, KeyStoreParameters keyOrTrustStoreParameters, String keyPassword, String digestAlgorithm) {
        XMLSecurityDataFormat xsdf = new XMLSecurityDataFormat();
        xsdf.setSecureTag(secureTag);
        xsdf.setNamespaces(namespaces);
        xsdf.setSecureTagContents(Boolean.toString(secureTagContents));
        xsdf.setRecipientKeyAlias(recipientKeyAlias);
        xsdf.setXmlCipherAlgorithm(xmlCipherAlgorithm);
        xsdf.setKeyCipherAlgorithm(keyCipherAlgorithm);
        xsdf.setKeyOrTrustStoreParameters(keyOrTrustStoreParameters);
        xsdf.setDigestAlgorithm(digestAlgorithm);
        xsdf.setKeyPassword(keyPassword);
        return this.dataFormat(xsdf);
    }

    public T tarFile() {
        TarFileDataFormat tfdf = new TarFileDataFormat();
        return this.dataFormat(tfdf);
    }

    public T zipDeflater() {
        ZipDeflaterDataFormat zdf = new ZipDeflaterDataFormat();
        return this.dataFormat(zdf);
    }

    public T zipDeflater(int compressionLevel) {
        ZipDeflaterDataFormat zdf = new ZipDeflaterDataFormat();
        zdf.setCompressionLevel(Integer.toString(compressionLevel));
        return this.dataFormat(zdf);
    }

    public T zipFile() {
        ZipFileDataFormat zfdf = new ZipFileDataFormat();
        return this.dataFormat(zfdf);
    }

    public T asn1() {
        ASN1DataFormat asn1Df = new ASN1DataFormat();
        return this.dataFormat(asn1Df);
    }

    public T asn1(String unmarshalType) {
        return this.dataFormat(new ASN1DataFormat(unmarshalType));
    }

    public T asn1(Class<?> unmarshalType) {
        return this.dataFormat(new ASN1DataFormat(unmarshalType));
    }

    public T asn1(Boolean usingIterator) {
        return this.dataFormat(new ASN1DataFormat(usingIterator));
    }

    public T parquetAvro() {
        ParquetAvroDataFormat parquetAvroDataFormat = new ParquetAvroDataFormat();
        return this.dataFormat(parquetAvroDataFormat);
    }

    public T parquetAvro(String unmarshalType) {
        return this.dataFormat(new ParquetAvroDataFormat(unmarshalType));
    }

    public T parquetAvro(Class<?> unmarshalType) {
        return this.dataFormat(new ParquetAvroDataFormat(unmarshalType));
    }

    public T fhirJson() {
        FhirJsonDataFormat jsonDataFormat = new FhirJsonDataFormat();
        return this.dataFormat(jsonDataFormat);
    }

    public T fhirJson(String version) {
        FhirJsonDataFormat jsonDataFormat = new FhirJsonDataFormat();
        jsonDataFormat.setFhirVersion(version);
        return this.dataFormat(jsonDataFormat);
    }

    public T fhirJson(boolean prettyPrint) {
        FhirJsonDataFormat jsonDataFormat = new FhirJsonDataFormat();
        jsonDataFormat.setPrettyPrint(Boolean.toString(prettyPrint));
        return this.dataFormat(jsonDataFormat);
    }

    public T fhirJson(String version, boolean prettyPrint) {
        FhirJsonDataFormat jsonDataFormat = new FhirJsonDataFormat();
        jsonDataFormat.setPrettyPrint(Boolean.toString(prettyPrint));
        jsonDataFormat.setFhirVersion(version);
        return this.dataFormat(jsonDataFormat);
    }

    public T fhirXml() {
        FhirXmlDataFormat fhirXmlDataFormat = new FhirXmlDataFormat();
        return this.dataFormat(fhirXmlDataFormat);
    }

    public T fhirXml(String version) {
        FhirXmlDataFormat fhirXmlDataFormat = new FhirXmlDataFormat();
        fhirXmlDataFormat.setFhirVersion(version);
        return this.dataFormat(fhirXmlDataFormat);
    }

    public T fhirXml(boolean prettyPrint) {
        FhirXmlDataFormat fhirXmlDataFormat = new FhirXmlDataFormat();
        fhirXmlDataFormat.setPrettyPrint(Boolean.toString(prettyPrint));
        return this.dataFormat(fhirXmlDataFormat);
    }

    public T fhirXml(String version, boolean prettyPrint) {
        FhirXmlDataFormat fhirXmlDataFormat = new FhirXmlDataFormat();
        fhirXmlDataFormat.setFhirVersion(version);
        fhirXmlDataFormat.setPrettyPrint(Boolean.toString(prettyPrint));
        return this.dataFormat(fhirXmlDataFormat);
    }

    public DataFormatClause<T> allowNullBody() {
        return this.allowNullBody(true);
    }

    public DataFormatClause<T> allowNullBody(boolean allowNullBody) {
        this.allowNullBody = allowNullBody;
        return this;
    }

    public DataFormatClause<T> variableSend(String variableSend) {
        this.variableSend = variableSend;
        return this;
    }

    public DataFormatClause<T> variableReceive(String variableReceive) {
        this.variableReceive = variableReceive;
        return this;
    }

    private T dataFormat(DataFormatDefinition dataFormatType) {
        switch (this.operation) {
            case Unmarshal: {
                UnmarshalDefinition unmarshal = new UnmarshalDefinition(dataFormatType);
                if (this.allowNullBody) {
                    unmarshal.allowNullBody(true);
                }
                unmarshal.setVariableReceive(this.variableReceive);
                unmarshal.setVariableSend(this.variableSend);
                ((ProcessorDefinition)this.processorType).addOutput(unmarshal);
                return this.processorType;
            }
            case Marshal: {
                MarshalDefinition marshal = new MarshalDefinition(dataFormatType);
                marshal.setVariableReceive(this.variableReceive);
                marshal.setVariableSend(this.variableSend);
                ((ProcessorDefinition)this.processorType).addOutput(marshal);
                return this.processorType;
            }
        }
        throw new IllegalArgumentException("Unknown DataFormat operation: " + String.valueOf((Object)this.operation));
    }

    public static enum Operation {
        Marshal,
        Unmarshal;

    }
}

