/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ExceptionDepthComparator;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentLruCache;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.method.annotation.ExceptionHandlerMappingInfo;

public class ExceptionHandlerMethodResolver {
    private static final ReflectionUtils.MethodFilter EXCEPTION_HANDLER_METHODS = method -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, ExceptionHandler.class);
    private static final ExceptionHandlerMappingInfo NO_MATCHING_EXCEPTION_HANDLER;
    private final Map<ExceptionMapping, ExceptionHandlerMappingInfo> mappedMethods = new HashMap<ExceptionMapping, ExceptionHandlerMappingInfo>(16);
    private final ConcurrentLruCache<ExceptionMapping, ExceptionHandlerMappingInfo> lookupCache = new ConcurrentLruCache(24, cacheKey -> this.getMappedMethod(cacheKey.exceptionType(), cacheKey.mediaType()));

    public ExceptionHandlerMethodResolver(Class<?> handlerType) {
        for (Method method : MethodIntrospector.selectMethods(handlerType, (ReflectionUtils.MethodFilter)EXCEPTION_HANDLER_METHODS)) {
            ExceptionHandlerMappingInfo mappingInfo = this.detectExceptionMappings(method);
            for (Class<? extends Throwable> exceptionType : mappingInfo.getExceptionTypes()) {
                for (MediaType producibleType : mappingInfo.getProducibleTypes()) {
                    this.addExceptionMapping(new ExceptionMapping(exceptionType, producibleType), mappingInfo);
                }
                if (!mappingInfo.getProducibleTypes().isEmpty()) continue;
                this.addExceptionMapping(new ExceptionMapping(exceptionType, MediaType.ALL), mappingInfo);
            }
        }
    }

    private ExceptionHandlerMappingInfo detectExceptionMappings(Method method) {
        ExceptionHandler exceptionHandler = this.readExceptionHandlerAnnotation(method);
        ArrayList<Class<? extends Throwable>> exceptions = new ArrayList<Class<? extends Throwable>>(Arrays.asList(exceptionHandler.exception()));
        if (exceptions.isEmpty()) {
            for (Class<?> paramType : method.getParameterTypes()) {
                if (!Throwable.class.isAssignableFrom(paramType)) continue;
                exceptions.add(paramType);
            }
        }
        if (exceptions.isEmpty()) {
            throw new IllegalStateException("No exception types mapped to " + String.valueOf(method));
        }
        LinkedHashSet<MediaType> mediaTypes = new LinkedHashSet<MediaType>();
        for (String mediaType : exceptionHandler.produces()) {
            try {
                mediaTypes.add(MediaType.parseMediaType(mediaType));
            }
            catch (InvalidMediaTypeException exc) {
                throw new IllegalStateException("Invalid media type [" + mediaType + "] declared on @ExceptionHandler for " + String.valueOf(method), exc);
            }
        }
        return new ExceptionHandlerMappingInfo(Set.copyOf(exceptions), mediaTypes, method);
    }

    private ExceptionHandler readExceptionHandlerAnnotation(Method method) {
        ExceptionHandler ann = (ExceptionHandler)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ExceptionHandler.class);
        Assert.state((ann != null ? 1 : 0) != 0, (String)"No ExceptionHandler annotation");
        return ann;
    }

    private void addExceptionMapping(ExceptionMapping mapping, ExceptionHandlerMappingInfo mappingInfo) {
        ExceptionHandlerMappingInfo oldMapping = this.mappedMethods.put(mapping, mappingInfo);
        if (oldMapping != null && !oldMapping.getHandlerMethod().equals(mappingInfo.getHandlerMethod())) {
            throw new IllegalStateException("Ambiguous @ExceptionHandler method mapped for [" + String.valueOf(mapping) + "]: {" + String.valueOf(oldMapping.getHandlerMethod()) + ", " + String.valueOf(mappingInfo.getHandlerMethod()) + "}");
        }
    }

    public boolean hasExceptionMappings() {
        return !this.mappedMethods.isEmpty();
    }

    @Nullable
    public Method resolveMethod(Exception exception) {
        ExceptionHandlerMappingInfo mappingInfo = this.resolveExceptionMapping(exception, MediaType.ALL);
        return mappingInfo != null ? mappingInfo.getHandlerMethod() : null;
    }

    @Nullable
    public Method resolveMethodByThrowable(Throwable exception) {
        ExceptionHandlerMappingInfo mappingInfo = this.resolveExceptionMapping(exception, MediaType.ALL);
        return mappingInfo != null ? mappingInfo.getHandlerMethod() : null;
    }

    @Nullable
    public ExceptionHandlerMappingInfo resolveExceptionMapping(Throwable exception, MediaType mediaType) {
        Throwable cause;
        ExceptionHandlerMappingInfo mappingInfo = this.resolveExceptionMappingByExceptionType(exception.getClass(), mediaType);
        if (mappingInfo == null && (cause = exception.getCause()) != null) {
            mappingInfo = this.resolveExceptionMapping(cause, mediaType);
        }
        return mappingInfo;
    }

    @Nullable
    public Method resolveMethodByExceptionType(Class<? extends Throwable> exceptionType) {
        ExceptionHandlerMappingInfo mappingInfo = this.resolveExceptionMappingByExceptionType(exceptionType, MediaType.ALL);
        return mappingInfo != null ? mappingInfo.getHandlerMethod() : null;
    }

    @Nullable
    public ExceptionHandlerMappingInfo resolveExceptionMappingByExceptionType(Class<? extends Throwable> exceptionType, MediaType mediaType) {
        ExceptionHandlerMappingInfo mappingInfo = (ExceptionHandlerMappingInfo)this.lookupCache.get((Object)new ExceptionMapping(exceptionType, mediaType));
        return mappingInfo != NO_MATCHING_EXCEPTION_HANDLER ? mappingInfo : null;
    }

    @Nullable
    private ExceptionHandlerMappingInfo getMappedMethod(Class<? extends Throwable> exceptionType, MediaType mediaType) {
        ArrayList<ExceptionMapping> matches = new ArrayList<ExceptionMapping>();
        for (ExceptionMapping mappingInfo : this.mappedMethods.keySet()) {
            if (!mappingInfo.exceptionType().isAssignableFrom(exceptionType) || !mappingInfo.mediaType().isCompatibleWith(mediaType)) continue;
            matches.add(mappingInfo);
        }
        if (!matches.isEmpty()) {
            if (matches.size() > 1) {
                matches.sort(new ExceptionMapingComparator(exceptionType, mediaType));
            }
            return this.mappedMethods.get(matches.get(0));
        }
        return NO_MATCHING_EXCEPTION_HANDLER;
    }

    private void noMatchingExceptionHandler() {
    }

    static {
        try {
            NO_MATCHING_EXCEPTION_HANDLER = new ExceptionHandlerMappingInfo(Set.of(), Set.of(), ExceptionHandlerMethodResolver.class.getDeclaredMethod("noMatchingExceptionHandler", new Class[0]));
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Expected method not found: " + String.valueOf(ex));
        }
    }

    private record ExceptionMapping(Class<? extends Throwable> exceptionType, MediaType mediaType) {
        @Override
        public String toString() {
            return "ExceptionHandler{exceptionType=" + this.exceptionType.getCanonicalName() + ", mediaType=" + String.valueOf(this.mediaType) + "}";
        }
    }

    private static class ExceptionMapingComparator
    implements Comparator<ExceptionMapping> {
        private final ExceptionDepthComparator exceptionDepthComparator;
        private final MediaType mediaType;

        public ExceptionMapingComparator(Class<? extends Throwable> exceptionType, MediaType mediaType) {
            this.exceptionDepthComparator = new ExceptionDepthComparator(exceptionType);
            this.mediaType = mediaType;
        }

        @Override
        public int compare(ExceptionMapping o1, ExceptionMapping o2) {
            int result = this.exceptionDepthComparator.compare(o1.exceptionType(), o2.exceptionType());
            if (result != 0) {
                return result;
            }
            if (o1.mediaType.equals(this.mediaType)) {
                return -1;
            }
            if (o2.mediaType.equals(this.mediaType)) {
                return 1;
            }
            if (o1.mediaType.equals(o2.mediaType)) {
                return 0;
            }
            return o1.mediaType.isMoreSpecific(o2.mediaType) ? -1 : 1;
        }
    }
}

