/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.aries.jax.rs.rest.management.internal.BaseResource;
import org.apache.aries.jax.rs.rest.management.internal.map.CaseInsensitiveMap;
import org.apache.aries.jax.rs.rest.management.schema.BundleHeaderSchema;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FrameworkBundleHeaderResource
extends BaseResource {
    public FrameworkBundleHeaderResource(BundleContext bundleContext) {
        super(bundleContext);
    }

    @GET
    @Produces(value={"application/org.osgi.bundleheader+json", "application/org.osgi.bundleheader+xml"})
    @Path(value="framework/bundle/{bundleid}/header{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="GET/bundle/header", summary="Retrieves a Bundle Header Representation from the REST management service", responses={@ApiResponse(responseCode="200", description="The request has been served successfully", content={@Content(schema=@Schema(implementation=BundleHeaderSchema.class))}), @ApiResponse(responseCode="404", description="There is no bundle with the given bundle id"), @ApiResponse(responseCode="406", description="The REST management service does not support any of the requested representations")}, parameters={@Parameter(name="Accept-Language", description="The raw header value is used unless an Accept-Language header is set on the HTTP request. If multiple accepted languages are set only the first is used to localize the header", in=ParameterIn.HEADER)})
    public Response bundleHeaders(@PathParam(value="bundleid") long bundleid, @Parameter(allowEmptyValue=true, schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext) {
        String language = this.headers.getAcceptableLanguages().stream().findFirst().map(Locale::toString).orElse(null);
        Bundle bundle = this.bundleContext.getBundle(bundleid);
        if (bundle == null) {
            throw new WebApplicationException(404);
        }
        Response.ResponseBuilder builder = Response.ok((Object)new BundleHeaderSchema((Map<String, String>)new CaseInsensitiveMap<String>(bundle.getHeaders(language))));
        return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.bundleheader+json" : "application/org.osgi.bundleheader+xml").map(type -> builder.type(type)).orElse(builder).build();
    }
}

