/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.osgi.service.rest.RestApiExtension;

@XmlRootElement(name="extensions")
public class ExtensionsSchema {
    @XmlElement(name="extension")
    public List<Extension> extensions = new ArrayList<Extension>();

    public static ExtensionsSchema build(Set<CachingServiceReference<RestApiExtension>> extensions) {
        ExtensionsSchema extensionsSchema = new ExtensionsSchema();
        extensions.stream().map(ext -> {
            Extension extension = new Extension();
            extension.name = (String)ext.getProperty("org.osgi.rest.name");
            extension.path = (String)ext.getProperty("org.osgi.rest.uri.path");
            Optional.ofNullable(ext.getProperty("org.osgi.rest.service")).map(Long.class::cast).ifPresent(service -> {
                extension.service = service;
            });
            return extension;
        }).forEach(extensionsSchema.extensions::add);
        return extensionsSchema;
    }

    public static class Extension {
        public String name;
        public String path;
        public long service;
    }
}

