/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.aries.jax.rs.rest.management.internal.BaseResource;
import org.apache.aries.jax.rs.rest.management.schema.FrameworkStartLevelSchema;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.startlevel.dto.FrameworkStartLevelDTO;

public class FrameworkStartLevelResource
extends BaseResource {
    public FrameworkStartLevelResource(BundleContext bundleContext) {
        super(bundleContext);
    }

    @GET
    @Produces(value={"application/org.osgi.frameworkstartlevel+json", "application/org.osgi.frameworkstartlevel+xml"})
    @Path(value="framework/startlevel{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="GET/startlevel", summary="Retrieves a Framework Startlevel Representation from the REST management service", responses={@ApiResponse(responseCode="200", description="The framework start level", content={@Content(schema=@Schema(implementation=FrameworkStartLevelSchema.class))}), @ApiResponse(responseCode="406", description="The REST management service does not support any of the requested representations")})
    public Response startlevel(@Parameter(allowEmptyValue=true, schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK).entity((Object)FrameworkStartLevelSchema.build((FrameworkStartLevelDTO)this.framework.adapt(FrameworkStartLevelDTO.class)));
        return Optional.ofNullable(ext).map(String::trim).map(t -> ".json".equals(t) ? "application/org.osgi.frameworkstartlevel+json" : "application/org.osgi.frameworkstartlevel+xml").map(t -> builder.type(t)).orElse(builder).build();
    }

    @PUT
    @Consumes(value={"application/org.osgi.frameworkstartlevel+json", "application/org.osgi.frameworkstartlevel+xml"})
    @Path(value="framework/startlevel{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="PUT/startlevel", summary="Set the target framework startlevel", responses={@ApiResponse(responseCode="204", description="The request was received and valid. The framework will asynchronously start to adjust the framework startlevel until the target startlevel has been reached"), @ApiResponse(responseCode="400", description="The REST management service received an IllegalArgumentException when trying to adjust the framework startlevel"), @ApiResponse(responseCode="415", description="The request had a media type that is not supported by the REST management service")})
    public Response startlevel(FrameworkStartLevelSchema update, @Parameter(allowEmptyValue=true, schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext) {
        try {
            FrameworkStartLevel current = (FrameworkStartLevel)this.framework.adapt(FrameworkStartLevel.class);
            if (current.getStartLevel() != update.startLevel) {
                current.setStartLevel(update.startLevel, new FrameworkListener[0]);
            }
            if (current.getInitialBundleStartLevel() != update.initialBundleStartLevel) {
                current.setInitialBundleStartLevel(update.initialBundleStartLevel);
            }
            return Response.noContent().build();
        }
        catch (IllegalArgumentException exception) {
            throw new WebApplicationException((Throwable)exception, 400);
        }
    }
}

