/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.shiro.authc.impl;

import java.io.IOException;
import java.io.Serializable;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
public class SecurityManagerAssociatingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger _LOG = LoggerFactory.getLogger(SecurityManagerAssociatingFilter.class);
    private final SecurityManager manager;

    public SecurityManagerAssociatingFilter(SecurityManager manager) {
        this.manager = manager;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        UriInfo info;
        _LOG.debug("Establishing Shiro Security Context");
        ThreadContext.bind((SecurityManager)this.manager);
        Cookie cookie = (Cookie)requestContext.getCookies().get("JAXRSSESSIONID");
        if (cookie != null) {
            _LOG.debug("Found a Shiro Security Context cookie: {}. Establishing user context", (Object)cookie);
            _LOG.debug("Establishing user context:");
            Subject subject = new Subject.Builder(this.manager).sessionId((Serializable)((Object)cookie.getValue())).buildSubject();
            ThreadContext.bind((Subject)subject);
            if (_LOG.isDebugEnabled()) {
                _LOG.debug("Established user context for: {}", subject.getPrincipal());
            }
        }
        if ("security/authenticate".equals((info = requestContext.getUriInfo()).getPath())) {
            requestContext.abortWith(this.authenticate(info, requestContext.getHeaderString("user"), requestContext.getHeaderString("password")));
        } else if ("security/logout".equals(info.getPath())) {
            this.logout();
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Cookie cookie;
        _LOG.debug("Cleaning up the Shiro Security Context");
        Subject subject = ThreadContext.getSubject();
        ThreadContext.unbindSecurityManager();
        ThreadContext.unbindSubject();
        if (subject != null && !subject.isAuthenticated() && (cookie = (Cookie)requestContext.getCookies().get("JAXRSSESSIONID")) != null) {
            _LOG.debug("The subject associated with this request is not authenticated, removing the session cookie");
            responseContext.getHeaders().add((Object)"Set-Cookie", (Object)this.getDeletionCookie(requestContext));
        }
    }

    private NewCookie getDeletionCookie(ContainerRequestContext requestContext) {
        return new NewCookie("JAXRSSESSIONID", "deleteMe", requestContext.getUriInfo().getBaseUri().getPath(), null, -1, null, -1, null, false, true);
    }

    private Response authenticate(UriInfo info, String user, String password) {
        Response.ResponseBuilder rb;
        _LOG.debug("Received a login request for user {}", (Object)user);
        Subject currentUser = SecurityUtils.getSubject();
        if (!currentUser.isAuthenticated()) {
            _LOG.debug("Authenticating user {}", (Object)user);
            UsernamePasswordToken token = new UsernamePasswordToken(user, password);
            token.setRememberMe(true);
            currentUser.login((AuthenticationToken)token);
            rb = Response.ok().cookie(new NewCookie[]{new NewCookie("JAXRSSESSIONID", currentUser.getSession().getId().toString(), info.getBaseUri().getPath(), null, -1, null, -1, null, false, true)});
        } else {
            _LOG.debug("The login request for user {} was already authenticated as user {}", (Object)user, currentUser.getPrincipal());
            rb = Response.status((Response.Status)Response.Status.CONFLICT);
        }
        return rb.build();
    }

    private void logout() {
        _LOG.debug("Received a logout request");
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser.isAuthenticated()) {
            _LOG.debug("Logging out user {}", currentUser.getPrincipal());
            currentUser.logout();
        }
    }
}

