/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.axis2.jaxws.addressing.util;

import javax.xml.namespace.QName;

/**
 * This class is used to identify a particular web service endpoint based on
 * the combination of WSDL service name and port name.
 *
 */
public class EndpointKey {
    private final QName service;
    private final QName endpoint;
    
    public EndpointKey(QName service, QName endpoint) {
        if (service == null)
            throw new IllegalArgumentException("The service qname cannot be null.");
        
        if (endpoint == null)
            throw new IllegalArgumentException("The endpoint qname cannot be null.");
        
        this.service = service;
        this.endpoint = endpoint;
    }

    public QName getEndpoint() {
        return endpoint;
    }

    public QName getService() {
        return service;
    }

    /* (non-Javadoc)
     * Generated by Eclipse - suggest re-generation if class changes
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        final EndpointKey other = (EndpointKey) obj;
        if (endpoint == null) {
            if (other.endpoint != null)
                return false;
        } else if (!endpoint.equals(other.endpoint))
            return false;
        if (service == null) {
            if (other.service != null)
                return false;
        } else if (!service.equals(other.service))
            return false;
        return true;
    }

    /* (non-Javadoc)
     * Generated by Eclipse - suggest re-generation if class changes
     */
    @Override
    public int hashCode() {
        final int PRIME = 31;
        int result = 1;
        result = PRIME * result + ((endpoint == null) ? 0 : endpoint.hashCode());
        result = PRIME * result + ((service == null) ? 0 : service.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Service: ");
        buffer.append(service);
        buffer.append(", Port: ");
        buffer.append(endpoint);
        
        return buffer.toString();
    }
}
