/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.intf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CloneableCharacterData;
import org.apache.axiom.core.stream.CharacterData;
import org.apache.axiom.core.stream.CharacterDataSink;
import org.apache.axiom.ext.stax.BlobProvider;
import org.apache.axiom.mime.PartBlob;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMException;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axiom.util.base64.AbstractBase64EncodingOutputStream;
import org.apache.axiom.util.base64.Base64EncodingStringBufferOutputStream;
import org.apache.axiom.util.base64.Base64Utils;

public final class TextContent
implements CloneableCharacterData {
    private final String value;
    private String contentID;
    private Object blobObject;
    private boolean optimize;
    private boolean binary;

    public TextContent(String value) {
        this.value = value;
    }

    public TextContent(String contentID, Object blobObject, boolean optimize) {
        this.value = null;
        this.contentID = contentID;
        this.blobObject = blobObject;
        this.binary = true;
        this.optimize = optimize;
    }

    private TextContent(TextContent other) {
        this.value = other.value;
        this.contentID = other.contentID;
        this.blobObject = other.blobObject;
        this.optimize = other.optimize;
        this.binary = other.binary;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
        if (optimize) {
            this.binary = true;
        }
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public String getContentID() {
        if (this.contentID == null) {
            this.contentID = UIDGenerator.generateContentId();
        }
        return this.contentID;
    }

    public void setContentID(String contentID) {
        this.contentID = contentID;
    }

    public Object getBlobObject() {
        if (!this.binary) {
            throw new IllegalStateException();
        }
        if (this.blobObject != null) {
            return this.blobObject;
        }
        return Blobs.createBlob((byte[])Base64Utils.decode((String)this.value));
    }

    public Blob getBlob() {
        Object blobObject = this.getBlobObject();
        if (blobObject instanceof BlobProvider) {
            try {
                return ((BlobProvider)blobObject).getBlob();
            }
            catch (IOException ex) {
                throw new OMException((Throwable)ex);
            }
        }
        return (Blob)blobObject;
    }

    @Override
    public String toString() {
        if (this.blobObject != null) {
            try {
                return Base64Utils.encode((Blob)this.getBlob());
            }
            catch (Exception e) {
                throw new OMException((Throwable)e);
            }
        }
        return this.value;
    }

    public char[] toCharArray() {
        if (this.blobObject != null) {
            try {
                return Base64Utils.encodeToCharArray((Blob)this.getBlob());
            }
            catch (IOException ex) {
                throw new OMException((Throwable)ex);
            }
        }
        return this.value.toCharArray();
    }

    @Override
    public <T> CharacterData clone(ClonePolicy<T> policy, T options) {
        Blob blob;
        if (this.binary && options instanceof OMCloneOptions && ((OMCloneOptions)options).isFetchBlobs() && (blob = this.getBlob()) instanceof PartBlob) {
            ((PartBlob)blob).getPart().fetch();
        }
        return new TextContent(this);
    }

    @Override
    public void writeTo(CharacterDataSink sink) throws IOException {
        if (this.binary) {
            AbstractBase64EncodingOutputStream out = sink.getBase64EncodingOutputStream();
            this.getBlob().writeTo((OutputStream)out);
            out.complete();
        } else {
            sink.getWriter().write(this.value);
        }
    }

    @Override
    public void appendTo(StringBuilder buffer) {
        if (this.binary) {
            Base64EncodingStringBufferOutputStream out = new Base64EncodingStringBufferOutputStream(buffer);
            try {
                this.getBlob().writeTo((OutputStream)out);
                out.complete();
            }
            catch (IOException ex) {
                throw new OMException((Throwable)ex);
            }
        } else {
            buffer.append(this.value);
        }
    }
}

