---
title: 'Beam Twitter handle'
---
<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->
# Beam Twitter handle
## What is it and what are the goals?
Apache Beam community thrives to be inclusive to everyone. As part of this effort, we want to enable any community member to share anything interesting and fun related to Beam via its [official Twitter handle](https://twitter.com/ApacheBeam).

The Twitter feed found here is owned by the Apache Beam PMC, and the process of proposing new tweets is documented below.

<a class="twitter-timeline" data-lang="en" data-height="500" data-theme="light" data-link-color="#E95F28" href="https://twitter.com/ApacheBeam?ref_src=twsrc%5Etfw">Tweets by ApacheBeam</a> <script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>

## Process to propose new tweets for the Apache Beam Twitter

- Compose a tweet with the news you want to share. It can be anything that is relevant to Apache Beam. For example, it can be a tweet to welcome new committers, announce new Beam features, share and recognize contributors publicly, promote events and meetups, share trending articles around batch and stream processing big data, etc.
- Go to [s.apache.org/beam-tweets](https://s.apache.org/beam-tweets) and request “Edit” access.
- After you are able to edit the document, fill out the necessary fields:
	- Date - the date when you are filling out the document
	- Author - your name
	- Topic - what is the tweet about
	- Content - the actual text of the tweet or link to the tweet that need to be retweeted
	- Links/media - anything you want to add to the tweet, eg. photos, videos, references
	- Deadline - by when the tweet needs to be out, or preferred date when it needs to be out
- After you type in your tweets, PMC members that are subscribed to the document will get notified and review the content.
- After approval, a PMC member with access to the Twitter handle will publish the tweet.
- Follow [Apache Beam handle](https://twitter.com/ApacheBeam) to see if your content is published!
