/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.server.rest.util;

import java.net.URI;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.brooklyn.camp.server.dto.ApiErrorDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(WebResourceUtils.class);

    public static WebApplicationException notFound(String format, Object ... args) {
        String msg = String.format(format, args);
        if (log.isDebugEnabled()) {
            log.debug("returning 404 notFound(" + msg + ")");
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ApiErrorDto.builder().message(msg).build()).build());
    }

    public static WebApplicationException preconditionFailed(String format, Object ... args) {
        String msg = String.format(format, args);
        if (log.isDebugEnabled()) {
            log.debug("returning 412 preconditionFailed(" + msg + ")");
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ApiErrorDto.builder().message(msg).build()).build());
    }

    public static Response created(UriInfo info, String resourceUriPath) {
        URI resourceUri = info.getBaseUriBuilder().path(resourceUriPath).build(new Object[0]);
        return Response.created((URI)resourceUri).build();
    }
}

