/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.http;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class TestHttpRecordingRequestInterceptor
implements HttpRequestInterceptor {
    private final List<HttpRequest> requests = Collections.synchronizedList(Lists.newArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HttpRequest> getRequests() {
        List<HttpRequest> list = this.requests;
        synchronized (list) {
            return ImmutableList.copyOf(this.requests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequest getLastRequest() {
        List<HttpRequest> list = this.requests;
        synchronized (list) {
            if (this.requests.isEmpty()) {
                throw new NoSuchElementException("No http-requests received");
            }
            return this.requests.get(this.requests.size() - 1);
        }
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        this.requests.add(request);
    }
}

