/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.kameletspec.versions.types;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.AnyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.kameletspec.versions.types.Schema;
import org.apache.camel.v1.kameletspec.versions.types.schema.ExternalDocs;
import org.apache.camel.v1.kameletspec.versions.types.schema.ExternalDocsBuilder;
import org.apache.camel.v1.kameletspec.versions.types.schema.ExternalDocsFluent;
import org.apache.camel.v1.kameletspec.versions.types.schema.Properties;

public class SchemaFluent<A extends SchemaFluent<A>>
extends BaseFluent<A> {
    private String description;
    private AnyType example;
    private ExternalDocsBuilder externalDocs;
    private String id;
    private Map<String, Properties> properties;
    private List<String> required;
    private String title;
    private String type;

    public SchemaFluent() {
    }

    public SchemaFluent(Schema instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Schema instance) {
        Schema schema = instance = instance != null ? instance : new Schema();
        if (instance != null) {
            this.withDescription(instance.getDescription());
            this.withExample(instance.getExample());
            this.withExternalDocs(instance.getExternalDocs());
            this.withId(instance.getId());
            this.withProperties(instance.getProperties());
            this.withRequired(instance.getRequired());
            this.withTitle(instance.getTitle());
            this.withType(instance.getType());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)((Object)this);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public AnyType getExample() {
        return this.example;
    }

    public A withExample(AnyType example) {
        this.example = example;
        return (A)((Object)this);
    }

    public boolean hasExample() {
        return this.example != null;
    }

    public A withNewExample(Object value) {
        return this.withExample(new AnyType(value));
    }

    public ExternalDocs buildExternalDocs() {
        return this.externalDocs != null ? this.externalDocs.build() : null;
    }

    public A withExternalDocs(ExternalDocs externalDocs) {
        this._visitables.remove((Object)"externalDocs");
        if (externalDocs != null) {
            this.externalDocs = new ExternalDocsBuilder(externalDocs);
            this._visitables.get((Object)"externalDocs").add(this.externalDocs);
        } else {
            this.externalDocs = null;
            this._visitables.get((Object)"externalDocs").remove((Object)this.externalDocs);
        }
        return (A)((Object)this);
    }

    public boolean hasExternalDocs() {
        return this.externalDocs != null;
    }

    public ExternalDocsNested<A> withNewExternalDocs() {
        return new ExternalDocsNested(null);
    }

    public ExternalDocsNested<A> withNewExternalDocsLike(ExternalDocs item) {
        return new ExternalDocsNested(item);
    }

    public ExternalDocsNested<A> editVersionsExternalDocs() {
        return this.withNewExternalDocsLike(Optional.ofNullable(this.buildExternalDocs()).orElse(null));
    }

    public ExternalDocsNested<A> editOrNewExternalDocs() {
        return this.withNewExternalDocsLike(Optional.ofNullable(this.buildExternalDocs()).orElse(new ExternalDocsBuilder().build()));
    }

    public ExternalDocsNested<A> editOrNewExternalDocsLike(ExternalDocs item) {
        return this.withNewExternalDocsLike(Optional.ofNullable(this.buildExternalDocs()).orElse(item));
    }

    public String getId() {
        return this.id;
    }

    public A withId(String id) {
        this.id = id;
        return (A)((Object)this);
    }

    public boolean hasId() {
        return this.id != null;
    }

    public A addToProperties(String key, Properties value) {
        if (this.properties == null && key != null && value != null) {
            this.properties = new LinkedHashMap<String, Properties>();
        }
        if (key != null && value != null) {
            this.properties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToProperties(Map<String, Properties> map) {
        if (this.properties == null && map != null) {
            this.properties = new LinkedHashMap<String, Properties>();
        }
        if (map != null) {
            this.properties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromProperties(String key) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.properties != null) {
            this.properties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromProperties(Map<String, Properties> map) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.properties == null) continue;
                this.properties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Properties> getProperties() {
        return this.properties;
    }

    public <K, V> A withProperties(Map<String, Properties> properties) {
        this.properties = properties == null ? null : new LinkedHashMap<String, Properties>(properties);
        return (A)((Object)this);
    }

    public boolean hasProperties() {
        return this.properties != null;
    }

    public A addToRequired(int index, String item) {
        if (this.required == null) {
            this.required = new ArrayList<String>();
        }
        this.required.add(index, item);
        return (A)((Object)this);
    }

    public A setToRequired(int index, String item) {
        if (this.required == null) {
            this.required = new ArrayList<String>();
        }
        this.required.set(index, item);
        return (A)((Object)this);
    }

    public A addToRequired(String ... items) {
        if (this.required == null) {
            this.required = new ArrayList<String>();
        }
        for (String item : items) {
            this.required.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToRequired(Collection<String> items) {
        if (this.required == null) {
            this.required = new ArrayList<String>();
        }
        for (String item : items) {
            this.required.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromRequired(String ... items) {
        if (this.required == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.required.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRequired(Collection<String> items) {
        if (this.required == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.required.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getRequired() {
        return this.required;
    }

    public String getRequired(int index) {
        return this.required.get(index);
    }

    public String getFirstRequired() {
        return this.required.get(0);
    }

    public String getLastRequired() {
        return this.required.get(this.required.size() - 1);
    }

    public String getMatchingRequired(Predicate<String> predicate) {
        for (String item : this.required) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRequired(Predicate<String> predicate) {
        for (String item : this.required) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequired(List<String> required) {
        if (required != null) {
            this.required = new ArrayList<String>();
            for (String item : required) {
                this.addToRequired(item);
            }
        } else {
            this.required = null;
        }
        return (A)((Object)this);
    }

    public A withRequired(String ... required) {
        if (this.required != null) {
            this.required.clear();
            this._visitables.remove((Object)"required");
        }
        if (required != null) {
            for (String item : required) {
                this.addToRequired(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRequired() {
        return this.required != null && !this.required.isEmpty();
    }

    public String getTitle() {
        return this.title;
    }

    public A withTitle(String title) {
        this.title = title;
        return (A)((Object)this);
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchemaFluent that = (SchemaFluent)((Object)o);
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.example, that.example)) {
            return false;
        }
        if (!Objects.equals((Object)this.externalDocs, (Object)that.externalDocs)) {
            return false;
        }
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.properties, that.properties)) {
            return false;
        }
        if (!Objects.equals(this.required, that.required)) {
            return false;
        }
        if (!Objects.equals(this.title, that.title)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.example, this.externalDocs, this.id, this.properties, this.required, this.title, this.type, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.example != null) {
            sb.append("example:");
            sb.append(this.example + ",");
        }
        if (this.externalDocs != null) {
            sb.append("externalDocs:");
            sb.append(this.externalDocs + ",");
        }
        if (this.id != null) {
            sb.append("id:");
            sb.append(this.id + ",");
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("properties:");
            sb.append(this.properties + ",");
        }
        if (this.required != null && !this.required.isEmpty()) {
            sb.append("required:");
            sb.append(this.required + ",");
        }
        if (this.title != null) {
            sb.append("title:");
            sb.append(this.title + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ExternalDocsNested<N>
    extends ExternalDocsFluent<ExternalDocsNested<N>>
    implements Nested<N> {
        ExternalDocsBuilder builder;

        ExternalDocsNested(ExternalDocs item) {
            this.builder = new ExternalDocsBuilder(this, item);
        }

        public N and() {
            return (N)SchemaFluent.this.withExternalDocs(this.builder.build());
        }

        public N endVersionsExternalDocs() {
            return this.and();
        }
    }
}

