/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1alpha1.kameletbindingspec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import org.apache.camel.v1alpha1.kameletbindingspec.SourceBuilder;
import org.apache.camel.v1alpha1.kameletbindingspec.source.DataTypes;
import org.apache.camel.v1alpha1.kameletbindingspec.source.Properties;
import org.apache.camel.v1alpha1.kameletbindingspec.source.Ref;
import org.apache.camel.v1alpha1.kameletbindingspec.source.Types;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"dataTypes", "properties", "ref", "types", "uri"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Source
implements Editable<SourceBuilder>,
KubernetesResource {
    @JsonProperty(value="dataTypes")
    @JsonPropertyDescription(value="DataTypes defines the data type of the data produced/consumed by the endpoint and references a given data type specification.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, DataTypes> dataTypes;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Properties are a key value representation of endpoint properties")
    @JsonSetter(nulls=Nulls.SKIP)
    private Properties properties;
    @JsonProperty(value="ref")
    @JsonPropertyDescription(value="Ref can be used to declare a Kubernetes resource as source/sink endpoint")
    @JsonSetter(nulls=Nulls.SKIP)
    private Ref ref;
    @JsonProperty(value="types")
    @JsonPropertyDescription(value="Types defines the data type of the data produced/consumed by the endpoint and references a given data type specification.\nDeprecated: In favor of using DataTypes")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, Types> types;
    @JsonProperty(value="uri")
    @JsonPropertyDescription(value="URI can be used to specify the (Camel) endpoint explicitly")
    @JsonSetter(nulls=Nulls.SKIP)
    private String uri;

    public SourceBuilder edit() {
        return new SourceBuilder(this);
    }

    public Map<String, DataTypes> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(Map<String, DataTypes> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Ref getRef() {
        return this.ref;
    }

    public void setRef(Ref ref) {
        this.ref = ref;
    }

    public Map<String, Types> getTypes() {
        return this.types;
    }

    public void setTypes(Map<String, Types> types) {
        this.types = types;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String toString() {
        return "Source(dataTypes=" + this.getDataTypes() + ", properties=" + this.getProperties() + ", ref=" + this.getRef() + ", types=" + this.getTypes() + ", uri=" + this.getUri() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Source)) {
            return false;
        }
        Source other = (Source)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, DataTypes> this$dataTypes = this.getDataTypes();
        Map<String, DataTypes> other$dataTypes = other.getDataTypes();
        if (this$dataTypes == null ? other$dataTypes != null : !((Object)this$dataTypes).equals(other$dataTypes)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Ref this$ref = this.getRef();
        Ref other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !((Object)this$ref).equals(other$ref)) {
            return false;
        }
        Map<String, Types> this$types = this.getTypes();
        Map<String, Types> other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Source;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, DataTypes> $dataTypes = this.getDataTypes();
        result = result * 59 + ($dataTypes == null ? 43 : ((Object)$dataTypes).hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Ref $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : ((Object)$ref).hashCode());
        Map<String, Types> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        return result;
    }
}

