/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.resource;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.resource.Resource;

public class URLResource
implements Resource {
    private URL url;

    public URLResource(URL url) {
        this.url = url;
    }

    public Resource getRelativeResource(String relativePath) {
        try {
            return new URLResource(new URL(this.url, relativePath));
        }
        catch (MalformedURLException e) {
            throw new CayenneRuntimeException("Error creating relative resource '%s' : '%s'", (Throwable)e, this.url, relativePath);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public String toString() {
        String urlString = String.valueOf(this.url);
        return "<URLResource: " + urlString + ">";
    }
}

