/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.undo.CreateDataMapUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.NamedObjectFactory;

public class CreateDataMapAction
extends CayenneAction {
    public static String getActionName() {
        return "Create DataMap";
    }

    public CreateDataMapAction(Application application) {
        super(CreateDataMapAction.getActionName(), application);
    }

    public String getIconName() {
        return "icon-datamap.gif";
    }

    public void createDataMap(DataMap map) {
        ProjectController mediator = this.getProjectController();
        mediator.addDataMap(this, map);
    }

    public void performAction(ActionEvent e) {
        ProjectController mediator = this.getProjectController();
        DataChannelDescriptor currentDomain = (DataChannelDescriptor)mediator.getProject().getRootNode();
        DataMap map = (DataMap)NamedObjectFactory.createObject(DataMap.class, currentDomain);
        Resource baseResource = currentDomain.getConfigurationSource();
        if (baseResource != null) {
            Resource dataMapResource = baseResource.getRelativeResource(map.getName());
            map.setConfigurationSource(dataMapResource);
        }
        this.createDataMap(map);
        this.application.getUndoManager().addEdit(new CreateDataMapUndoableEdit(currentDomain, map));
    }

    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        return ((DataNodeDescriptor)object).getDataChannelDescriptor() != null;
    }
}

