/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.cayenne.dbsync.merge.AbstractMerger;
import org.apache.cayenne.dbsync.merge.DbEntityDictionary;
import org.apache.cayenne.dbsync.merge.MergerDictionaryDiff;
import org.apache.cayenne.dbsync.merge.MergerDiffPair;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.DetectedDbEntity;

class DbEntityMerger
extends AbstractMerger<DataMap, DbEntity> {
    private final FiltersConfig filtersConfig;
    private final boolean skipPKTokens;
    private DataMap originalDataMap;
    private DataMap importedDataMap;

    DbEntityMerger(MergerTokenFactory tokenFactory, DataMap original, DataMap imported, FiltersConfig filtersConfig, boolean skipPKTokens) {
        super(tokenFactory);
        this.filtersConfig = filtersConfig;
        this.skipPKTokens = skipPKTokens;
        this.originalDataMap = original;
        this.importedDataMap = imported;
    }

    @Override
    public List<MergerToken> createMergeTokens() {
        return this.createMergeTokens(this.originalDataMap, this.importedDataMap);
    }

    @Override
    MergerDictionaryDiff<DbEntity> createDiff(DataMap original, DataMap imported) {
        DbEntityDictionary dictionary = new DbEntityDictionary(original, this.filtersConfig);
        MergerDictionaryDiff<DbEntity> diff = new MergerDictionaryDiff.Builder<DbEntity>().originalDictionary(dictionary).importedDictionary(new DbEntityDictionary(imported, null)).build();
        this.setOriginalDictionary(dictionary);
        return diff;
    }

    @Override
    Collection<MergerToken> createTokensForMissingOriginal(DbEntity imported) {
        return Collections.singleton(this.getTokenFactory().createDropTableToDb(imported));
    }

    @Override
    Collection<MergerToken> createTokensForMissingImported(DbEntity original) {
        LinkedList<MergerToken> tokens = new LinkedList<MergerToken>();
        tokens.add(this.getTokenFactory().createCreateTableToDb(original));
        for (DbRelationship rel : original.getRelationships()) {
            tokens.add(this.getTokenFactory().createAddRelationshipToDb(original, rel));
        }
        return tokens;
    }

    @Override
    Collection<MergerToken> createTokensForSame(MergerDiffPair<DbEntity> same) {
        if (this.skipPKTokens) {
            return null;
        }
        return this.checkPrimaryKeyChange(same.getOriginal(), same.getImported());
    }

    private Collection<MergerToken> checkPrimaryKeyChange(DbEntity original, DbEntity imported) {
        Collection primaryKeyOriginal = imported.getPrimaryKeys();
        Collection primaryKeyNew = original.getPrimaryKeys();
        String primaryKeyName = null;
        if (imported instanceof DetectedDbEntity) {
            if ("VIEW".equals(((DetectedDbEntity)imported).getType())) {
                return null;
            }
            primaryKeyName = ((DetectedDbEntity)imported).getPrimaryKeyName();
        }
        if (this.upperCaseEntityNames(primaryKeyOriginal).equals(this.upperCaseEntityNames(primaryKeyNew))) {
            return null;
        }
        return Collections.singleton(this.getTokenFactory().createSetPrimaryKeyToDb(original, primaryKeyOriginal, primaryKeyNew, primaryKeyName));
    }

    private Set<String> upperCaseEntityNames(Collection<? extends Attribute> attributes) {
        HashSet<String> names = new HashSet<String>();
        for (Attribute attribute : attributes) {
            names.add(attribute.getName().toUpperCase());
        }
        return names;
    }
}

