/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.rop;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ROPRequestContext {
    private static final ThreadLocal<ROPRequestContext> localContext = new ThreadLocal();
    private String serviceId;
    private String objectId;
    private ServletRequest request;
    private ServletResponse response;
    private int count;

    private ROPRequestContext() {
    }

    public static void start(String serviceId, String objectId, ServletRequest request, ServletResponse response) {
        ROPRequestContext context = localContext.get();
        if (context == null) {
            context = new ROPRequestContext();
            localContext.set(context);
        }
        context.serviceId = serviceId;
        context.objectId = objectId;
        context.request = request;
        context.response = response;
        ++context.count;
    }

    public static ROPRequestContext getROPRequestContext() {
        return localContext.get();
    }

    public static String getContextServiceId() {
        ROPRequestContext context = localContext.get();
        if (context != null) {
            return context.serviceId;
        }
        return null;
    }

    public static String getContextObjectId() {
        ROPRequestContext context = localContext.get();
        if (context != null) {
            return context.objectId;
        }
        return null;
    }

    public static ServletRequest getContextRequest() {
        ROPRequestContext context = localContext.get();
        if (context != null) {
            return context.request;
        }
        return null;
    }

    public static ServletResponse getContextResponse() {
        ROPRequestContext context = localContext.get();
        if (context != null) {
            return context.response;
        }
        return null;
    }

    public static void end() {
        ROPRequestContext context = localContext.get();
        if (context != null && --context.count == 0) {
            context.request = null;
            context.response = null;
            localContext.set(null);
        }
    }
}

