/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.hierarchical;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.JGraphLayout;
import com.jgraph.layout.JGraphLayoutProgress;
import com.jgraph.layout.hierarchical.JGraphHierarchicalLayoutStep;
import com.jgraph.layout.hierarchical.model.JGraphAbstractHierarchyCell;
import com.jgraph.layout.hierarchical.model.JGraphHierarchyModel;
import com.jgraph.layout.hierarchical.model.JGraphHierarchyRank;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class JGraphMedianHybridCrossingReduction
implements JGraphHierarchicalLayoutStep,
JGraphLayout.Stoppable {
    protected int maxIterations = 24;
    protected Object[][] nestedBestRanks = null;
    protected int currentBestCrossings = 0;
    protected int iterationsWithoutImprovement = 0;
    protected int maxNoImprovementIterations = 2;
    protected JGraphLayoutProgress progress = new JGraphLayoutProgress();

    public JGraphHierarchyModel run(JGraphFacade jGraphFacade, JGraphHierarchyModel jGraphHierarchyModel) {
        Iterator iterator;
        int n;
        int n2;
        if (jGraphHierarchyModel == null) {
            return null;
        }
        this.nestedBestRanks = new Object[jGraphHierarchyModel.ranks.size()][];
        for (n2 = 0; n2 < this.nestedBestRanks.length; ++n2) {
            JGraphHierarchyRank jGraphHierarchyRank = (JGraphHierarchyRank)jGraphHierarchyModel.ranks.get(new Integer(n2));
            this.nestedBestRanks[n2] = jGraphHierarchyRank.toArray();
        }
        this.progress.reset(this.maxIterations);
        this.iterationsWithoutImprovement = 0;
        this.currentBestCrossings = this.calculateCrossings(jGraphHierarchyModel);
        for (n2 = 0; n2 < this.maxIterations && !this.progress.isStopped() && this.iterationsWithoutImprovement < this.maxNoImprovementIterations; ++n2) {
            JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell;
            int n3;
            JGraphHierarchyRank jGraphHierarchyRank;
            this.progress.setProgress(n2);
            this.weightedMedian(n2, jGraphHierarchyModel);
            this.transpose(n2, jGraphHierarchyModel);
            int n4 = this.calculateCrossings(jGraphHierarchyModel);
            if (n4 < this.currentBestCrossings) {
                this.currentBestCrossings = n4;
                this.iterationsWithoutImprovement = 0;
                for (n = 0; n < this.nestedBestRanks.length; ++n) {
                    jGraphHierarchyRank = (JGraphHierarchyRank)jGraphHierarchyModel.ranks.get(new Integer(n));
                    iterator = jGraphHierarchyRank.iterator();
                    for (n3 = 0; n3 < jGraphHierarchyRank.size(); ++n3) {
                        jGraphAbstractHierarchyCell = (JGraphAbstractHierarchyCell)iterator.next();
                        this.nestedBestRanks[n][jGraphAbstractHierarchyCell.getGeneralPurposeVariable((int)n)] = jGraphAbstractHierarchyCell;
                    }
                }
            } else {
                ++this.iterationsWithoutImprovement;
                for (n = 0; n < this.nestedBestRanks.length; ++n) {
                    jGraphHierarchyRank = (JGraphHierarchyRank)jGraphHierarchyModel.ranks.get(new Integer(n));
                    iterator = jGraphHierarchyRank.iterator();
                    for (n3 = 0; n3 < jGraphHierarchyRank.size(); ++n3) {
                        jGraphAbstractHierarchyCell = (JGraphAbstractHierarchyCell)iterator.next();
                        jGraphAbstractHierarchyCell.setGeneralPurposeVariable(n, n3);
                    }
                }
            }
            if (this.currentBestCrossings == 0) break;
        }
        LinkedHashMap<Integer, JGraphHierarchyRank> linkedHashMap = new LinkedHashMap<Integer, JGraphHierarchyRank>(jGraphHierarchyModel.maxRank + 1);
        JGraphHierarchyRank[] jGraphHierarchyRankArray = new JGraphHierarchyRank[jGraphHierarchyModel.maxRank + 1];
        for (n = 0; n < jGraphHierarchyModel.maxRank + 1; ++n) {
            jGraphHierarchyRankArray[n] = new JGraphHierarchyRank();
            linkedHashMap.put(new Integer(n), jGraphHierarchyRankArray[n]);
        }
        for (n = 0; n < this.nestedBestRanks.length; ++n) {
            for (int i = 0; i < this.nestedBestRanks[n].length; ++i) {
                iterator = (JGraphAbstractHierarchyCell)this.nestedBestRanks[n][i];
                jGraphHierarchyRankArray[n].add(iterator);
            }
        }
        jGraphHierarchyModel.ranks = linkedHashMap;
        return jGraphHierarchyModel;
    }

    private int calculateCrossings(JGraphHierarchyModel jGraphHierarchyModel) {
        int n = jGraphHierarchyModel.ranks.size();
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            n2 += this.calculateRankCrossing(i, jGraphHierarchyModel);
        }
        return n2;
    }

    protected int calculateRankCrossing(int n, JGraphHierarchyModel jGraphHierarchyModel) {
        int n2;
        int n3 = 0;
        JGraphHierarchyRank jGraphHierarchyRank = (JGraphHierarchyRank)jGraphHierarchyModel.ranks.get(new Integer(n));
        JGraphHierarchyRank jGraphHierarchyRank2 = (JGraphHierarchyRank)jGraphHierarchyModel.ranks.get(new Integer(n - 1));
        int n4 = jGraphHierarchyRank.size();
        int n5 = jGraphHierarchyRank2.size();
        int[][] nArray = new int[n4][n5];
        Iterator iterator = jGraphHierarchyRank.iterator();
        while (iterator.hasNext()) {
            JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell = (JGraphAbstractHierarchyCell)iterator.next();
            n2 = jGraphAbstractHierarchyCell.getGeneralPurposeVariable(n);
            List list = jGraphAbstractHierarchyCell.getPreviousLayerConnectedCells(n);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell2 = (JGraphAbstractHierarchyCell)iterator2.next();
                int n6 = jGraphAbstractHierarchyCell2.getGeneralPurposeVariable(n - 1);
                if (n2 >= n4 || n6 >= n5) {
                    // empty if block
                }
                nArray[n2][n6] = 201207;
            }
        }
        for (int i = 0; i < n4; ++i) {
            for (n2 = 0; n2 < n5; ++n2) {
                int n7;
                if (nArray[i][n2] != 201207) continue;
                for (n7 = i + 1; n7 < n4; ++n7) {
                    for (int j = 0; j < n2; ++j) {
                        if (nArray[n7][j] != 201207) continue;
                        ++n3;
                    }
                }
                for (n7 = 0; n7 < i; ++n7) {
                    for (int j = n2 + 1; j < n5; ++j) {
                        if (nArray[n7][j] != 201207) continue;
                        ++n3;
                    }
                }
            }
        }
        return n3 / 2;
    }

    private void transpose(int n, JGraphHierarchyModel jGraphHierarchyModel) {
        boolean bl = true;
        int n2 = 0;
        int n3 = 10;
        while (bl && n2++ < n3) {
            boolean bl2 = false;
            if (n % 2 == 1 && n2 % 2 == 1) {
                bl2 = true;
            }
            bl = false;
            for (int i = 0; i < jGraphHierarchyModel.ranks.size(); ++i) {
                Object object;
                JGraphHierarchyRank jGraphHierarchyRank = (JGraphHierarchyRank)jGraphHierarchyModel.ranks.get(new Integer(i));
                JGraphAbstractHierarchyCell[] jGraphAbstractHierarchyCellArray = new JGraphAbstractHierarchyCell[jGraphHierarchyRank.size()];
                Iterator iterator = jGraphHierarchyRank.iterator();
                for (int j = 0; j < jGraphAbstractHierarchyCellArray.length; ++j) {
                    object = (JGraphAbstractHierarchyCell)iterator.next();
                    jGraphAbstractHierarchyCellArray[((JGraphAbstractHierarchyCell)object).getGeneralPurposeVariable((int)i)] = object;
                }
                List list = null;
                object = null;
                List list2 = null;
                Object object2 = null;
                int[] nArray = null;
                int[] nArray2 = null;
                int[] nArray3 = null;
                int[] nArray4 = null;
                JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell = null;
                JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell2 = null;
                for (int j = 0; j < jGraphHierarchyRank.size() - 1; ++j) {
                    int n4;
                    int n5;
                    int n6;
                    if (j == 0) {
                        jGraphAbstractHierarchyCell = jGraphAbstractHierarchyCellArray[j];
                        list = jGraphAbstractHierarchyCell.getNextLayerConnectedCells(i);
                        object = jGraphAbstractHierarchyCell.getPreviousLayerConnectedCells(i);
                        nArray = new int[list.size()];
                        nArray2 = new int[object.size()];
                        for (n6 = 0; n6 < nArray.length; ++n6) {
                            nArray[n6] = ((JGraphAbstractHierarchyCell)list.get(n6)).getGeneralPurposeVariable(i + 1);
                        }
                        for (n6 = 0; n6 < nArray2.length; ++n6) {
                            nArray2[n6] = ((JGraphAbstractHierarchyCell)object.get(n6)).getGeneralPurposeVariable(i - 1);
                        }
                    } else {
                        list = list2;
                        object = object2;
                        nArray = nArray3;
                        nArray2 = nArray4;
                        jGraphAbstractHierarchyCell = jGraphAbstractHierarchyCell2;
                    }
                    jGraphAbstractHierarchyCell2 = jGraphAbstractHierarchyCellArray[j + 1];
                    list2 = jGraphAbstractHierarchyCell2.getNextLayerConnectedCells(i);
                    object2 = jGraphAbstractHierarchyCell2.getPreviousLayerConnectedCells(i);
                    nArray3 = new int[list2.size()];
                    nArray4 = new int[object2.size()];
                    for (n6 = 0; n6 < nArray3.length; ++n6) {
                        nArray3[n6] = ((JGraphAbstractHierarchyCell)list2.get(n6)).getGeneralPurposeVariable(i + 1);
                    }
                    for (n6 = 0; n6 < nArray4.length; ++n6) {
                        nArray4[n6] = ((JGraphAbstractHierarchyCell)object2.get(n6)).getGeneralPurposeVariable(i - 1);
                    }
                    n6 = 0;
                    int n7 = 0;
                    for (n5 = 0; n5 < nArray.length; ++n5) {
                        for (n4 = 0; n4 < nArray3.length; ++n4) {
                            if (nArray[n5] > nArray3[n4]) {
                                ++n6;
                            }
                            if (nArray[n5] >= nArray3[n4]) continue;
                            ++n7;
                        }
                    }
                    for (n5 = 0; n5 < nArray2.length; ++n5) {
                        for (n4 = 0; n4 < nArray4.length; ++n4) {
                            if (nArray2[n5] > nArray4[n4]) {
                                ++n6;
                            }
                            if (nArray2[n5] >= nArray4[n4]) continue;
                            ++n7;
                        }
                    }
                    if (n7 >= n6 && (n7 != n6 || !bl2)) continue;
                    n5 = jGraphAbstractHierarchyCell.getGeneralPurposeVariable(i);
                    jGraphAbstractHierarchyCell.setGeneralPurposeVariable(i, jGraphAbstractHierarchyCell2.getGeneralPurposeVariable(i));
                    jGraphAbstractHierarchyCell2.setGeneralPurposeVariable(i, n5);
                    list2 = list;
                    object2 = object;
                    nArray3 = nArray;
                    nArray4 = nArray2;
                    jGraphAbstractHierarchyCell2 = jGraphAbstractHierarchyCell;
                    if (bl2) continue;
                    bl = true;
                }
            }
        }
    }

    private void weightedMedian(int n, JGraphHierarchyModel jGraphHierarchyModel) {
        boolean bl;
        boolean bl2 = bl = n % 2 == 0;
        if (bl) {
            for (int i = jGraphHierarchyModel.maxRank - 1; i >= 0; --i) {
                this.medianRank(i, bl);
            }
        } else {
            for (int i = 1; i < jGraphHierarchyModel.maxRank; ++i) {
                this.medianRank(i, bl);
            }
        }
    }

    private void medianRank(int n, boolean bl) {
        int n2;
        int n3 = this.nestedBestRanks[n].length;
        Object[] objectArray = new MedianCellSorter[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell = (JGraphAbstractHierarchyCell)this.nestedBestRanks[n][n2];
            objectArray[n2] = new MedianCellSorter();
            ((MedianCellSorter)objectArray[n2]).cell = jGraphAbstractHierarchyCell;
            ((MedianCellSorter)objectArray[n2]).nudge = !bl;
            List list = bl ? jGraphAbstractHierarchyCell.getNextLayerConnectedCells(n) : jGraphAbstractHierarchyCell.getPreviousLayerConnectedCells(n);
            int n4 = bl ? n + 1 : n - 1;
            ((MedianCellSorter)objectArray[n2]).medianValue = list != null && list.size() != 0 ? this.medianValue(list, n4) : -1.0;
        }
        Arrays.sort(objectArray);
        for (n2 = 0; n2 < n3; ++n2) {
            ((MedianCellSorter)objectArray[n2]).cell.setGeneralPurposeVariable(n, n2);
        }
    }

    private double medianValue(Collection collection, int n) {
        double[] dArray = new double[collection.size()];
        int n2 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            dArray[n2++] = ((JGraphAbstractHierarchyCell)iterator.next()).getGeneralPurposeVariable(n);
        }
        Arrays.sort(dArray);
        if (n2 % 2 == 1) {
            return dArray[n2 / 2];
        }
        if (n2 == 2) {
            return (dArray[0] + dArray[1]) / 2.0;
        }
        int n3 = n2 / 2;
        double d = dArray[n3 - 1] - dArray[0];
        double d2 = dArray[n2 - 1] - dArray[n3];
        return (dArray[n3 - 1] * d2 + dArray[n3] * d) / (d + d2);
    }

    public JGraphLayoutProgress getProgress() {
        return this.progress;
    }

    protected class MedianCellSorter
    implements Comparable {
        public double medianValue = 0.0;
        public boolean nudge = false;
        JGraphAbstractHierarchyCell cell = null;

        protected MedianCellSorter() {
        }

        public int compareTo(Object object) {
            if (object instanceof MedianCellSorter) {
                if (this.medianValue < ((MedianCellSorter)object).medianValue) {
                    return -1;
                }
                if (this.medianValue > ((MedianCellSorter)object).medianValue) {
                    return 1;
                }
                if (this.nudge) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }
}

