/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;

public class DoubleType
implements ExtendedType<Double> {
    @Override
    public String getClassName() {
        return Double.class.getName();
    }

    @Override
    public Double materializeObject(ResultSet rs, int index, int type) throws Exception {
        double d = rs.getDouble(index);
        return rs.wasNull() ? null : Double.valueOf(d);
    }

    @Override
    public Double materializeObject(CallableStatement rs, int index, int type) throws Exception {
        double d = rs.getDouble(index);
        return rs.wasNull() ? null : Double.valueOf(d);
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Double value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else {
            statement.setDouble(pos, value);
        }
    }

    @Override
    public String toString(Double value) {
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }
}

