/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataChannelDescriptorLoader;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.runtime.DataSourceFactory;
import org.apache.cayenne.configuration.runtime.DbAdapterFactory;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.merge.DataMapMerger;
import org.apache.cayenne.dbsync.merge.context.MergerContext;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactoryProvider;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.model.AbstractToModelToken;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportAction;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportConfiguration;
import org.apache.cayenne.dbsync.reverse.dbimport.ManyToManyCandidateEntity;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.ProxyModelMergeDelegate;
import org.apache.cayenne.dbsync.reverse.filters.CatalogFilter;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfigBuilder;
import org.apache.cayenne.dbsync.reverse.filters.SchemaFilter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.URLResource;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.SimpleValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.slf4j.Logger;

public class DefaultDbImportAction
implements DbImportAction {
    private final ProjectSaver projectSaver;
    protected final Logger logger;
    private final DataSourceFactory dataSourceFactory;
    private final DbAdapterFactory adapterFactory;
    private final DataMapLoader mapLoader;
    private final MergerTokenFactoryProvider mergerTokenFactoryProvider;
    private final DataChannelDescriptorLoader dataChannelDescriptorLoader;
    private final DataChannelMetaData metaData;
    private boolean hasChanges;
    private Collection<MergerToken> tokens;
    private DataMap loadedDataMap;

    public DefaultDbImportAction(@Inject Logger logger, @Inject ProjectSaver projectSaver, @Inject DataSourceFactory dataSourceFactory, @Inject DbAdapterFactory adapterFactory, @Inject DataMapLoader mapLoader, @Inject MergerTokenFactoryProvider mergerTokenFactoryProvider, @Inject DataChannelDescriptorLoader dataChannelDescriptorLoader, @Inject DataChannelMetaData metaData) {
        this.logger = logger;
        this.projectSaver = projectSaver;
        this.dataSourceFactory = dataSourceFactory;
        this.adapterFactory = adapterFactory;
        this.mapLoader = mapLoader;
        this.mergerTokenFactoryProvider = mergerTokenFactoryProvider;
        this.metaData = metaData;
        this.dataChannelDescriptorLoader = dataChannelDescriptorLoader;
    }

    protected static List<MergerToken> sort(List<MergerToken> reverse) {
        Collections.sort(reverse);
        return reverse;
    }

    public static void flattenManyToManyRelationships(DataMap map, Collection<ObjEntity> loadedObjEntities, ObjectNameGenerator objectNameGenerator) {
        if (loadedObjEntities.isEmpty()) {
            return;
        }
        LinkedList<ObjEntity> entitiesForDelete = new LinkedList<ObjEntity>();
        for (ObjEntity curEntity : loadedObjEntities) {
            ManyToManyCandidateEntity entity = ManyToManyCandidateEntity.build(curEntity);
            if (entity == null) continue;
            entity.optimizeRelationships(objectNameGenerator);
            entitiesForDelete.add(curEntity);
        }
        for (ObjEntity curDeleteEntity : entitiesForDelete) {
            map.removeObjEntity(curDeleteEntity.getName(), true);
        }
        loadedObjEntities.removeAll(entitiesForDelete);
    }

    @Override
    public void execute(DbImportConfiguration config) throws Exception {
        this.commit(config, this.loadDataMap(config));
    }

    protected DbAdapter createAdapter(DataNodeDescriptor dataNodeDescriptor, DataSource dataSource) throws Exception {
        DbAdapter adapter = this.adapterFactory.createAdapter(dataNodeDescriptor, dataSource);
        adapter.getPkGenerator();
        return adapter;
    }

    protected void commit(DbImportConfiguration config, DataMap sourceDataMap) throws Exception {
        if (this.hasChanges) {
            DataMap targetDataMap = this.loadedDataMap;
            this.syncDataMapProperties(targetDataMap, config);
            this.applyTokens(targetDataMap, this.tokens, config);
            this.saveLoaded(targetDataMap, config);
            this.loadedDataMap = null;
            this.hasChanges = false;
        }
    }

    protected DataMap loadDataMap(DbImportConfiguration config) throws Exception {
        DataMap sourceDataMap;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DB connection: " + config.getDataSourceInfo());
            this.logger.debug(String.valueOf(config));
        }
        DataNodeDescriptor dataNodeDescriptor = config.createDataNodeDescriptor();
        DataSource dataSource = this.dataSourceFactory.getDataSource(dataNodeDescriptor);
        DbAdapter adapter = this.createAdapter(dataNodeDescriptor, dataSource);
        DataMap targetDataMap = this.existingTargetMap(config);
        ReverseEngineering dataMapReverseEngineering = (ReverseEngineering)this.metaData.get((ConfigurationNode)targetDataMap, ReverseEngineering.class);
        if (config.isUseDataMapReverseEngineering() && dataMapReverseEngineering != null) {
            this.putReverseEngineeringToConfig(dataMapReverseEngineering, config, dataSource, adapter);
        }
        if (dataMapReverseEngineering != null && !config.isUseDataMapReverseEngineering()) {
            this.logger.warn("Found several dbimport configs. DataMap dbimport config was skipped. Configuration selected from build file");
        }
        if (dataMapReverseEngineering == null && config.isUseDataMapReverseEngineering()) {
            this.logger.warn("Missing dbimport config. Database is imported completely.");
        }
        try (Connection connection = dataSource.getConnection();){
            sourceDataMap = this.load(config, adapter, connection);
        }
        if (targetDataMap == null) {
            String path = config.getTargetDataMap() == null ? "null" : config.getTargetDataMap().getAbsolutePath() + "'";
            this.logger.info("");
            this.logger.info("Map file does not exist. Loaded db model will be saved into '" + path);
            this.hasChanges = true;
            targetDataMap = this.newTargetDataMap(config);
        }
        this.loadedDataMap = targetDataMap;
        this.transformSourceBeforeMerge(sourceDataMap, targetDataMap, config);
        MergerTokenFactory mergerTokenFactory = (MergerTokenFactory)this.mergerTokenFactoryProvider.get(adapter);
        DbLoaderConfiguration loaderConfig = config.getDbLoaderConfig();
        this.tokens = DataMapMerger.builder(mergerTokenFactory).filters(loaderConfig.getFiltersConfig()).skipPKTokens(loaderConfig.isSkipPrimaryKeyLoading()).skipRelationshipsTokens(loaderConfig.isSkipRelationshipsLoading()).build().createMergeTokens(targetDataMap, sourceDataMap);
        this.tokens = this.log(DefaultDbImportAction.sort(this.reverse(mergerTokenFactory, this.tokens)));
        this.hasChanges |= this.checkDataMapProperties(targetDataMap, config);
        this.hasChanges |= this.hasTokensToImport(this.tokens);
        return sourceDataMap;
    }

    private void putReverseEngineeringToConfig(ReverseEngineering reverseEngineering, DbImportConfiguration config, DataSource dataSource, DbAdapter dbAdapter) throws SQLException {
        config.setSkipRelationshipsLoading(reverseEngineering.getSkipRelationshipsLoading());
        config.setSkipPrimaryKeyLoading(reverseEngineering.getSkipPrimaryKeyLoading());
        config.setStripFromTableNames(reverseEngineering.getStripFromTableNames());
        config.setTableTypes(reverseEngineering.getTableTypes());
        config.setMeaningfulPkTables(reverseEngineering.getMeaningfulPkTables());
        config.setNamingStrategy(reverseEngineering.getNamingStrategy());
        config.setFiltersConfig(new FiltersConfigBuilder(new ReverseEngineering(reverseEngineering)).dataSource(dataSource).dbAdapter(dbAdapter).build());
        config.setForceDataMapCatalog(reverseEngineering.isForceDataMapCatalog());
        config.setForceDataMapSchema(reverseEngineering.isForceDataMapSchema());
        config.setDefaultPackage(reverseEngineering.getDefaultPackage());
        config.setUseJava7Types(reverseEngineering.isUseJava7Types());
    }

    protected void transformSourceBeforeMerge(DataMap sourceDataMap, DataMap targetDataMap, DbImportConfiguration configuration) {
        if (configuration.isForceDataMapCatalog()) {
            String catalog = targetDataMap.getDefaultCatalog();
            for (DbEntity e : sourceDataMap.getDbEntities()) {
                e.setCatalog(catalog);
            }
        }
        if (configuration.isForceDataMapSchema()) {
            String schema = targetDataMap.getDefaultSchema();
            for (DbEntity e : sourceDataMap.getDbEntities()) {
                e.setSchema(schema);
            }
        }
    }

    public boolean hasTokensToImport(Collection<MergerToken> tokens) {
        if (tokens.isEmpty()) {
            this.logger.info("");
            this.logger.info("Detected changes: No changes to import.");
            return false;
        }
        return true;
    }

    private boolean checkDataMapProperties(DataMap targetDataMap, DbImportConfiguration config) {
        String defaultPackage = config.getDefaultPackage();
        if (defaultPackage == null || Util.isBlank((CharSequence)defaultPackage)) {
            return false;
        }
        return defaultPackage.equals(targetDataMap.getDefaultPackage());
    }

    private void syncDataMapProperties(DataMap targetDataMap, DbImportConfiguration config) {
        String defaultPackage = config.getDefaultPackage();
        if (defaultPackage == null || Util.isBlank((CharSequence)defaultPackage)) {
            return;
        }
        targetDataMap.setDefaultPackage(defaultPackage);
    }

    private void relationshipsSanity(DataMap executed) {
        for (ObjEntity objEntity : executed.getObjEntities()) {
            LinkedList rels = new LinkedList(objEntity.getRelationships());
            for (ObjRelationship rel : rels) {
                if (rel.getSourceEntity() != null && rel.getTargetEntity() != null) continue;
                this.logger.error("Incorrect obj relationship source or target entity is null: " + rel);
                objEntity.removeRelationship(rel.getName());
            }
        }
    }

    protected Collection<MergerToken> log(List<MergerToken> tokens) {
        this.logger.info("");
        if (tokens.isEmpty()) {
            this.logger.info("Detected changes: No changes to import.");
            return tokens;
        }
        this.logger.info("Detected changes: ");
        for (MergerToken token : tokens) {
            this.logger.info(String.format("    %-20s %s", token.getTokenName(), token.getTokenValue()));
        }
        this.logger.info("");
        return tokens;
    }

    protected DataMap existingTargetMap(DbImportConfiguration configuration) throws IOException {
        File file = configuration.getTargetDataMap();
        if (file != null && file.exists() && file.canRead()) {
            URLResource configurationResource = new URLResource(file.toURI().toURL());
            DataMap dataMap = this.mapLoader.load((Resource)configurationResource);
            dataMap.setNamespace((MappingNamespace)new EntityResolver(Collections.singleton(dataMap)));
            dataMap.setConfigurationSource((Resource)configurationResource);
            return dataMap;
        }
        return null;
    }

    protected DataMap newTargetDataMap(DbImportConfiguration config) throws IOException {
        CatalogFilter[] catalogs;
        DataMap dataMap = new DataMap();
        dataMap.setName(config.getDataMapName());
        dataMap.setConfigurationSource((Resource)new URLResource(config.getTargetDataMap().toURI().toURL()));
        dataMap.setNamespace((MappingNamespace)new EntityResolver(Collections.singleton(dataMap)));
        String defaultPackage = config.getDefaultPackage();
        if (defaultPackage != null && defaultPackage.length() > 0) {
            dataMap.setDefaultPackage(defaultPackage);
        }
        if ((catalogs = config.getDbLoaderConfig().getFiltersConfig().getCatalogs()).length == 1) {
            String schema;
            SchemaFilter[] schemas;
            String catalog = catalogs[0].name;
            if (catalog != null && catalog.length() > 0 && catalog.indexOf(37) < 0) {
                dataMap.setDefaultCatalog(catalog);
            }
            if ((schemas = catalogs[0].schemas).length == 1 && (schema = schemas[0].name) != null && schema.length() > 0 && schema.indexOf(37) < 0) {
                dataMap.setDefaultSchema(schema);
            }
        }
        return dataMap;
    }

    private List<MergerToken> reverse(MergerTokenFactory mergerTokenFactory, Iterable<MergerToken> mergeTokens) {
        LinkedList<MergerToken> tokens = new LinkedList<MergerToken>();
        for (MergerToken token : mergeTokens) {
            if (token instanceof AbstractToModelToken) continue;
            tokens.add(token.createReverse(mergerTokenFactory));
        }
        return tokens;
    }

    private void applyTokens(DataMap targetDataMap, Collection<MergerToken> tokens, DbImportConfiguration config) {
        if (tokens.isEmpty()) {
            this.logger.info("");
            this.logger.info("Detected changes: No changes to import.");
        }
        final LinkedList<ObjEntity> loadedObjEntities = new LinkedList<ObjEntity>();
        ProxyModelMergeDelegate mergeDelegate = new ProxyModelMergeDelegate(config.createMergeDelegate()){

            @Override
            public void objEntityAdded(ObjEntity ent) {
                loadedObjEntities.add(ent);
                super.objEntityAdded(ent);
            }
        };
        ObjectNameGenerator nameGenerator = config.createNameGenerator();
        MergerContext mergerContext = MergerContext.builder(targetDataMap).delegate(mergeDelegate).nameGenerator(nameGenerator).usingJava7Types(config.isUseJava7Types()).meaningfulPKFilter(config.createMeaningfulPKFilter()).build();
        for (MergerToken token : tokens) {
            try {
                token.execute(mergerContext);
            }
            catch (Throwable th) {
                String message = "Migration Error. Can't apply changes from token: " + token.getTokenName() + " (" + token.getTokenValue() + ")";
                this.logger.error(message, th);
                mergerContext.getValidationResult().addFailure((ValidationFailure)new SimpleValidationFailure((Object)th, (Object)message));
            }
        }
        ValidationResult failures = mergerContext.getValidationResult();
        if (failures.hasFailures()) {
            this.logger.info("Migration Complete.");
            this.logger.warn("Migration finished. The following problem(s) were encountered and ignored.");
            for (ValidationFailure failure : failures.getFailures()) {
                this.logger.warn(failure.toString());
            }
        } else {
            this.logger.info("Migration Complete Successfully.");
        }
        DefaultDbImportAction.flattenManyToManyRelationships(targetDataMap, loadedObjEntities, nameGenerator);
        this.relationshipsSanity(targetDataMap);
    }

    protected void logMessages(List<String> messages) {
        messages.forEach(arg_0 -> ((Logger)this.logger).info(arg_0));
    }

    protected void saveLoaded(DataMap dataMap, DbImportConfiguration config) throws MalformedURLException {
        ConfigurationTree projectRoot;
        if (config.getCayenneProject() == null) {
            projectRoot = new ConfigurationTree((ConfigurationNode)dataMap);
        } else {
            DataChannelDescriptor dataChannelDescriptor;
            if (config.getCayenneProject().exists()) {
                URLResource configurationResource = new URLResource(config.getCayenneProject().toURI().toURL());
                ConfigurationTree configurationTree = this.dataChannelDescriptorLoader.load((Resource)configurationResource);
                if (!configurationTree.getLoadFailures().isEmpty()) {
                    throw new CayenneRuntimeException("Unable to load cayenne project %s, %s", new Object[]{config.getCayenneProject(), ((ValidationFailure)configurationTree.getLoadFailures().iterator().next()).getDescription()});
                }
                dataChannelDescriptor = (DataChannelDescriptor)configurationTree.getRootNode();
                DataMap oldDataMap = dataChannelDescriptor.getDataMap(dataMap.getName());
                if (oldDataMap != null) {
                    dataChannelDescriptor.getDataMaps().remove(oldDataMap);
                }
            } else {
                dataChannelDescriptor = new DataChannelDescriptor();
                dataChannelDescriptor.setName(this.getProjectNameFromFileName(config.getCayenneProject().getName()));
                dataChannelDescriptor.setConfigurationSource((Resource)new URLResource(config.getCayenneProject().toURI().toURL()));
                this.logger.info("Project file does not exist. New project will be saved into '" + config.getCayenneProject().getAbsolutePath());
            }
            dataChannelDescriptor.getDataMaps().add(dataMap);
            projectRoot = new ConfigurationTree((ConfigurationNode)dataChannelDescriptor);
        }
        Project project = new Project(projectRoot);
        this.projectSaver.save(project);
        this.logger.info("");
        this.logger.info("All changes saved.");
    }

    protected String getProjectNameFromFileName(String fileName) {
        int xmlExtPosition = fileName.lastIndexOf(".xml");
        String name = fileName.substring(0, xmlExtPosition == -1 ? fileName.length() : xmlExtPosition);
        if (fileName.startsWith("cayenne-")) {
            name = name.substring("cayenne-".length());
        }
        return name;
    }

    protected DataMap load(DbImportConfiguration config, DbAdapter adapter, Connection connection) throws Exception {
        return this.createDbLoader(adapter, connection, config).load();
    }

    protected DbLoader createDbLoader(DbAdapter adapter, Connection connection, DbImportConfiguration config) {
        return new DbLoader(adapter, connection, config.getDbLoaderConfig(), config.createLoaderDelegate(), config.createNameGenerator());
    }
}

