/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc.reader;

import java.sql.ResultSet;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.reader.BaseRowReader;
import org.apache.cayenne.access.jdbc.reader.DataRowPostProcessor;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.util.Util;

class IdRowReader<T>
extends BaseRowReader<T> {
    protected int[] pkIndices;

    public IdRowReader(RowDescriptor descriptor, QueryMetadata queryMetadata, EntityResultSegment resultMetadata, DataRowPostProcessor postProcessor) {
        super(descriptor, queryMetadata, postProcessor);
        int offset;
        DbEntity dbEntity;
        DbEntity dbEntity2 = dbEntity = resultMetadata == null ? queryMetadata.getDbEntity() : resultMetadata.getClassDescriptor().getEntity().getDbEntity();
        if (dbEntity == null) {
            throw new CayenneRuntimeException("Null root DbEntity, can't index PK", new Object[0]);
        }
        int len = dbEntity.getPrimaryKeys().size();
        if (len == 0) {
            throw new CayenneRuntimeException("Root DBEntity has no PK defined: %s", dbEntity);
        }
        ColumnDescriptor[] columns = descriptor.getColumns();
        int[] pk = new int[len];
        int j = 0;
        for (int i = offset = resultMetadata != null ? resultMetadata.getColumnOffset() : 0; i < offset + len; ++i) {
            DbAttribute a = (DbAttribute)dbEntity.getAttribute(columns[i].getName());
            if (a == null || !a.isPrimaryKey()) continue;
            pk[j++] = i;
        }
        this.pkIndices = pk;
    }

    @Override
    public T readRow(ResultSet resultSet) {
        try {
            if (this.pkIndices.length == 1) {
                return this.readSingleId(resultSet);
            }
            return this.readIdMap(resultSet);
        }
        catch (CayenneRuntimeException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            throw new CayenneRuntimeException("Exception materializing id column.", Util.unwindException(otherex), new Object[0]);
        }
    }

    private T readSingleId(ResultSet resultSet) throws Exception {
        int index = this.pkIndices[0];
        Object val = this.converters[index].materializeObject(resultSet, index + 1, this.types[index]);
        return val;
    }

    private T readIdMap(ResultSet resultSet) throws Exception {
        DataRow idRow = new DataRow(2);
        idRow.setEntityName(this.entityName);
        for (int index : this.pkIndices) {
            Object val = this.converters[index].materializeObject(resultSet, index + 1, this.types[index]);
            idRow.put(this.labels[index], val);
        }
        if (this.postProcessor != null) {
            this.postProcessor.postprocessRow(resultSet, idRow);
        }
        return (T)idRow;
    }
}

