/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dbsync.merge.AbstractMerger;
import org.apache.cayenne.dbsync.merge.MergerDictionaryDiff;
import org.apache.cayenne.dbsync.merge.MergerDiffPair;
import org.apache.cayenne.dbsync.merge.ProcedureDictionary;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfig;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;

public class ProcedureMerger
extends AbstractMerger<DataMap, Procedure> {
    private final FiltersConfig filtersConfig;
    private DataMap originalDataMap;
    private DataMap importedDataMap;

    ProcedureMerger(MergerTokenFactory tokenFactory, DataMap original, DataMap imported, FiltersConfig filtersConfig) {
        super(tokenFactory);
        this.filtersConfig = filtersConfig;
        this.originalDataMap = original;
        this.importedDataMap = imported;
    }

    @Override
    public List<MergerToken> createMergeTokens() {
        return this.createMergeTokens(this.originalDataMap, this.importedDataMap);
    }

    @Override
    MergerDictionaryDiff<Procedure> createDiff(DataMap original, DataMap imported) {
        return new MergerDictionaryDiff.Builder<Procedure>().originalDictionary(new ProcedureDictionary(original, this.filtersConfig)).importedDictionary(new ProcedureDictionary(imported, this.filtersConfig)).build();
    }

    @Override
    Collection<MergerToken> createTokensForMissingOriginal(Procedure imported) {
        return Collections.singletonList(this.getTokenFactory().createDropProcedureToDb(imported));
    }

    @Override
    Collection<MergerToken> createTokensForMissingImported(Procedure original) {
        return Collections.singletonList(this.getTokenFactory().createAddProcedureToDb(original));
    }

    @Override
    Collection<MergerToken> createTokensForSame(MergerDiffPair<Procedure> same) {
        Procedure imported;
        Procedure original = same.getOriginal();
        if (this.needToCreateTokens(original, imported = same.getImported())) {
            ArrayList<MergerToken> tokens = new ArrayList<MergerToken>();
            tokens.add(this.getTokenFactory().createAddProcedureToDb(original));
            tokens.add(this.getTokenFactory().createDropProcedureToDb(imported));
            return tokens;
        }
        return null;
    }

    private boolean needToCreateTokens(Procedure original, Procedure imported) {
        List<ProcedureParameter> originalParams = original.getCallParameters();
        List<ProcedureParameter> importedParams = imported.getCallParameters();
        if (originalParams.size() != importedParams.size()) {
            return true;
        }
        for (ProcedureParameter oP : originalParams) {
            boolean found = false;
            for (ProcedureParameter iP : importedParams) {
                if (!oP.getName().equals(iP.getName()) || oP.getType() != iP.getType() || oP.getPrecision() != iP.getPrecision() || oP.getMaxLength() != iP.getMaxLength() || oP.getDirection() != iP.getDirection()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }
}

