/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.model;

import org.apache.cayenne.dbsync.merge.context.MergerContext;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.model.AbstractToModelToken;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;

public class AddColumnToModel
extends AbstractToModelToken.EntityAndColumn {
    public AddColumnToModel(DbEntity entity, DbAttribute column) {
        super("Add Column", 55, entity, column);
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createDropColumnToDb(this.getEntity(), this.getColumn());
    }

    @Override
    public void execute(MergerContext mergerContext) {
        this.getEntity().addAttribute(this.getColumn());
        for (ObjEntity e : this.getMappedObjEntities()) {
            mergerContext.getEntityMergeSupport().synchronizeOnDbAttributeAdded(e, this.getColumn());
        }
        mergerContext.getDelegate().dbAttributeAdded(this.getColumn());
    }
}

