/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneAction;

public abstract class BaseViewEntityAction
extends CayenneAction {
    protected abstract Entity<?, ?, ?> getEntity();

    public BaseViewEntityAction(String name, Application application) {
        super(name, application);
    }

    @Override
    public void performAction(ActionEvent e) {
        this.viewEntity();
    }

    protected void viewEntity() {
        Entity<?, ?, ?> entity = this.getEntity();
        if (entity != null) {
            this.navigateToEntity(entity);
        }
    }

    public void navigateToEntity(Entity<?, ?, ?> entity) {
        TreePath path = BaseViewEntityAction.buildTreePath(entity);
        BaseViewEntityAction.editor().getProjectTreeView().getSelectionModel().setSelectionPath(path);
        EntityDisplayEvent event = new EntityDisplayEvent((Object)BaseViewEntityAction.editor().getProjectTreeView(), entity, entity.getDataMap(), (DataChannelDescriptor)this.getProjectController().getProject().getRootNode());
        if (entity instanceof DbEntity) {
            this.getProjectController().fireDbEntityDisplayEvent(event);
        } else if (entity instanceof ObjEntity) {
            this.getProjectController().fireObjEntityDisplayEvent(event);
        }
    }
}

