/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.util.List;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.dbimport.TreeManipulationAction;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportSorter;

public class SortNodesAction
extends TreeManipulationAction {
    private static final String ACTION_NAME = "Sort";
    private static final String ICON_NAME = "icon-dbi-sort.png";

    public SortNodesAction(Application application) {
        super(ACTION_NAME, application);
    }

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    @Override
    public void performAction(ActionEvent e) {
        this.tree.stopEditing();
        ReverseEngineering reverseEngineeringOldCopy = new ReverseEngineering(this.tree.getReverseEngineering());
        List<DbImportTreeNode> treeExpandList = this.tree.getTreeExpandList();
        DbImportSorter.sortSubtree(this.tree.getRootNode(), DbImportSorter.NODE_COMPARATOR_BY_TYPE_BY_NAME);
        this.putReverseEngineeringToUndoManager(reverseEngineeringOldCopy);
        this.getProjectController().setDirty(true);
        this.tree.reloadModelKeepingExpanded();
        this.tree.expandTree(treeExpandList);
    }
}

