/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action.dbimport;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.dbimport.TreeManipulationAction;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportModel;
import org.apache.cayenne.modeler.editor.dbimport.DbImportSorter;

public class DragAndDropNodeAction
extends TreeManipulationAction {
    private static final String ACTION_NAME = "DragAndDrop";
    private DbImportTreeNode[] nodes;
    private DbImportTreeNode dropLocationParentNode;
    private DbImportTreeNode sourceParentNode;
    private JTree.DropLocation dropLocation;

    public DragAndDropNodeAction(Application application) {
        super(ACTION_NAME, application);
    }

    @Override
    public void performAction(ActionEvent e) {
        if (this.dropLocationDuplicateFound()) {
            return;
        }
        DbImportModel model = (DbImportModel)this.tree.getModel();
        ReverseEngineering reverseEngineeringOldCopy = new ReverseEngineering(this.tree.getReverseEngineering());
        List<DbImportTreeNode> nodesToExpand = Arrays.stream(this.nodes).filter(node -> this.tree.isExpanded(new TreePath(node.getPath()))).collect(Collectors.toList());
        for (DbImportTreeNode node2 : this.nodes) {
            if (!this.checkDropPossibility(node2)) continue;
            int index = this.calculateDropIndex();
            model.removeNodeFromParent(node2);
            model.insertNodeInto(node2, this.dropLocationParentNode, index);
        }
        this.getProjectController().setDirty(true);
        DbImportSorter.syncUserObjectItems(this.dropLocationParentNode);
        DbImportSorter.syncUserObjectItems(this.sourceParentNode);
        this.putReverseEngineeringToUndoManager(reverseEngineeringOldCopy);
        this.tree.reloadModelKeepingExpanded(this.dropLocationParentNode);
        this.tree.expandTree(nodesToExpand);
    }

    private boolean dropLocationDuplicateFound() {
        for (DbImportTreeNode node : this.nodes) {
            int duplicateIndex;
            if (this.dropLocationParentNode.isNodeChild(node) || (duplicateIndex = this.dropLocationParentNode.getChildNodes().indexOf(node)) < 0) continue;
            JOptionPane.showMessageDialog(Application.getFrame(), this.dropLocationParentNode.getSimpleNodeName() + " already contains " + node.getSimpleNodeName(), "Error moving", 0);
            return true;
        }
        return false;
    }

    private int calculateDropIndex() {
        int index = this.dropLocation.getChildIndex();
        if (this.sourceParentNode == this.dropLocationParentNode) {
            int childCount = this.dropLocationParentNode.getChildCount();
            int childIndex = this.dropLocation.getChildIndex();
            if (childIndex == childCount) {
                index = childCount - 1;
            }
        }
        if (index == -1 && this.sourceParentNode != this.dropLocationParentNode) {
            index = this.dropLocationParentNode.getChildCount();
        }
        if (index == -1 && this.sourceParentNode == this.dropLocationParentNode) {
            index = 0;
        }
        return index;
    }

    private boolean checkDropPossibility(DbImportTreeNode node) {
        if (node == this.dropLocationParentNode) {
            return false;
        }
        for (DbImportTreeNode childNode : node.getChildNodes()) {
            if (!this.isNodeAncestor(childNode, this.dropLocationParentNode)) continue;
            return false;
        }
        return true;
    }

    private boolean isNodeAncestor(DbImportTreeNode node1, DbImportTreeNode node2) {
        if (node2 == null) {
            return false;
        }
        if (node2.getParent() == node1) {
            return true;
        }
        return this.isNodeAncestor(node1, node2.getParent());
    }

    public void setNodes(DbImportTreeNode[] nodes) {
        this.nodes = nodes;
    }

    public void setDropLocationParentNode(DbImportTreeNode dropLocationParentNode) {
        this.dropLocationParentNode = dropLocationParentNode;
    }

    public void setSourceParentNode(DbImportTreeNode sourceParentNode) {
        this.sourceParentNode = sourceParentNode;
    }

    public void setDropLocation(JTree.DropLocation dropLocation) {
        this.dropLocation = dropLocation;
    }
}

