/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JTable;
import org.apache.cayenne.modeler.action.FindAction;
import org.apache.cayenne.modeler.dialog.FindDialogView;
import org.apache.cayenne.modeler.util.CayenneController;

public class FindDialog
extends CayenneController {
    private FindDialogView view;
    private List<FindAction.SearchResultEntry> searchResults;

    public FindDialog(CayenneController parent, List<FindAction.SearchResultEntry> searchResults) {
        super(parent);
        this.searchResults = searchResults;
        this.view = new FindDialogView(searchResults);
        this.initBindings();
    }

    public void startupAction() {
        this.view.pack();
        this.centerView();
        this.makeCloseableOnEscape();
        this.view.setDefaultCloseOperation(2);
        this.view.setVisible(true);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        this.view.getOkButton().addActionListener(e -> this.view.dispose());
        JTable table = this.view.getTable();
        table.setRowHeight(24);
        table.setRowMargin(3);
        JumpToResultActionListener listener = new JumpToResultActionListener();
        table.addKeyListener(listener);
        table.addMouseListener(listener);
        table.getSelectionModel().setSelectionInterval(0, 0);
    }

    private class JumpToResultActionListener
    implements MouseListener,
    KeyListener {
        private JumpToResultActionListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.openResult(e);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() != 10) {
                return;
            }
            this.openResult(e);
        }

        private void openResult(InputEvent e) {
            JTable table = (JTable)e.getSource();
            Integer selectedLine = table.getSelectionModel().getLeadSelectionIndex();
            FindAction.jumpToResult(FindDialog.this.searchResults.get(selectedLine));
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }
}

